/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.modules.search.CleanTask;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchDisplayer;
import org.netbeans.modules.search.SearchTask;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openidex.search.SearchGroup;

final class Manager {
    private static final int CLEANUP_TIMEOUT_MILLIS = 3000;
    static final int NO_TASK = 0;
    static final int SEARCHING = 1;
    static final int CLEANING_RESULT = 2;
    static final int PRINTING_DETAILS = 4;
    static final int REPLACING = 8;
    static final int EVENT_SEARCH_STARTED = 1;
    static final int EVENT_SEARCH_FINISHED = 2;
    static final int EVENT_SEARCH_INTERRUPTED = 3;
    static final int EVENT_SEARCH_CANCELLED = 4;
    private static final Manager instance = new Manager();
    private boolean moduleBeingUninstalled = false;
    private final Object lock = new Object();
    private int state = 0;
    private int pendingTasks = 0;
    private TaskListener taskListener;
    private SearchTask currentSearchTask;
    private SearchTask pendingSearchTask;
    private SearchTask lastSearchTask;
    private ReplaceTask currentReplaceTask;
    private ReplaceTask pendingReplaceTask;
    private PrintDetailsTask currentPrintDetailsTask;
    private PrintDetailsTask pendingPrintDetailsTask;
    private Task searchTask;
    private Task replaceTask;
    private Task cleanResultTask;
    private Task printDetailsTask;
    private ResultModel resultModelToClean;
    private boolean searchWindowOpen = false;
    private Reference outputWriterRef;

    static Manager getInstance() {
        return instance;
    }

    private Manager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleSearchTask(SearchTask task) {
        assert (EventQueue.isDispatchThread());
        Object object = this.lock;
        synchronized (object) {
            ResultView.getInstance().setResultModel(null);
            if (this.currentSearchTask != null) {
                this.currentSearchTask.stop(false);
            }
            if (this.resultModelToClean != null) {
                this.pendingTasks |= 2;
            }
            this.pendingTasks |= 1;
            this.pendingSearchTask = task;
            this.lastSearchTask = task;
            if (this.state == 0) {
                this.processNextPendingTask();
            } else {
                this.notifySearchPending(this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleReplaceTask(ReplaceTask task) {
        assert (EventQueue.isDispatchThread());
        Object object = this.lock;
        synchronized (object) {
            assert (this.state == 0 && this.pendingTasks == 0);
            this.pendingTasks |= 8;
            this.pendingReplaceTask = task;
            this.processNextPendingTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleSearchTaskRerun() {
        assert (EventQueue.isDispatchThread());
        Object object = this.lock;
        synchronized (object) {
            SearchTask newSearchTask = this.lastSearchTask.createNewGeneration();
            this.lastSearchTask = null;
            this.scheduleSearchTask(newSearchTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedulePrintingDetails(Object[] matchingObjects, SearchGroup searchGroup) {
        Object object = this.lock;
        synchronized (object) {
            assert (this.state == 0);
            this.pendingTasks |= 4;
            this.pendingPrintDetailsTask = new PrintDetailsTask(matchingObjects, searchGroup);
            this.processNextPendingTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String mayStartSearching() {
        boolean replacing;
        Object object = this.lock;
        synchronized (object) {
            replacing = this.state == 8;
        }
        String msgKey = replacing ? "MSG_Cannot_start_search__replacing" : null;
        return msgKey != null ? NbBundle.getMessage(this.getClass(), (String)msgKey) : null;
    }

    private void notifySearchStarted() {
        this.notifySearchTaskStateChange(1);
    }

    private void notifySearchFinished() {
        this.notifySearchTaskStateChange(2);
    }

    private void notifySearchInterrupted() {
        this.notifySearchTaskStateChange(3);
    }

    private void notifySearchCancelled() {
        this.notifySearchTaskStateChange(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySearchTaskStateChange(int changeType) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.searchWindowOpen) {
                return;
            }
        }
        this.callOnWindowFromAWT("searchTaskStateChanged", new Integer(changeType));
    }

    private void notifySearchPending(int blockingTask) {
        if (!this.searchWindowOpen) {
            return;
        }
        this.callOnWindowFromAWT("notifySearchPending", new Integer(blockingTask));
    }

    private void notifyReplaceFinished() {
        assert (Thread.holdsLock(this.lock));
        assert (this.currentReplaceTask != null);
        ReplaceTask.ResultStatus resultStatus = this.currentReplaceTask.getResultStatus();
        if (resultStatus == ReplaceTask.ResultStatus.SUCCESS) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"MSG_Success"));
            if (this.searchWindowOpen) {
                this.callOnWindowFromAWT("closeAndSendFocusToEditor", false);
            }
        } else {
            String msgKey = resultStatus == ReplaceTask.ResultStatus.PRE_CHECK_FAILED ? "MSG_Issues_found_during_precheck" : "MSG_Issues_found_during_replace";
            String title = NbBundle.getMessage(this.getClass(), (String)msgKey);
            this.displayIssuesFromAWT(title, this.currentReplaceTask.getProblems(), resultStatus != ReplaceTask.ResultStatus.PRE_CHECK_FAILED);
            if (resultStatus == ReplaceTask.ResultStatus.PRE_CHECK_FAILED) {
                this.offerRescanAfterIssuesFound();
            }
        }
    }

    private void offerRescanAfterIssuesFound() {
        assert (Thread.holdsLock(this.lock));
        assert (this.currentReplaceTask != null);
        String msg = NbBundle.getMessage(this.getClass(), (String)"MSG_IssuesFound_Rescan_");
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 3);
        String rerunOption = NbBundle.getMessage(this.getClass(), (String)"LBL_Rerun");
        nd.setOptions(new Object[]{rerunOption, NotifyDescriptor.CANCEL_OPTION});
        Object dlgResult = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (rerunOption.equals(dlgResult)) {
            this.callOnWindowFromAWT("rescan", false);
        }
    }

    private void notifyPrintingDetailsFinished() {
        if (!this.searchWindowOpen) {
            return;
        }
        this.callOnWindowFromAWT("showAllDetailsFinished");
    }

    private void activateResultWindow() {
        Method theMethod;
        try {
            theMethod = ResultView.class.getMethod("requestActive", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(theMethod, null);
    }

    private void displayIssuesFromAWT(String title, String[] issues, boolean att) {
        Method theMethod;
        try {
            theMethod = ResultView.class.getDeclaredMethod("displayIssuesToUser", String.class, String[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        this.callOnWindowFromAWT(theMethod, new Object[]{title, issues, att}, false);
    }

    private void callOnWindowFromAWT(String methodName) {
        this.callOnWindowFromAWT(methodName, true);
    }

    private void callOnWindowFromAWT(String methodName, boolean wait) {
        Method theMethod;
        try {
            theMethod = ResultView.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(theMethod, null, wait);
    }

    private void callOnWindowFromAWT(String methodName, Object param) {
        this.callOnWindowFromAWT(methodName, param, true);
    }

    private void callOnWindowFromAWT(String methodName, Object param, boolean wait) {
        Method theMethod = null;
        Method[] methods = ResultView.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            Method method = methods[i];
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            Class<?> paramType = parameterTypes[0];
            if (!(param == null && !paramType.isPrimitive() || paramType == Integer.TYPE && param instanceof Integer) && !parameterTypes[0].isInstance(param)) continue;
            theMethod = method;
        }
        if (theMethod == null) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(theMethod, new Object[]{param}, wait);
    }

    private void callOnWindowFromAWT(Method method, Object[] params) {
        this.callOnWindowFromAWT(method, params, true);
    }

    private void callOnWindowFromAWT(final Method method, final Object[] params, boolean wait) {
        Runnable runnable = new Runnable(){

            public void run() {
                ResultView resultViewInstance = ResultView.getInstance();
                try {
                    method.invoke((Object)resultViewInstance, params);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else if (wait) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException ex1) {
                ErrorManager.getDefault().notify((Throwable)ex1);
            }
            catch (Exception ex2) {
                ErrorManager.getDefault().notify(65536, (Throwable)ex2);
            }
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWindowOpened() {
        Object object = this.lock;
        synchronized (object) {
            this.searchWindowOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWindowClosed() {
        assert (EventQueue.isDispatchThread());
        Object object = this.lock;
        synchronized (object) {
            this.searchWindowOpen = false;
            if (this.moduleBeingUninstalled) {
                return;
            }
            if (this.currentSearchTask != null) {
                this.currentSearchTask.stop(false);
            }
            if (this.resultModelToClean != null) {
                this.pendingTasks |= 2;
            }
            this.pendingTasks &= 0xFFFFFFFE;
            this.pendingSearchTask = null;
            this.lastSearchTask = null;
            if (this.state == 0) {
                this.processNextPendingTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextPendingTask() {
        Object object = this.lock;
        synchronized (object) {
            assert (this.state == 0);
            if (this.resultModelToClean == null) {
                this.pendingTasks &= 0xFFFFFFFD;
            }
            if ((this.pendingTasks & 4) != 0) {
                if ((this.pendingTasks & 1) != 0) {
                    this.notifySearchPending(4);
                }
                this.startPrintingDetails();
            } else if ((this.pendingTasks & 2) != 0) {
                if ((this.pendingTasks & 1) != 0) {
                    this.notifySearchPending(2);
                }
                this.startCleaning();
            } else if ((this.pendingTasks & 1) != 0) {
                this.startSearching();
            } else if ((this.pendingTasks & 8) != 0) {
                this.startReplacing();
            } else assert (this.pendingTasks == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSearching() {
        Object object = this.lock;
        synchronized (object) {
            assert (this.pendingSearchTask != null);
            this.notifySearchStarted();
            ResultModel resultModel = this.pendingSearchTask.getResultModel();
            this.callOnWindowFromAWT("setResultModel", resultModel);
            this.resultModelToClean = resultModel;
            if (this.outputWriterRef != null) {
                SearchDisplayer.clearOldOutput(this.outputWriterRef);
                this.outputWriterRef = null;
                this.activateResultWindow();
            }
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.pendingSearchTask);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.currentSearchTask = this.pendingSearchTask;
            this.pendingSearchTask = null;
            this.searchTask = task;
            this.pendingTasks &= 0xFFFFFFFE;
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReplacing() {
        Object object = this.lock;
        synchronized (object) {
            assert (this.pendingReplaceTask != null);
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.pendingReplaceTask);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.currentReplaceTask = this.pendingReplaceTask;
            this.pendingReplaceTask = null;
            this.replaceTask = task;
            this.pendingTasks &= 0xFFFFFFF7;
            this.state = 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPrintingDetails() {
        Object object = this.lock;
        synchronized (object) {
            if (this.outputWriterRef != null) {
                SearchDisplayer.clearOldOutput(this.outputWriterRef);
                this.outputWriterRef = null;
            }
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this.pendingPrintDetailsTask);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.printDetailsTask = task;
            this.pendingTasks &= 0xFFFFFFFB;
            this.currentPrintDetailsTask = this.pendingPrintDetailsTask;
            this.pendingPrintDetailsTask = null;
            this.state = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleaning() {
        Object object = this.lock;
        synchronized (object) {
            CleanTask cleaner = new CleanTask(this.resultModelToClean);
            this.resultModelToClean = null;
            RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)cleaner);
            task.addTaskListener(this.getTaskListener());
            task.schedule(0);
            this.cleanResultTask = task;
            this.pendingTasks &= 0xFFFFFFFD;
            this.state = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSearching() {
        Object object = this.lock;
        synchronized (object) {
            if ((this.pendingTasks & 1) != 0) {
                this.pendingTasks &= 0xFFFFFFFE;
                this.pendingSearchTask = null;
                this.notifySearchCancelled();
            } else if (this.currentSearchTask != null) {
                this.currentSearchTask.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFinished(Task task) {
        Object object = this.lock;
        synchronized (object) {
            if (this.moduleBeingUninstalled) {
                this.allTasksFinished();
                return;
            }
            if (task == this.searchTask) {
                assert (this.state == 1);
                if (this.currentSearchTask.notifyWhenFinished()) {
                    if (this.currentSearchTask.wasInterrupted()) {
                        this.notifySearchInterrupted();
                    } else {
                        this.notifySearchFinished();
                    }
                }
                this.currentSearchTask = null;
                this.searchTask = null;
                this.state = 0;
            } else if (task == this.replaceTask) {
                assert (this.state == 8);
                this.notifyReplaceFinished();
                this.currentReplaceTask = null;
                this.replaceTask = null;
                this.state = 0;
            } else if (task == this.cleanResultTask) {
                assert (this.state == 2);
                this.cleanResultTask = null;
                this.state = 0;
            } else if (task == this.printDetailsTask) {
                assert (this.state == 4);
                this.notifyPrintingDetailsFinished();
                this.outputWriterRef = this.currentPrintDetailsTask.getOutputWriterRef();
                this.currentPrintDetailsTask = null;
                this.printDetailsTask = null;
                this.state = 0;
            } else assert (false);
            this.processNextPendingTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allTasksFinished() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCleanup() {
        Object object = this.lock;
        synchronized (object) {
            this.moduleBeingUninstalled = true;
            if (this.state != 0) {
                if (this.currentSearchTask != null) {
                    this.currentSearchTask.stop(false);
                }
                if (this.currentPrintDetailsTask != null) {
                    this.currentPrintDetailsTask.stop();
                }
                try {
                    this.lock.wait(3000L);
                }
                catch (InterruptedException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
            }
            this.callOnWindowFromAWT("closeResults");
        }
    }

    private TaskListener getTaskListener() {
        if (this.taskListener == null) {
            this.taskListener = new MyTaskListener();
        }
        return this.taskListener;
    }

    private class MyTaskListener
    implements TaskListener {
        MyTaskListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = Manager.this.lock;
            synchronized (object) {
                Manager.this.taskFinished(task);
            }
        }
    }
}

