/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.types.FullTextType;
import org.netbeans.modules.search.types.TextDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

final class MatchingObject
implements PropertyChangeListener {
    private final ResultModel resultModel;
    private final File file;
    private final long timestamp;
    final Object object;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] selectedMatches;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private StringBuilder text;
    boolean wasCrLf = false;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, Object object) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.resultModel = resultModel;
        this.object = object;
        FileObject fileObject = this.getFileObject();
        this.file = FileUtil.toFile((FileObject)fileObject);
        this.timestamp = this.file != null ? this.file.lastModified() : 0L;
        this.valid = this.timestamp != 0L;
        this.setUpDataObjValidityChecking();
    }

    private void setUpDataObjValidityChecking() {
        DataObject dataObj = (DataObject)this.object;
        if (dataObj.isValid()) {
            dataObj.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void cleanup() {
        DataObject dataObj = (DataObject)this.object;
        dataObj.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("valid".equals(e.getPropertyName()) && Boolean.FALSE.equals(e.getNewValue())) {
            assert (e.getSource() == (DataObject)this.object);
            DataObject dataObj = (DataObject)this.object;
            dataObj.removePropertyChangeListener((PropertyChangeListener)this);
            this.resultModel.objectBecameInvalid(this);
        }
    }

    boolean isObjectValid() {
        return ((DataObject)this.object).isValid();
    }

    private FileObject getFileObject() {
        return ((DataObject)this.object).getPrimaryFile();
    }

    void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        this.selectedMatches = null;
    }

    boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.selectedMatches == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.selectedMatches == null) {
            return this.selected;
        }
        boolean firstMatchSelection = this.selectedMatches[0];
        for (int i = 1; i < this.selectedMatches.length; ++i) {
            if (this.selectedMatches[i] == firstMatchSelection) continue;
            return null;
        }
        return firstMatchSelection;
    }

    void toggleSubnodeSelection(ResultModel resultModel, int index) {
        if (this.selectedMatches == null) {
            this.selectedMatches = new boolean[resultModel.getDetailsCount(this)];
            Arrays.fill(this.selectedMatches, this.selected);
        }
        this.selectedMatches[index] = !this.selectedMatches[index];
    }

    void setSubnodeSelected(int index, boolean selected, ResultModel resultModel) {
        if (this.selectedMatches == null) {
            if (selected == this.selected) {
                return;
            }
            this.selectedMatches = new boolean[resultModel.getDetailsCount(this)];
            Arrays.fill(this.selectedMatches, this.selected);
        }
        assert (index >= 0 && index < this.selectedMatches.length);
        this.selectedMatches[index] = selected;
    }

    boolean isSubnodeSelected(int index) {
        assert (this.selectedMatches == null || index >= 0 && index < this.selectedMatches.length);
        return this.selectedMatches == null ? this.selected : this.selectedMatches[index];
    }

    public boolean equals(Object anotherObject) {
        return anotherObject != null && anotherObject.getClass() == MatchingObject.class && ((MatchingObject)anotherObject).object == this.object;
    }

    public int hashCode() {
        return this.object.hashCode() + 1;
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    File getFile() {
        return this.file;
    }

    String getName() {
        return this.getFile().getName();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFile().getParent();
    }

    String getText() throws IOException {
        StringBuilder txt = this.text();
        if (txt != null) {
            return txt.toString();
        }
        return null;
    }

    private StringBuilder text() throws IOException {
        return this.text(false);
    }

    private StringBuilder text(boolean refreshCache) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (refreshCache || this.text == null) {
            this.text = this.readText();
        }
        return this.text == null ? new StringBuilder() : this.text;
    }

    private StringBuilder readText() throws IOException {
        StringBuilder ret = null;
        ByteBuffer buf = this.getByteBuffer();
        if (buf != null) {
            Matcher matcher;
            Charset charset = FullTextType.getCharset(this.getFileObject());
            CharBuffer cbuf = charset.decode(buf);
            String terminator = System.getProperty("line.separator");
            if (!terminator.equals("\n") && (matcher = Pattern.compile(terminator).matcher(cbuf)).find()) {
                this.wasCrLf = true;
                matcher.reset();
                ret = new StringBuilder(matcher.replaceAll("\n"));
            }
            if (ret == null) {
                ret = new StringBuilder(cbuf);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getByteBuffer() throws IOException {
        assert (!EventQueue.isDispatchThread());
        File file = this.getFile();
        FileInputStream str = new FileInputStream(file);
        ByteBuffer buffer = ByteBuffer.allocate((int)file.length());
        FileChannel channel = str.getChannel();
        try {
            channel.read(buffer, 0L);
        }
        catch (ClosedByInterruptException cbie) {
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            channel.close();
        }
        buffer.rewind();
        return buffer;
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus status = this.getInvalidityStatus();
        if (status != null) {
            this.valid = false;
        }
        return status;
    }

    String getInvalidityDescription() {
        InvalidityStatus status = this.getInvalidityStatus();
        String descr = status != null ? status.getDescription(this.getFile().getPath()) : null;
        return descr;
    }

    private InvalidityStatus getInvalidityStatus() {
        File f = this.getFile();
        if (!f.exists()) {
            return InvalidityStatus.DELETED;
        }
        if (f.isDirectory()) {
            return InvalidityStatus.BECAME_DIR;
        }
        long stamp = f.lastModified();
        if (stamp > this.resultModel.getCreationTime()) {
            return InvalidityStatus.CHANGED;
        }
        if (f.length() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!f.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        FullTextType fullTextType = this.resultModel.fullTextSearchType;
        if (fullTextType.getRe().length() == 0 && f.length() < (long)fullTextType.getMatchString().length()) {
            return InvalidityStatus.TOO_SHORT;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public InvalidityStatus replace() throws IOException {
        boolean shouldReplaceNone;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean uniformSelection = this.checkSubnodesSelection();
        boolean shouldReplaceAll = uniformSelection == Boolean.TRUE;
        boolean bl = shouldReplaceNone = uniformSelection == Boolean.FALSE;
        if (shouldReplaceNone) {
            return null;
        }
        StringBuilder content = this.text(true);
        List<TextDetail> textMatches = this.resultModel.fullTextSearchType.getTextDetails(this.object);
        int matchIndex = 0;
        int currLineOffset = 0;
        int currLine = 1;
        int inlineMatchNumber = 0;
        int inlineOffsetShift = 0;
        block0: for (TextDetail textDetail : textMatches) {
            int matchEndOffset;
            int matchLine = textDetail.getLine();
            while (currLine < matchLine) {
                int lfOffset = content.indexOf("\n", currLineOffset);
                if (lfOffset == -1) {
                    assert (false);
                    break block0;
                }
                currLineOffset = lfOffset + 1;
                ++currLine;
                inlineMatchNumber = 0;
                inlineOffsetShift = 0;
            }
            if (!this.isSubnodeSelected(matchIndex++)) continue;
            if (++inlineMatchNumber == 1) {
                boolean check = false;
                if (!$assertionsDisabled) {
                    check = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (check) {
                    String fileLine;
                    int lineEndOffset = content.indexOf("\n", currLineOffset);
                    String string = fileLine = lineEndOffset != -1 ? content.substring(currLineOffset, lineEndOffset) : content.substring(currLineOffset);
                    if (!fileLine.equals(textDetail.getLineText())) {
                        return InvalidityStatus.CHANGED;
                    }
                }
            }
            int matchLength = textDetail.getMarkLength();
            int matchOffset = currLineOffset + inlineOffsetShift + (textDetail.getColumn() - 1);
            if (!content.substring(matchOffset, matchEndOffset = matchOffset + matchLength).equals(textDetail.getLineText().substring(textDetail.getColumn() - 1, textDetail.getColumn() - 1 + matchLength))) {
                return InvalidityStatus.CHANGED;
            }
            content.replace(matchOffset, matchEndOffset, this.resultModel.replaceString);
            inlineOffsetShift += this.resultModel.replaceString.length() - matchLength;
        }
        return null;
    }

    void write() throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        if (this.wasCrLf) {
            String terminator = System.getProperty("line.separator");
            this.text = new StringBuilder(this.text.toString().replace("\n", terminator));
        }
        Charset charset = FullTextType.getCharset(this.getFileObject());
        ByteBuffer buffer = charset.encode(this.text.toString());
        FileOutputStream fos = new FileOutputStream(this.getFile());
        FileChannel channel = fos.getChannel();
        channel.write(buffer);
        channel.close();
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read"),
        TOO_SHORT(false, "Inv_status_Err_too_short");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean fatal, String descrBundleKey) {
            this.fatal = fatal;
            this.descrBundleKey = descrBundleKey;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String path) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)path);
        }
    }
}

