/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.types.FullTextType;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultModel {
    private static final int COUNT_LIMIT = 500;
    private static final int DETAILS_COUNT_LIMIT = 5000;
    private static final String DEF_SEARCH_TYPES_PACKAGE = "org.netbeans.modules.search.types";
    private static final String FULLTEXT_SEARCH_TYPE = "FullTextType";
    private final long creationTime;
    private int size = 0;
    private int totalDetailsCount = 0;
    private ResultTreeModel treeModel;
    private ResultView resultView;
    private boolean limitReached = false;
    private List<SearchType> searchTypeList;
    private SearchGroup searchGroup;
    private final boolean isDataObjectSearchGroup;
    final boolean defaultSearchTypesOnly;
    final boolean fullTextOnly;
    final FullTextType fullTextSearchType;
    final String replaceString;
    final boolean searchAndReplace;
    final List<MatchingObject> matchingObjects = new ArrayList<MatchingObject>();
    private String finishMessage;
    private MatchingObject infoCacheMatchingObject;
    private Boolean infoCacheHasDetails;
    private int infoCacheDetailsCount;
    private Node[] infoCacheDetailNodes;
    private final Node[] EMPTY_NODES_ARRAY = new Node[0];

    public ResultModel(List<SearchType> searchTypeList, SearchGroup searchGroup, String replaceString) {
        this.searchTypeList = searchTypeList;
        this.searchGroup = searchGroup;
        this.replaceString = replaceString;
        this.searchAndReplace = replaceString != null;
        this.isDataObjectSearchGroup = searchGroup.getClass() == DataObjectSearchGroup.class;
        boolean hasNonDefaultSearchType = false;
        FullTextType fullTextType = null;
        for (SearchType searchType : searchGroup.getSearchTypes()) {
            Class<?> searchTypeClass = searchType.getClass();
            String searchTypeName = searchTypeClass.getName();
            if (searchTypeClass == FullTextType.class) {
                fullTextType = (FullTextType)searchType;
            } else if (!searchTypeName.startsWith(DEF_SEARCH_TYPES_PACKAGE)) {
                hasNonDefaultSearchType = true;
            }
            if (hasNonDefaultSearchType && fullTextType != null) break;
        }
        this.defaultSearchTypesOnly = !hasNonDefaultSearchType;
        this.fullTextSearchType = fullTextType;
        this.fullTextOnly = (this.searchAndReplace || this.defaultSearchTypesOnly) && this.fullTextSearchType != null;
        this.creationTime = System.currentTimeMillis();
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setObserver(ResultTreeModel observer) {
        this.treeModel = observer;
    }

    void setObserver(ResultView observer) {
        this.resultView = observer;
    }

    void close() {
        if (this.matchingObjects != null && !this.matchingObjects.isEmpty()) {
            for (MatchingObject matchingObj : this.matchingObjects) {
                matchingObj.cleanup();
            }
        }
        if (this.searchTypeList != null) {
            for (SearchType searchType : this.searchTypeList) {
                if (!(searchType instanceof FullTextType)) continue;
                ((FullTextType)searchType).destroy();
            }
            this.searchTypeList.clear();
            this.searchTypeList = null;
        }
        this.searchGroup = null;
    }

    synchronized boolean objectFound(Object object) {
        MatchingObject matchingObject = new MatchingObject(this, object);
        if (!this.matchingObjects.add(matchingObject)) {
            return true;
        }
        assert (!this.limitReached);
        assert (this.treeModel != null);
        assert (this.resultView != null);
        this.totalDetailsCount += this.getDetailsCount(matchingObject);
        this.treeModel.objectFound(matchingObject, this.size++);
        this.resultView.objectFound(matchingObject, this.totalDetailsCount);
        return this.size < 500 && this.totalDetailsCount < 5000;
    }

    public void objectBecameInvalid(MatchingObject matchingObj) {
        int index = this.matchingObjects.indexOf(matchingObj);
        assert (index != -1);
        this.treeModel.objectBecameInvalid(matchingObj);
    }

    synchronized int getTotalDetailsCount() {
        return this.totalDetailsCount;
    }

    synchronized MatchingObject[] getMatchingObjects() {
        return this.matchingObjects.toArray(new MatchingObject[this.matchingObjects.size()]);
    }

    synchronized Object[] getFoundObjects() {
        Object[] foundObjects = new Object[this.matchingObjects.size()];
        int index = 0;
        for (MatchingObject matchingObj : this.matchingObjects) {
            foundObjects[index++] = matchingObj.object;
        }
        return foundObjects;
    }

    public void run() {
    }

    boolean hasDetails() {
        return this.totalDetailsCount != 0;
    }

    Boolean canHaveDetails() {
        Boolean ret = this.fullTextSearchType != null ? Boolean.TRUE : (this.defaultSearchTypesOnly ? Boolean.FALSE : null);
        return ret;
    }

    private void prepareCacheFor(MatchingObject matchingObject) {
        if (matchingObject != this.infoCacheMatchingObject) {
            this.infoCacheHasDetails = null;
            this.infoCacheDetailsCount = -1;
            this.infoCacheDetailNodes = null;
            this.infoCacheMatchingObject = matchingObject;
        }
    }

    boolean hasDetails(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheHasDetails != null) {
            return this.infoCacheHasDetails;
        }
        boolean hasDetails = this.hasDetailsReal(matchingObject);
        this.infoCacheHasDetails = hasDetails;
        assert (this.infoCacheHasDetails == Boolean.TRUE || this.infoCacheHasDetails == Boolean.FALSE);
        return hasDetails;
    }

    private boolean hasDetailsReal(MatchingObject matchingObject) {
        boolean ret;
        if (this.fullTextSearchType != null) {
            ret = true;
        } else if (this.defaultSearchTypesOnly) {
            ret = false;
        } else {
            ret = false;
            Object foundObject = matchingObject.object;
            for (SearchType searchType : this.searchGroup.getSearchTypes()) {
                Node[] detailNodes = searchType.getDetails(foundObject);
                if (detailNodes == null || detailNodes.length == 0) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    int getDetailsCount(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailsCount == -1) {
            this.infoCacheDetailsCount = this.getDetailsCountReal(matchingObject);
            if (this.infoCacheDetailsCount == 0) {
                this.infoCacheDetailNodes = this.EMPTY_NODES_ARRAY;
            }
        }
        assert (this.infoCacheDetailsCount >= 0);
        return this.infoCacheDetailsCount;
    }

    private int getDetailsCountReal(MatchingObject matchingObject) {
        if (this.defaultSearchTypesOnly) {
            return this.fullTextSearchType != null ? this.fullTextSearchType.getDetailsCount(matchingObject.object) : 0;
        }
        int count = 0;
        Object foundObject = matchingObject.object;
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            if (searchType == this.fullTextSearchType) {
                count += this.fullTextSearchType.getDetailsCount(foundObject);
                continue;
            }
            Node[] detailNodes = searchType.getDetails(foundObject);
            count += detailNodes != null ? detailNodes.length : 0;
        }
        return count;
    }

    Node[] getDetails(MatchingObject matchingObject) {
        Node[] detailNodes;
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailNodes == null) {
            detailNodes = this.getDetailsReal(matchingObject);
            this.infoCacheDetailNodes = detailNodes != null ? detailNodes : this.EMPTY_NODES_ARRAY;
            this.infoCacheDetailsCount = this.infoCacheDetailNodes.length;
        } else {
            Node[] nodeArray = detailNodes = this.infoCacheDetailNodes != this.EMPTY_NODES_ARRAY ? this.infoCacheDetailNodes : null;
        }
        assert (this.infoCacheDetailNodes != null && (this.infoCacheDetailNodes == this.EMPTY_NODES_ARRAY || this.infoCacheDetailNodes.length > 0));
        assert (detailNodes == null || detailNodes.length > 0);
        return detailNodes;
    }

    private Node[] getDetailsReal(MatchingObject matchingObject) {
        if (this.defaultSearchTypesOnly) {
            return this.fullTextSearchType != null ? this.fullTextSearchType.getDetails(matchingObject.object) : null;
        }
        Node[] nodesTotal = null;
        Object foundObject = matchingObject.object;
        for (SearchType searchType : this.searchGroup.getSearchTypes()) {
            Node[] detailNodes = searchType.getDetails(foundObject);
            if (detailNodes == null || detailNodes.length == 0) continue;
            if (nodesTotal == null) {
                nodesTotal = detailNodes;
                continue;
            }
            Node[] oldNodesTotal = nodesTotal;
            nodesTotal = new Node[nodesTotal.length + detailNodes.length];
            System.arraycopy(oldNodesTotal, 0, nodesTotal, 0, oldNodesTotal.length);
            System.arraycopy(detailNodes, 0, nodesTotal, oldNodesTotal.length, detailNodes.length);
        }
        return nodesTotal;
    }

    synchronized int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    SearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    List getEnabledSearchTypes() {
        return this.searchTypeList;
    }

    SearchType[] getQueriedSearchTypes() {
        return this.searchGroup.getSearchTypes();
    }

    boolean wasLimitReached() {
        return this.limitReached;
    }

    void searchException(RuntimeException ex) {
        ErrorManager.Annotation[] annotations = ErrorManager.getDefault().findAnnotations((Throwable)ex);
        for (int i = 0; i < annotations.length; ++i) {
            ErrorManager.Annotation annotation = annotations[i];
            if (annotation.getSeverity() != 256) continue;
            this.finishMessage = annotation.getLocalizedMessage();
            if (this.finishMessage == null) continue;
            return;
        }
        this.finishMessage = ex.getLocalizedMessage();
    }

    String getExceptionMsg() {
        return this.finishMessage;
    }
}

