/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.search.DialogLifetime;
import org.netbeans.modules.search.SearchCriterion;
import org.netbeans.modules.search.SearchProjectSettings;
import org.netbeans.modules.search.SearchTypeInputStream;
import org.netbeans.modules.search.types.FullTextCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openidex.search.SearchType;

public final class SearchTypePanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
DialogLifetime {
    public static final String PROP_CUSTOMIZED = "customized";
    private static final String MODIFICATOR_SUFFIX = " *";
    private boolean customized;
    private SearchType searchType;
    private boolean initialized = false;
    final Customizer customizer;
    final Component customizerComponent;
    private SearchCriterion[] savedCriteria;
    private String lastSavedName;
    private final JCheckBox applyCheckBox = new JCheckBox();
    private JPanel customizerPanel;
    private final JButton restoreButton = new JButton();
    private final JButton saveButton = new JButton();

    public SearchTypePanel(SearchType searchType, boolean initFromHistory) {
        this.initComponents();
        this.initAccessibility();
        this.searchType = searchType;
        this.customizer = SearchTypePanel.createCustomizer(this.searchType, initFromHistory);
        if (this.customizer != null) {
            this.customizerComponent = (Component)((Object)this.customizer);
        } else {
            this.customizerComponent = null;
            this.initialized = true;
            System.err.println("No customizer for " + this.searchType.getName() + ", skipping...");
        }
        this.customizer.setObject(this.searchType);
        if (initFromHistory && this.customizer instanceof FullTextCustomizer) {
            ((FullTextCustomizer)this.customizer).initFromHistory();
        }
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle bundle = NbBundle.getBundle(SearchTypePanel.class);
        Mnemonics.setLocalizedText((AbstractButton)this.applyCheckBox, (String)bundle.getString("TEXT_BUTTON_APPLY"));
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)bundle.getString("TEXT_BUTTON_SAVE_AS"));
        this.saveButton.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.restoreButton, (String)bundle.getString("TEXT_BUTTON_RESTORE"));
        this.restoreButton.setEnabled(false);
        this.customizerPanel.add(this.customizerComponent, "Center");
        this.setCustomized(this.searchType.isValid());
        this.setName(this.createName());
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle(SearchTypePanel.class);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DIALOG_DESC"));
        this.restoreButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_RESTORE"));
        this.saveButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_SAVE_AS"));
        this.applyCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_APPLY"));
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.applyCheckBox.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 11, 0, 11);
        this.add((Component)this.applyCheckBox, gridBagConstraints);
        this.saveButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.add((Component)this.saveButton, gridBagConstraints);
        this.restoreButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add((Component)this.restoreButton, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.applyCheckBox) {
            boolean selected = this.applyCheckBox.isSelected();
            this.setCustomized(selected);
            this.searchType.setValid(selected);
        } else if (source == this.saveButton) {
            this.saveCriterion();
        } else if (source == this.restoreButton) {
            this.restoreCriterion();
        } else assert (false);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.searchType && "valid".equals(evt.getPropertyName())) {
            if (evt.getNewValue().equals(Boolean.FALSE)) {
                this.setCustomized(false);
                return;
            }
            this.setCustomized(true);
        }
    }

    public void onOk() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onOk();
        }
    }

    public void onCancel() {
        if (this.customizer instanceof DialogLifetime) {
            ((DialogLifetime)((Object)this.customizer)).onCancel();
        }
    }

    private String createName() {
        String name = this.searchType.getName();
        if (this.customized) {
            return name + MODIFICATOR_SUFFIX;
        }
        return name;
    }

    private static Customizer createCustomizer(SearchType searchType, boolean initFromHistory) {
        Object o;
        Class<?> searchTypeClass = searchType.getClass();
        Class<?> clazz = null;
        if (SearchTypePanel.isDefaultSearchType(searchTypeClass)) {
            String typeClassName = searchType.getClass().getName();
            assert (typeClassName.endsWith("Type"));
            int typeNameLen = typeClassName.length();
            String customizerClassName = new StringBuffer(typeNameLen + 6).append(typeClassName.substring(0, typeNameLen - 4)).append("Customizer").toString();
            try {
                clazz = Class.forName(customizerClassName);
            }
            catch (Exception ex) {
                assert (false);
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
        if (clazz == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Utilities.getBeanInfo(searchTypeClass);
            }
            catch (IntrospectionException ie) {
                ErrorManager.getDefault().notify(1, (Throwable)ie);
                return null;
            }
            clazz = beanInfo.getBeanDescriptor().getCustomizerClass();
        }
        if (clazz == null) {
            return null;
        }
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (!(o instanceof Component) || !(o instanceof Customizer)) {
            return null;
        }
        return (Customizer)o;
    }

    private static boolean isDefaultSearchType(Class searchTypeClass) {
        assert (SearchType.class.isAssignableFrom(searchTypeClass));
        String mandatoryPackage = "org.netbeans.modules.search.types";
        String className = searchTypeClass.getName();
        return className.startsWith(mandatoryPackage) && className.lastIndexOf(46) == mandatoryPackage.length();
    }

    private void setCustomized(boolean cust) {
        this.customized = cust;
        this.saveButton.setEnabled(this.customized);
        this.applyCheckBox.setSelected(this.customized);
        this.setName(this.createName());
        this.firePropertyChange(PROP_CUSTOMIZED, !cust, cust);
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private void saveCriterion() {
        String name;
        block2: {
            block1: {
                JPanel pane = new JPanel();
                pane.setLayout(new BorderLayout(12, 0));
                ResourceBundle bundle = NbBundle.getBundle(SearchTypePanel.class);
                JLabel nameLab = new JLabel();
                Mnemonics.setLocalizedText((JLabel)nameLab, (String)bundle.getString("TEXT_LABEL_NAME"));
                pane.add((Component)nameLab, "West");
                pane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_SaveAsPanel"));
                JTextField textField = this.lastSavedName != null ? new JTextField(this.lastSavedName, 20) : new JTextField(20);
                textField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_LABEL_SELECT"));
                nameLab.setLabelFor(textField);
                pane.add((Component)textField, "Center");
                pane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                DialogDescriptor desc = new DialogDescriptor((Object)pane, bundle.getString("TEXT_LABEL_SAVE_CRITERION"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
                do {
                    dialog.setVisible(true);
                    if (!desc.getValue().equals(DialogDescriptor.OK_OPTION)) break block1;
                } while ((name = textField.getText()).length() <= 0);
                break block2;
            }
            return;
        }
        this.saveCriterion(name);
        this.lastSavedName = name;
    }

    private void saveCriterion(String name) {
        SearchCriterion toSave;
        SearchType copy = (SearchType)this.searchType.clone();
        copy.setName(name);
        try {
            toSave = new SearchCriterion(copy);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return;
        }
        String className = toSave.searchTypeClassName;
        boolean found = false;
        if (this.savedCriteria != null) {
            for (int i = 0; i < this.savedCriteria.length; ++i) {
                if (!this.savedCriteria[i].name.equals(name) || !this.savedCriteria[i].searchTypeClassName.equals(className)) continue;
                found = true;
                SearchProjectSettings.getInstance().replaceSearchCriterion(name, className, toSave);
                this.savedCriteria[i] = toSave;
                break;
            }
        }
        if (!found) {
            SearchProjectSettings.getInstance().addSearchCriterion(toSave);
            this.addSavedCriteria(Collections.singleton(toSave));
        }
    }

    private void restoreCriterion() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        ResourceBundle bundle = NbBundle.getBundle(SearchTypePanel.class);
        pane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_RestorePanel"));
        JLabel resLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)resLabel, (String)bundle.getString("TEXT_LABEL_SELECT"));
        JComboBox<SearchCriterion> combo = new JComboBox<SearchCriterion>(this.savedCriteria);
        combo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SELECT_CRITERION"));
        resLabel.setLabelFor(combo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 12);
        pane.add((Component)resLabel, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        pane.add(combo, gbc);
        pane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        DialogDescriptor desc = new DialogDescriptor((Object)pane, bundle.getString("TEXT_LABEL_RESTORE_CRITERION"));
        DialogDisplayer.getDefault().createDialog(desc).setVisible(true);
        if (desc.getValue().equals(DialogDescriptor.OK_OPTION)) {
            SearchCriterion c = (SearchCriterion)combo.getSelectedItem();
            this.restoreCriterion(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCriterion(SearchCriterion c) {
        SearchType searchType;
        ObjectInputStream ois = null;
        try {
            ois = new SearchTypeInputStream(new ByteArrayInputStream(c.criterionData));
            searchType = (SearchType)ois.readObject();
        }
        catch (Exception ex) {
            String msg = NbBundle.getMessage(SearchTypePanel.class, (String)"TEXT_MSG_Error_while_loading_criterion");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)ex, msg));
            return;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex2) {}
            }
        }
        this.restoreSearchType(searchType);
    }

    private void restoreSearchType(SearchType searchType) {
        this.searchType.removePropertyChangeListener((PropertyChangeListener)this);
        this.searchType = (SearchType)searchType.clone();
        this.initialized = false;
        this.initializeWithObject();
        this.searchType.addPropertyChangeListener((PropertyChangeListener)this);
        this.setCustomized(true);
    }

    final void initializeWithObject() {
        if (!this.initialized) {
            this.customizer.setObject(this.searchType);
            this.initialized = true;
        }
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public boolean equals(Object obj) {
        try {
            return this.searchType.getClass().equals(((SearchTypePanel)obj).getSearchType().getClass());
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public HelpCtx getHelpCtx() {
        return this.searchType.getHelpCtx();
    }

    void addSavedCriteria(Collection criteria) {
        if (criteria.isEmpty()) {
            return;
        }
        SearchCriterion[] newCriteria = new SearchCriterion[criteria.size()];
        criteria.toArray(newCriteria);
        if (this.savedCriteria == null) {
            this.savedCriteria = newCriteria;
            this.restoreButton.setEnabled(true);
        } else {
            SearchCriterion[] oldCriteria = this.savedCriteria;
            this.savedCriteria = new SearchCriterion[oldCriteria.length + newCriteria.length];
            System.arraycopy(oldCriteria, 0, this.savedCriteria, 0, oldCriteria.length);
            System.arraycopy(newCriteria, 0, this.savedCriteria, oldCriteria.length, newCriteria.length);
        }
    }
}

