/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;

public abstract class DataObjectType
extends SearchType {
    private static final long serialVersionUID = 1L;

    protected void prepareSearchObject(Object searchObject) {
    }

    public boolean testObject(Object object) {
        DataObject dataObject = DataObjectType.extractDataObject(object);
        return dataObject != null && this.testDataObject(dataObject);
    }

    private static DataObject extractDataObject(Object object) {
        DataObject dataObject = null;
        if (object instanceof DataObject) {
            dataObject = (DataObject)object;
        } else if (object instanceof FileObject) {
            try {
                dataObject = DataObject.find((FileObject)((FileObject)object));
            }
            catch (DataObjectNotFoundException dnfe) {
                ErrorManager.getDefault().notify(4096, (Throwable)dnfe);
            }
        }
        return dataObject;
    }

    protected Class[] createSearchTypeClasses() {
        return new Class[]{DataObject.class};
    }

    protected abstract boolean testDataObject(DataObject var1);

    public boolean enabled(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Lookup nodeLookup = nodes[i].getLookup();
            if (nodeLookup.lookup(DataObject.Container.class) != null) {
                return true;
            }
            Object searchInfo = nodeLookup.lookup(SearchInfo.class);
            if (searchInfo == null || !((SearchInfo)searchInfo).canSearch()) continue;
            return true;
        }
        return false;
    }
}

