/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.search.types.ModificationDateType;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ModificationDateCustomizer
extends JPanel
implements Customizer,
KeyListener,
ActionListener {
    private ModificationDateType peer;
    private String lastDays = "";
    private String lastBefore = "";
    private String lastAfter = "";
    private final JTextField afterTextField = new JTextField();
    private final JTextField beforeTextField = new JTextField();
    private JLabel beginLabel;
    private final JRadioButton betweenRadioButton = new JRadioButton();
    private JLabel daysLabel;
    private final JRadioButton daysRadioButton = new JRadioButton();
    private final JTextField daysTextField = new JTextField();
    private JLabel egLabel;
    private JPanel jPanel1;

    public ModificationDateCustomizer() {
        this.initComponents();
        this.initAccessibility();
        TitledBorder tb = new TitledBorder(NbBundle.getBundle(ModificationDateCustomizer.class).getString("TEXT_LABEL_MODIFIED"));
        tb.setBorder(new CompoundBorder());
        this.setBorder(tb);
        ButtonGroup group = new ButtonGroup();
        group.add(this.daysRadioButton);
        group.add(this.betweenRadioButton);
        HelpCtx.setHelpIDString((JComponent)this, (String)ModificationDateType.class.toString());
    }

    public void setObject(Object obj) {
        this.peer = (ModificationDateType)((Object)obj);
        this.daysTextField.setForeground(this.getForegroundColor());
        this.afterTextField.setForeground(this.getForegroundColor());
        this.beforeTextField.setForeground(this.getForegroundColor());
        this.daysTextField.setText("");
        this.afterTextField.setText("");
        this.beforeTextField.setText("");
        if (!"".equals(this.peer.getMatchAfter())) {
            this.afterTextField.setText(this.peer.getMatchAfter());
            if (!this.peer.getMatchAfter().equals(null)) {
                this.betweenRadioButton.setSelected(true);
            }
        }
        if (!"".equals(this.peer.getMatchBefore())) {
            this.beforeTextField.setText(this.peer.getMatchBefore());
            if (!this.peer.getMatchAfter().equals(null)) {
                this.betweenRadioButton.setSelected(true);
            }
        }
        if (!"".equals(this.peer.getDays())) {
            this.daysTextField.setText(this.peer.getDays());
            this.daysRadioButton.setSelected(true);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle(ModificationDateCustomizer.class);
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_Dates"));
        this.daysTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_DURING_DAYS"));
        this.daysTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DURING_DAYS"));
        this.daysTextField.setToolTipText(bundle.getString("ACSD_DURING_DAYS"));
        this.afterTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_AFTER"));
        this.afterTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AFTER"));
        this.afterTextField.setToolTipText(bundle.getString("TOOLTIP_AFTER"));
        this.beforeTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_BEFORE"));
        this.beforeTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BEFORE"));
        this.beforeTextField.setToolTipText(bundle.getString("ACSD_BEFORE"));
        this.daysRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TEXT_BUTTON_PRECEDING"));
        this.daysRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TEXT_BUTTON_PRECEDING"));
        this.betweenRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TEXT_BUTTON_RANGE"));
        this.betweenRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TEXT_BUTTON_RANGE"));
    }

    private void initComponents() {
        this.daysLabel = new JLabel();
        this.beginLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.egLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.daysRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.daysRadioButton, (String)NbBundle.getMessage(ModificationDateCustomizer.class, (String)"TEXT_BUTTON_PRECEDING"));
        this.daysRadioButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 4);
        this.add((Component)this.daysRadioButton, gridBagConstraints);
        this.daysLabel.setText(NbBundle.getBundle(ModificationDateCustomizer.class).getString("TEXT_LABEL_DURING_LAST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.daysLabel, gridBagConstraints);
        this.daysTextField.setPreferredSize(new Dimension(50, this.daysTextField.getPreferredSize().height));
        this.daysTextField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.daysTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.betweenRadioButton, (String)NbBundle.getMessage(ModificationDateCustomizer.class, (String)"TEXT_BUTTON_RANGE"));
        this.betweenRadioButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 4);
        this.add((Component)this.betweenRadioButton, gridBagConstraints);
        this.beginLabel.setLabelFor(this.beforeTextField);
        Mnemonics.setLocalizedText((JLabel)this.beginLabel, (String)NbBundle.getMessage(ModificationDateCustomizer.class, (String)"TEXT_LABEL_BEGIN_DATE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.beginLabel, gridBagConstraints);
        this.afterTextField.setPreferredSize(new Dimension(100, this.afterTextField.getPreferredSize().height));
        this.afterTextField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.add((Component)this.afterTextField, gridBagConstraints);
        this.beforeTextField.setPreferredSize(new Dimension(100, this.beforeTextField.getPreferredSize().height));
        this.beforeTextField.addKeyListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 12);
        this.add((Component)this.beforeTextField, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.egLabel.setText(NbBundle.getBundle(ModificationDateCustomizer.class).getString("TEXT_DATE_EXAMPLE") + new ModificationDateType.FormattedDate(new Date()).toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 8, 0, 0);
        this.add((Component)this.egLabel, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.daysRadioButton) {
            this.setDays();
        } else if (source == this.betweenRadioButton) {
            this.setBetween();
        } else assert (false);
    }

    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        if (source == this.daysTextField) {
            this.daysTextFieldKeyReleased();
        } else if (source == this.afterTextField) {
            this.afterTextFieldKeyReleased();
        } else if (source == this.beforeTextField) {
            this.beforeTextFieldKeyReleased();
        } else assert (false);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void daysTextFieldKeyReleased() {
        String text = this.daysTextField.getText();
        if (!text.equals(this.lastDays)) {
            this.setDays();
            this.daysRadioButton.setSelected(true);
            this.lastDays = text;
        }
    }

    private void afterTextFieldKeyReleased() {
        String text = this.afterTextField.getText();
        if (!text.equals(this.lastAfter)) {
            this.setBetween();
            this.betweenRadioButton.setSelected(true);
            this.lastAfter = text;
        }
    }

    private void beforeTextFieldKeyReleased() {
        String text = this.beforeTextField.getText();
        if (!text.equals(this.lastBefore)) {
            this.setBetween();
            this.betweenRadioButton.setSelected(true);
            this.lastBefore = text;
        }
    }

    private void setDays() {
        String text = this.daysTextField.getText();
        try {
            this.peer.setDays(text);
            this.daysTextField.setForeground(this.getForegroundColor());
        }
        catch (IllegalArgumentException ex) {
            this.daysTextField.setForeground(this.getErrorForegroundColor());
        }
    }

    private void setAfter() {
        String after = this.afterTextField.getText();
        try {
            this.peer.setMatchAfter(after);
            this.afterTextField.setForeground(this.getForegroundColor());
        }
        catch (IllegalArgumentException ex) {
            this.afterTextField.setForeground(this.getErrorForegroundColor());
        }
    }

    private void setBefore() {
        String before = this.beforeTextField.getText();
        try {
            this.peer.setMatchBefore(before);
            this.beforeTextField.setForeground(this.getForegroundColor());
        }
        catch (IllegalArgumentException ex) {
            this.beforeTextField.setForeground(this.getErrorForegroundColor());
        }
    }

    private void setBetween() {
        String after = this.afterTextField.getText();
        if (after.length() != 0) {
            this.setAfter();
        }
        this.setBefore();
    }

    public void requestFocus() {
        JTextField tf = this.betweenRadioButton.isSelected() ? this.afterTextField : this.daysTextField;
        int n = tf.getText().length();
        if (n > 0) {
            tf.setCaretPosition(0);
            tf.moveCaretPosition(n);
        }
        tf.requestFocus();
    }

    private Color findColor(String key, Color defCol) {
        Color color = UIManager.getDefaults().getColor(key);
        if (color != null) {
            return color;
        }
        return defCol;
    }

    private Color getForegroundColor() {
        return this.findColor("TextField.foreground", Color.black);
    }

    private Color getErrorForegroundColor() {
        return this.findColor("TextField.errorForeground", Color.red);
    }
}

