/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.openide.util.ChangeSupport;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectedInfo {
    private static final Logger LOG = Logger.getLogger(IntrospectedInfo.class.getName());
    private static IntrospectedInfo defaults = null;
    private static boolean defaultsInited = false;
    private static boolean defaultsEverInited = false;
    private Map<String, IntrospectedClass> clazzes = Collections.synchronizedMap(new TreeMap());
    private Map<String, Map<String, String>> namedefs = new TreeMap<String, Map<String, String>>();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private ChangeListener antBridgeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent ev) {
            IntrospectedInfo.this.clearDefs();
            IntrospectedInfo.this.fireStateChanged();
        }
    };
    private ChangeListener holder;
    private static IntrospectedInfo merged;

    public static synchronized IntrospectedInfo getDefaults() {
        if (defaults == null) {
            defaults = new IntrospectedInfo();
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Class<IntrospectedInfo> clazz = IntrospectedInfo.class;
        synchronized (IntrospectedInfo.class) {
            if (!defaultsInited && this == defaults) {
                AntModule.err.log("IntrospectedInfo.getDefaults: loading...");
                defaultsInited = true;
                this.loadDefaults(!defaultsEverInited);
                defaultsEverInited = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void clearDefs() {
        this.clazzes.clear();
        this.namedefs.clear();
        defaultsInited = false;
    }

    private void loadDefaults(boolean listen) {
        ClassLoader cl = AntBridge.getMainClassLoader();
        InputStream taskDefaults = cl.getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties");
        if (taskDefaults != null) {
            try {
                defaults.load(taskDefaults, "task", cl);
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not load default taskdefs");
                AntModule.err.notify((Throwable)ioe);
            }
        } else {
            AntModule.err.log("Could not open default taskdefs");
        }
        InputStream typeDefaults = cl.getResourceAsStream("org/apache/tools/ant/types/defaults.properties");
        if (typeDefaults != null) {
            try {
                defaults.load(typeDefaults, "type", cl);
            }
            catch (IOException ioe) {
                AntModule.err.log("Could not load default typedefs");
                AntModule.err.notify((Throwable)ioe);
            }
        } else {
            AntModule.err.log("Could not open default typedefs");
        }
        defaults.loadNetBeansSpecificDefinitions();
        if (listen) {
            AntBridge.addChangeListener(WeakListeners.change((ChangeListener)this.antBridgeListener, AntBridge.class));
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.defaults=" + defaults);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private void fireStateChanged() {
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.fireStateChanged");
        }
        RequestProcessor.getDefault().post((Runnable)new ChangeTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefs(String kind) {
        this.init();
        Map<String, Map<String, String>> map = this.namedefs;
        synchronized (map) {
            Map<String, String> m = this.namedefs.get(kind);
            if (m != null) {
                return Collections.unmodifiableMap(m);
            }
            return Collections.emptyMap();
        }
    }

    private IntrospectedClass getData(String clazz) throws IllegalArgumentException {
        IntrospectedClass data = this.clazzes.get(clazz);
        if (data == null) {
            throw new IllegalArgumentException("Unknown class: " + clazz);
        }
        return data;
    }

    public boolean isKnown(String clazz) {
        this.init();
        return this.clazzes.get(clazz) != null;
    }

    public boolean supportsText(String clazz) throws IllegalArgumentException {
        this.init();
        return this.getData((String)clazz).supportsText;
    }

    public Map<String, String> getAttributes(String clazz) throws IllegalArgumentException {
        this.init();
        Map<String, String> map = this.getData((String)clazz).attrs;
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getElements(String clazz) throws IllegalArgumentException {
        this.init();
        Map<String, String> map = this.getData((String)clazz).subs;
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public String[] getTags(String clazz) throws IllegalArgumentException {
        this.init();
        return this.getData((String)clazz).enumTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream is, String kind, ClassLoader cl) throws IOException {
        Properties p = new Properties();
        try {
            p.load(is);
        }
        finally {
            is.close();
        }
        for (Map.Entry entry : NbCollections.checkedMapByFilter((Map)p, String.class, String.class, (boolean)true).entrySet()) {
            String name = (String)entry.getKey();
            if (kind.equals("type") && name.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            String clazzname = (String)entry.getValue();
            try {
                Class<?> clazz = cl.loadClass(clazzname);
                this.register(name, clazz, kind, false);
            }
            catch (ClassNotFoundException cnfe) {
                AntModule.err.log("IntrospectedInfo: skipping " + clazzname + ": " + cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                AntModule.err.log("IntrospectedInfo: skipping " + clazzname + ": " + ncdfe);
            }
            catch (LinkageError e) {
                throw (IOException)new IOException("Could not load class " + clazzname + ": " + e).initCause(e);
            }
            catch (RuntimeException e) {
                throw (IOException)new IOException("Could not load class " + clazzname + ": " + e).initCause(e);
            }
        }
    }

    private void loadNetBeansSpecificDefinitions() {
        this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsNoNamespace());
        if (AntBridge.getInterface().isAnt16()) {
            this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsWithNamespace());
        }
    }

    private void loadNetBeansSpecificDefinitions0(Map<String, Map<String, Class>> defsByKind) {
        for (Map.Entry<String, Map<String, Class>> kindE : defsByKind.entrySet()) {
            for (Map.Entry<String, Class> defsE : kindE.getValue().entrySet()) {
                this.register(defsE.getKey(), defsE.getValue(), kindE.getKey());
            }
        }
    }

    public synchronized void register(String name, Class clazz, String kind) {
        this.register(name, clazz, kind, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String name, Class clazz, String kind, boolean fire) {
        this.init();
        Map<String, Map<String, String>> map = this.namedefs;
        synchronized (map) {
            Map<String, String> m = this.namedefs.get(kind);
            if (m == null) {
                m = new TreeMap<String, String>();
                this.namedefs.put(kind, m);
            }
            m.put(name, clazz.getName());
        }
        boolean changed = this.analyze(clazz, null, false);
        if (changed && fire) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String name, String kind) {
        this.init();
        Map<String, Map<String, String>> map = this.namedefs;
        synchronized (map) {
            Map<String, String> m = this.namedefs.get(kind);
            if (m != null) {
                m.remove(name);
            }
        }
        this.fireStateChanged();
    }

    private boolean analyze(Class clazz, Set<Class> skipReanalysis, boolean isAttrType) {
        String n = clazz.getName();
        if (IntrospectedInfo.getDefaults().isKnown(n)) {
            return false;
        }
        if ((skipReanalysis == null || !skipReanalysis.add(clazz)) && this.isKnown(n)) {
            return false;
        }
        IntrospectedClass info = new IntrospectedClass();
        if (isAttrType) {
            String[] enumTags = AntBridge.getInterface().getEnumeratedValues(clazz);
            if (enumTags != null) {
                info.enumTags = enumTags;
                return !info.equals(this.clazzes.put(clazz.getName(), info));
            }
            return this.clazzes.remove(clazz.getName()) != null;
        }
        IntrospectionHelperProxy helper = AntBridge.getInterface().getIntrospectionHelper(clazz);
        info.supportsText = helper.supportsCharacters();
        Enumeration<String> e = helper.getAttributes();
        HashSet<Class> nueAttrTypeClazzes = new HashSet<Class>();
        if (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                try {
                    Class attrType = helper.getAttributeType(name);
                    String type = attrType.getName();
                    if (IntrospectedInfo.hasSuperclass(clazz, "org.apache.tools.ant.Task") && (name.equals("location") && type.equals("org.apache.tools.ant.Location") || name.equals("taskname") && type.equals("java.lang.String") || name.equals("description") && type.equals("java.lang.String"))) continue;
                    if (info.attrs == null) {
                        info.attrs = new TreeMap<String, String>();
                    }
                    info.attrs.put(name, type);
                    nueAttrTypeClazzes.add(attrType);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify(1, (Throwable)re);
                }
            }
        } else {
            info.attrs = null;
        }
        HashSet<Class> nueClazzes = new HashSet<Class>();
        e = helper.getNestedElements();
        if (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                try {
                    Class subclazz = helper.getElementType(name);
                    if (info.subs == null) {
                        info.subs = new TreeMap<String, String>();
                    }
                    info.subs.put(name, subclazz.getName());
                    nueClazzes.add(subclazz);
                }
                catch (RuntimeException re) {
                    AntModule.err.notify(1, (Throwable)re);
                }
            }
        } else {
            info.subs = null;
        }
        boolean changed = !info.equals(this.clazzes.put(clazz.getName(), info));
        for (Class nueClazz : nueClazzes) {
            changed |= this.analyze(nueClazz, skipReanalysis, false);
        }
        for (Class nueClazz : nueAttrTypeClazzes) {
            changed |= this.analyze(nueClazz, skipReanalysis, true);
        }
        return changed;
    }

    private static boolean hasSuperclass(Class subclass, String superclass) {
        for (Class c = subclass; c != null; c = c.getSuperclass()) {
            if (!c.getName().equals(superclass)) continue;
            return true;
        }
        return false;
    }

    public void scanProject(Map<String, Map<String, Class>> defs) {
        this.init();
        HashSet<Class> skipReanalysis = new HashSet<Class>();
        boolean changed = false;
        for (Map.Entry<String, Map<String, Class>> e : defs.entrySet()) {
            changed |= this.scanMap(e.getValue(), e.getKey(), skipReanalysis);
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.scanProject: " + this);
        }
        if (changed) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanMap(Map<String, Class> m, String kind, Set<Class> skipReanalysis) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        for (Map.Entry<String, Class> entry : m.entrySet()) {
            String name = entry.getKey();
            if (kind.equals("type") && name.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            Class clazz = entry.getValue();
            if (clazz.getName().equals("org.apache.tools.ant.taskdefs.MacroInstance")) continue;
            Map<String, String> registry = this.namedefs.get(kind);
            if (registry == null) {
                registry = new TreeMap<String, String>();
                this.namedefs.put(kind, registry);
            }
            IntrospectedInfo introspectedInfo = this;
            synchronized (introspectedInfo) {
                Map<String, String> defaults = IntrospectedInfo.getDefaults().getDefs(kind);
                if (defaults.get(name) == null) {
                    changed |= !clazz.getName().equals(registry.put(name, clazz.getName()));
                }
                if (!IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
                    try {
                        changed |= this.analyze(clazz, skipReanalysis, false);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        AntModule.err.log("Skipping " + clazz.getName() + ": " + ncdfe);
                    }
                    catch (LinkageError e) {
                        AntModule.err.annotate((Throwable)e, 1, "Cannot scan class " + clazz.getName(), null, null, null);
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
            }
        }
        return changed;
    }

    public String toString() {
        return "IntrospectedInfo[namedefs=" + this.namedefs + ",clazzes=" + this.clazzes + "]";
    }

    private static IntrospectedInfo merge(IntrospectedInfo[] proxied) {
        ChangeListener l;
        final IntrospectedInfo ii = new IntrospectedInfo();
        ii.holder = l = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                IntrospectedInfo ii2 = (IntrospectedInfo)ev.getSource();
                ii2.init();
                ii.clazzes.putAll(ii2.clazzes);
                for (Map.Entry e : ii2.namedefs.entrySet()) {
                    String kind = (String)e.getKey();
                    Map entries = (Map)e.getValue();
                    if (ii.namedefs.containsKey(kind)) {
                        ((Map)ii.namedefs.get(kind)).putAll(entries);
                        continue;
                    }
                    ii.namedefs.put(kind, new TreeMap(entries));
                }
                ii.fireStateChanged();
            }
        };
        for (IntrospectedInfo info : proxied) {
            info.addChangeListener(WeakListeners.change((ChangeListener)l, (Object)info));
            l.stateChanged(new ChangeEvent(info));
        }
        return ii;
    }

    public static synchronized IntrospectedInfo getKnownInfo() {
        if (merged == null) {
            merged = IntrospectedInfo.merge(new IntrospectedInfo[]{IntrospectedInfo.getDefaults(), AntSettings.getCustomDefs()});
        }
        return merged;
    }

    static {
        AntSettings.IntrospectedInfoSerializer.instance = new AntSettings.IntrospectedInfoSerializer(){
            Pattern p = Pattern.compile("(.+)\\.(supportsText|attrs\\.(.+)|subs\\.(.+)|enumTags)");

            public IntrospectedInfo load(Preferences node) {
                IntrospectedInfo ii = new IntrospectedInfo();
                try {
                    for (String k : node.keys()) {
                        Object m;
                        String v = node.get(k, null);
                        assert (v != null) : k;
                        String[] ss = k.split("\\.", 2);
                        if (ss[0].equals("class")) {
                            m = this.p.matcher(ss[1]);
                            boolean match = ((Matcher)m).matches();
                            if (!match) {
                                LOG.log(Level.WARNING, "malformed key: {0}", k);
                                continue;
                            }
                            String c = ((Matcher)m).group(1);
                            IntrospectedClass ic = this.assureDefined(ii, c);
                            String tail = ((Matcher)m).group(2);
                            if (tail.equals("supportsText")) {
                                assert (v.equals("true")) : k;
                                ic.supportsText = true;
                                continue;
                            }
                            if (tail.equals("enumTags")) {
                                ic.enumTags = v.split(",");
                                continue;
                            }
                            if (((Matcher)m).group(3) != null) {
                                if (ic.attrs == null) {
                                    ic.attrs = new TreeMap<String, String>();
                                }
                                ic.attrs.put(((Matcher)m).group(3), v);
                                continue;
                            }
                            assert (((Matcher)m).group(4) != null) : k;
                            if (ic.subs == null) {
                                ic.subs = new TreeMap<String, String>();
                            }
                            ic.subs.put(((Matcher)m).group(4), v);
                            continue;
                        }
                        m = (Map)ii.namedefs.get(ss[0]);
                        if (m == null) {
                            m = new TreeMap<String, String>();
                            ii.namedefs.put(ss[0], m);
                        }
                        m.put(ss[1], v);
                    }
                }
                catch (BackingStoreException x) {
                    LOG.log(Level.WARNING, null, x);
                }
                for (String kind : new String[]{"task", "type"}) {
                    if (ii.namedefs.containsKey(kind)) continue;
                    ii.namedefs.put(kind, new TreeMap());
                }
                return ii;
            }

            private IntrospectedClass assureDefined(IntrospectedInfo ii, String clazz) {
                IntrospectedClass ic = (IntrospectedClass)ii.clazzes.get(clazz);
                if (ic == null) {
                    ic = new IntrospectedClass();
                    ii.clazzes.put(clazz, ic);
                }
                return ic;
            }

            public void store(Preferences node, IntrospectedInfo info) {
                try {
                    node.clear();
                }
                catch (BackingStoreException x) {
                    LOG.log(Level.WARNING, null, x);
                    return;
                }
                for (Map.Entry kindEntries : info.namedefs.entrySet()) {
                    for (Map.Entry namedef : ((Map)kindEntries.getValue()).entrySet()) {
                        node.put((String)kindEntries.getKey() + "." + (String)namedef.getKey(), (String)namedef.getValue());
                    }
                }
                for (Map.Entry clazzPair : info.clazzes.entrySet()) {
                    String c = "class." + (String)clazzPair.getKey();
                    IntrospectedClass ic = (IntrospectedClass)clazzPair.getValue();
                    if (ic.supportsText) {
                        node.putBoolean(c + ".supportsText", true);
                    }
                    if (ic.attrs != null) {
                        for (Map.Entry<String, String> attr : ic.attrs.entrySet()) {
                            node.put(c + ".attrs." + attr.getKey(), attr.getValue());
                        }
                    }
                    if (ic.subs != null) {
                        for (Map.Entry<String, String> sub : ic.subs.entrySet()) {
                            node.put(c + ".subs." + sub.getKey(), sub.getValue());
                        }
                    }
                    if (ic.enumTags == null) continue;
                    StringBuilder b = new StringBuilder();
                    for (String s : ic.enumTags) {
                        if (b.length() > 0) {
                            b.append(',');
                        }
                        b.append(s);
                    }
                    node.put(c + ".enumTags", b.toString());
                }
            }

            private boolean equiv(IntrospectedInfo ii1, IntrospectedInfo ii2) {
                return ((Object)ii1.clazzes).equals(ii2.clazzes) && ((Object)ii1.namedefs).equals(ii2.namedefs);
            }
        };
    }

    private class ChangeTask
    implements Runnable {
        private ChangeTask() {
        }

        public void run() {
            IntrospectedInfo.this.cs.fireChange();
        }
    }

    private static final class IntrospectedClass {
        public boolean supportsText;
        public Map<String, String> attrs;
        public Map<String, String> subs;
        public String[] enumTags;

        private IntrospectedClass() {
        }

        public String toString() {
            return "IntrospectedClass[text=" + this.supportsText + ",attrs=" + this.attrs + ",subs=" + this.subs + ",enumTags=" + Arrays.toString(this.enumTags) + "]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntrospectedClass)) {
                return false;
            }
            IntrospectedClass other = (IntrospectedClass)o;
            return this.supportsText == other.supportsText && Utilities.compareObjects(this.attrs, other.attrs) && Utilities.compareObjects(this.subs, other.subs) && Utilities.compareObjects((Object)this.enumTags, (Object)other.enumTags);
        }
    }
}

