/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static ExecutorTask runTarget(FileObject buildXml, String[] targetNames, Properties properties) throws IOException, IllegalArgumentException {
        if (buildXml == null) {
            throw new NullPointerException("Must pass non-null build script");
        }
        if (targetNames != null && targetNames.length == 0) {
            throw new IllegalArgumentException("No targets supplied");
        }
        AntProjectCookie apc = TargetLister.getAntProjectCookie(buildXml);
        AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
        if (properties != null) {
            Properties p = execenv.getProperties();
            p.putAll((Map<?, ?>)properties);
            execenv.setProperties(p);
        }
        return AntTargetExecutor.createTargetExecutor(execenv).execute(apc, targetNames);
    }

    public static FileObject[] findSelectedFiles(Lookup context, FileObject dir, String suffix, boolean strict) {
        if (dir != null && !dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        if (suffix != null && suffix.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cannot includes slashes in suffix: " + suffix);
        }
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        for (DataObject d : context.lookupAll(DataObject.class)) {
            boolean matches;
            FileObject f = d.getPrimaryFile();
            boolean bl = matches = FileUtil.toFile((FileObject)f) != null;
            if (dir != null) {
                matches &= FileUtil.isParentOf((FileObject)dir, (FileObject)f) || dir == f;
            }
            if (suffix != null) {
                matches &= f.getNameExt().endsWith(suffix);
            }
            if (matches) {
                files.add(f);
                continue;
            }
            if (!strict) continue;
            return null;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static FileObject[] regexpMapFiles(FileObject[] fromFiles, FileObject fromDir, Pattern fromRx, FileObject toDir, String toSubst, boolean strict) throws IllegalArgumentException {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (FileObject fromFile : fromFiles) {
            FileObject target;
            String toPath;
            String path = FileUtil.getRelativePath((FileObject)fromDir, (FileObject)fromFile);
            if (path == null) {
                throw new IllegalArgumentException("The file " + fromFile + " is not in " + fromDir);
            }
            if (fromRx != null) {
                Matcher m = fromRx.matcher(path);
                toPath = m.replaceFirst(toSubst);
                if (toPath.equals(path) && !m.find(0)) {
                    if (!strict) continue;
                    return null;
                }
            } else {
                toPath = path;
            }
            if ((target = toDir.getFileObject(toPath)) == null) {
                if (!strict) continue;
                return null;
            }
            files.add(target);
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static String antIncludesList(FileObject[] files, FileObject dir) throws IllegalArgumentException {
        return ActionUtils.antIncludesList(files, dir, true);
    }

    public static String antIncludesList(FileObject[] files, FileObject dir, boolean recursive) throws IllegalArgumentException {
        if (!dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            String path = FileUtil.getRelativePath((FileObject)dir, (FileObject)files[i]);
            if (path == null) {
                throw new IllegalArgumentException("The file " + files[i] + " is not in " + dir);
            }
            if (i > 0) {
                b.append(',');
            }
            b.append(path);
            if (!files[i].isFolder()) continue;
            if (path.length() > 0) {
                b.append('/');
            }
            b.append('*');
            if (!recursive) continue;
            b.append('*');
        }
        return b.toString();
    }
}

