/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AuxClassLoader;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.DummyBridgeImpl;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.io.NullOutputStream;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBridge {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance(AntBridge.class.getName());
    private static Reference<AntInstance> antInstance = null;
    private static final ChangeSupport cs = new ChangeSupport(AntBridge.class);
    private static MiscListener miscListener = new MiscListener();
    private static Lookup.Result<ModuleInfo> modulesResult = Lookup.getDefault().lookupResult(ModuleInfo.class);
    private static String originalJavaClassPath;
    private static int delegating;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map<ThreadGroup, InputStream> delegateIns;
    private static Map<ThreadGroup, PrintStream> delegateOuts;
    private static Map<ThreadGroup, PrintStream> delegateErrs;
    private static List<Thread> suspendedDelegationTasks;
    private static int fakingJavaClassPath;

    private AntBridge() {
    }

    public static synchronized void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public static synchronized void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    private static void fireChange() {
        antInstance = null;
        cs.fireChange();
    }

    public static ClassLoader getMainClassLoader() {
        return AntBridge.getAntInstance().mainClassLoader;
    }

    public static Map<String, Map<String, Class>> getCustomDefsWithNamespace() {
        return AntBridge.getAntInstance().customDefs;
    }

    public static Map<String, Map<String, Class>> getCustomDefsNoNamespace() {
        HashMap<String, Map<String, Class>> m = new HashMap<String, Map<String, Class>>();
        for (Map.Entry<String, Map<String, Class>> entry : AntBridge.getCustomDefsWithNamespace().entrySet()) {
            String type = entry.getKey();
            Map<String, Class> defs = entry.getValue();
            HashMap<String, Class> m2 = new HashMap<String, Class>();
            for (Map.Entry<String, Class> entry2 : defs.entrySet()) {
                String fqn = entry2.getKey();
                Class clazz = entry2.getValue();
                int idx = fqn.lastIndexOf(58);
                String name = idx != -1 ? fqn.substring(idx + 1) : fqn;
                m2.put(name, clazz);
            }
            m.put(type, m2);
        }
        return m;
    }

    public static Map<String, ClassLoader> getCustomDefClassLoaders() throws IOException {
        return AntBridge.getAntInstance().customDefClassLoaders;
    }

    public static BridgeInterface getInterface() {
        return AntBridge.getAntInstance().bridge;
    }

    private static synchronized AntInstance getAntInstance() {
        AntInstance ai = antInstance != null ? antInstance.get() : null;
        if (ai == null) {
            ai = AntBridge.createAntInstance();
            antInstance = new SoftReference<AntInstance>(ai);
        }
        return ai;
    }

    private static AntInstance createAntInstance() {
        err.log("AntBridge.createAntInstance - loading Ant installation...");
        try {
            List<File> mainClassPath = AntBridge.createMainClassPath();
            err.log("mainClassPath=" + mainClassPath);
            ClassLoader main = AntBridge.createMainClassLoader(mainClassPath);
            ClassLoader bridgeLoader = AntBridge.createBridgeClassLoader(main);
            Class<?> ihClazz = Class.forName("org.apache.tools.ant.input.InputHandler", false, bridgeLoader);
            Class<BridgeInterface> impl = bridgeLoader.loadClass("org.apache.tools.ant.module.bridge.impl.BridgeImpl").asSubclass(BridgeInterface.class);
            if (AntSettings.getAntHome() != null) {
                ClassLoader loaderUsedForAnt = ihClazz.getClassLoader();
                if (loaderUsedForAnt != main) {
                    throw new IllegalStateException("Wrong class loader is finding Ant: " + loaderUsedForAnt);
                }
                Class<?> ihClazz2 = Class.forName("org.apache.tools.ant.input.InputHandler", false, main);
                if (ihClazz2 != ihClazz) {
                    throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + ihClazz2.getClassLoader());
                }
                try {
                    Class<?> alClazz = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, bridgeLoader);
                    if (alClazz.getClassLoader() != main) {
                        throw new IllegalStateException("Bridge loader is loading stuff from elsewhere: " + alClazz.getClassLoader());
                    }
                    Class<?> alClazz2 = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, main);
                    if (alClazz2 != alClazz) {
                        throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + alClazz2.getClassLoader());
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (impl.getClassLoader() != bridgeLoader) {
                    throw new IllegalStateException("Wrong class loader is finding bridge impl: " + impl.getClassLoader());
                }
            }
            Map<String, ClassLoader> cDCLs = AntBridge.createCustomDefClassLoaders(main);
            return new AntInstance(AntBridge.classPathToString(mainClassPath), main, bridgeLoader, impl.newInstance(), AntBridge.createCustomDefs(cDCLs), cDCLs);
        }
        catch (Exception e) {
            return AntBridge.fallback(e);
        }
        catch (LinkageError e) {
            return AntBridge.fallback(e);
        }
    }

    private static AntInstance fallback(Throwable e) {
        ClassLoader dummy = ClassLoader.getSystemClassLoader();
        HashMap<String, Map<String, Class>> defs = new HashMap<String, Map<String, Class>>();
        defs.put("task", new HashMap());
        defs.put("type", new HashMap());
        return new AntInstance("", dummy, dummy, new DummyBridgeImpl(e), defs, Collections.<String, ClassLoader>emptyMap());
    }

    private static String classPathToString(List<File> cp) {
        StringBuffer b = new StringBuffer();
        Iterator<File> it = cp.iterator();
        while (it.hasNext()) {
            b.append(it.next().getAbsolutePath());
            if (!it.hasNext()) continue;
            b.append(File.pathSeparator);
        }
        return b.toString();
    }

    public static String getMainClassPath() {
        return AntBridge.getAntInstance().mainClassPath + File.pathSeparatorChar + originalJavaClassPath;
    }

    private static List<File> createMainClassPath() throws Exception {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        File antHome = AntSettings.getAntHome();
        if (antHome != null) {
            File[] libs;
            File libdir = new File(antHome, "lib");
            if (!libdir.isDirectory()) {
                throw new IOException("No such Ant library dir: " + libdir);
            }
            err.log("Creating main class loader from " + libdir);
            File[] patches = new File(libdir.getParentFile(), "patches").listFiles(new JarFilter());
            if (patches != null) {
                cp.addAll(Arrays.asList(patches));
            }
            if ((libs = libdir.listFiles(new JarFilter())) == null) {
                throw new IOException("Listing: " + libdir);
            }
            cp.addAll(Arrays.asList(libs));
        } else {
            File toolsJar = new File(new File(new File(System.getProperty("java.home")).getParentFile(), "lib"), "tools.jar");
            if (toolsJar.isFile()) {
                cp.add(toolsJar);
            }
        }
        cp.addAll(AntSettings.getExtraClasspath());
        cp.addAll(AntSettings.getAutomaticExtraClasspath());
        return new ArrayList<File>(cp);
    }

    private static ClassLoader createMainClassLoader(List<File> mainClassPath) throws Exception {
        URL[] cp = new URL[mainClassPath.size()];
        Iterator<File> it = mainClassPath.iterator();
        int i = 0;
        while (it.hasNext()) {
            cp[i++] = it.next().toURI().toURL();
        }
        if (AntSettings.getAntHome() != null) {
            ClassLoader parent = ClassLoader.getSystemClassLoader();
            if (err.isLoggable(1)) {
                List<URL> parentURLs = parent instanceof URLClassLoader ? Arrays.asList(((URLClassLoader)parent).getURLs()) : null;
                err.log("AntBridge.createMainClassLoader: cp=" + Arrays.asList(cp) + " parent.urls=" + parentURLs);
            }
            return new MaskedClassLoader(cp, parent);
        }
        ClassLoader existing = AntBridge.class.getClassLoader();
        if (existing instanceof URLClassLoader) {
            try {
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                for (URL u : cp) {
                    addURL.invoke((Object)existing, u);
                }
                return existing;
            }
            catch (Exception e) {
                err.notify(16, (Throwable)e);
            }
        }
        return new AllPermissionURLClassLoader(cp, existing);
    }

    private static ClassLoader createBridgeClassLoader(ClassLoader main) throws Exception {
        File bridgeJar = InstalledFileLocator.getDefault().locate("ant/nblib/bridge.jar", "org.apache.tools.ant.module", false);
        if (bridgeJar == null) {
            return main;
        }
        return AntBridge.createAuxClassLoader(bridgeJar, main, AntBridge.class.getClassLoader());
    }

    private static ClassLoader createAuxClassLoader(File lib, ClassLoader main, ClassLoader moduleLoader) throws IOException {
        return new AuxClassLoader(moduleLoader, main, lib.toURI().toURL());
    }

    private static Map<String, ClassLoader> createCustomDefClassLoaders(ClassLoader main) throws IOException {
        HashMap<String, ClassLoader> m = new HashMap<String, ClassLoader>();
        ModuleInfo[] modules = miscListener.getEnabledModules();
        InstalledFileLocator ifl = InstalledFileLocator.getDefault();
        for (ModuleInfo module : modules) {
            String cnb = module.getCodeNameBase();
            String cnbDashes = cnb.replace('.', '-');
            File lib = ifl.locate("ant/nblib/" + cnbDashes + ".jar", cnb, false);
            if (lib == null) {
                if (main.getResource(cnb.replace('.', '/') + "/antlib.xml") == null) continue;
                m.put(cnb, main);
                continue;
            }
            ClassLoader l = AntBridge.createAuxClassLoader(lib, main, module.getClassLoader());
            m.put(cnb, l);
        }
        return m;
    }

    private static Map<String, Map<String, Class>> createCustomDefs(Map<String, ClassLoader> cDCLs) throws IOException {
        HashMap<String, Map<String, Class>> m = new HashMap<String, Map<String, Class>>();
        HashMap<String, Class> tasks = new HashMap<String, Class>();
        HashMap<String, Class> types = new HashMap<String, Class>();
        m.put("task", tasks);
        m.put("type", types);
        for (Map.Entry<String, ClassLoader> entry : cDCLs.entrySet()) {
            Document doc;
            String resource;
            String cnb = entry.getKey();
            ClassLoader l = entry.getValue();
            URL antlib = l.getResource(resource = cnb.replace('.', '/') + "/antlib.xml");
            if (antlib == null) {
                throw new IOException("Could not find " + resource + " in ant/nblib/" + cnb.replace('.', '-') + ".jar");
            }
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(antlib.toExternalForm()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals("antlib")) {
                throw new IOException("Bad root element for " + antlib + ": " + docEl);
            }
            NodeList nl = docEl.getChildNodes();
            HashMap<String, String> newTaskDefs = new HashMap<String, String>();
            HashMap<String, String> newTypeDefs = new HashMap<String, String>();
            for (int i = 0; i < nl.getLength(); ++i) {
                boolean type;
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Element def = (Element)n;
                if (def.getNodeName().equals("taskdef")) {
                    type = false;
                } else if (def.getNodeName().equals("typedef")) {
                    type = true;
                } else {
                    err.log(16, "Warning: unrecognized definition " + def + " in " + antlib);
                    continue;
                }
                String name = def.getAttribute("name");
                if (name == null) {
                    err.log(16, "Warning: skipping definition " + def + " with no 'name' in " + antlib);
                    continue;
                }
                String classname = def.getAttribute("classname");
                if (classname == null) {
                    throw new IOException("No 'classname' attr on def of " + name + " in " + antlib);
                }
                String nsname = "antlib:" + cnb + ":" + name;
                (type ? newTypeDefs : newTaskDefs).put(nsname, classname);
            }
            AntBridge.loadDefs(newTaskDefs, tasks, l);
            AntBridge.loadDefs(newTypeDefs, types, l);
        }
        return m;
    }

    private static void loadDefs(Map<String, String> p, Map<String, Class> defs, ClassLoader l) throws IOException {
        for (Map.Entry<String, String> entry : p.entrySet()) {
            String name = entry.getKey();
            String clazzname = entry.getValue();
            try {
                Class<?> clazz = l.loadClass(clazzname);
                defs.put(name, clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw (IOException)new IOException("Could not load class " + clazzname + ": " + cnfe).initCause(cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                err.log("AntBridge.loadDefs: skipping " + clazzname + ": " + ncdfe);
            }
            catch (LinkageError e) {
                throw (IOException)new IOException("Could not load class " + clazzname + ": " + e).initCause(e);
            }
        }
    }

    private static boolean masked(String clazz) {
        return clazz.startsWith("org.apache.tools.") || clazz.startsWith("org.netbeans.") || clazz.startsWith("org.openide.") || clazz.startsWith("org.openidex.");
    }

    public static synchronized void pushSystemInOutErr(InputStream in, PrintStream out, PrintStream err) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.put(tg, in);
        delegateOuts.put(tg, out);
        delegateErrs.put(tg, err);
    }

    public static synchronized void restoreSystemInOutErr() {
        assert (delegating > 0);
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.remove(tg);
        delegateOuts.remove(tg);
        delegateErrs.remove(tg);
    }

    public static synchronized void suspendDelegation() {
        Thread t = Thread.currentThread();
        suspendedDelegationTasks.add(t);
    }

    public static synchronized void resumeDelegation() {
        Thread t = Thread.currentThread();
        assert (suspendedDelegationTasks.contains(t)) : "Have not suspended delegation in " + t;
        suspendedDelegationTasks.remove(t);
    }

    public static synchronized void fakeJavaClassPath() {
        if (fakingJavaClassPath++ == 0) {
            String cp = AntBridge.getMainClassPath();
            err.log("Faking java.class.path=" + cp);
            System.setProperty("java.class.path", cp);
        }
    }

    public static synchronized void unfakeJavaClassPath() {
        if (--fakingJavaClassPath == 0) {
            err.log("Restoring java.class.path=" + originalJavaClassPath);
            System.setProperty("java.class.path", originalJavaClassPath);
        }
    }

    static {
        AntSettings.addPropertyChangeListener(miscListener);
        modulesResult.addLookupListener((LookupListener)miscListener);
        originalJavaClassPath = System.getProperty("java.class.path");
        delegating = 0;
        delegateIns = new HashMap<ThreadGroup, InputStream>();
        delegateOuts = new HashMap<ThreadGroup, PrintStream>();
        delegateErrs = new HashMap<ThreadGroup, PrintStream>();
        suspendedDelegationTasks = new ArrayList<Thread>();
        fakingJavaClassPath = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AllPermissionURLClassLoader
    extends URLClassLoader {
        private static PermissionCollection allPermission;

        private static synchronized PermissionCollection getAllPermissions() {
            if (allPermission == null) {
                allPermission = new Permissions();
                allPermission.add(new AllPermission());
            }
            return allPermission;
        }

        public AllPermissionURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected final PermissionCollection getPermissions(CodeSource cs) {
            return AllPermissionURLClassLoader.getAllPermissions();
        }

        public String toString() {
            return super.toString() + "[parent=" + this.getParent() + ",urls=" + Arrays.asList(this.getURLs()) + "]";
        }

        @Override
        public URL getResource(String name) {
            URL u = super.getResource(name);
            if (err.isLoggable(1)) {
                err.log("APURLCL.gR: " + name + " -> " + u + " [" + this + "]");
            }
            return u;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            try {
                Enumeration<URL> us = super.findResources(name);
                if (err.isLoggable(1)) {
                    ArrayList<URL> resources = Collections.list(us);
                    us = Collections.enumeration(resources);
                    err.log("APURLCL.fRs: " + name + " -> " + resources + " [" + this + "]");
                }
                return us;
            }
            catch (IOException e) {
                if (err.isLoggable(1)) {
                    err.notify(1, (Throwable)e);
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AntInstance {
        public final String mainClassPath;
        public final ClassLoader mainClassLoader;
        public final ClassLoader bridgeClassLoader;
        public final BridgeInterface bridge;
        public final Map<String, Map<String, Class>> customDefs;
        public final Map<String, ClassLoader> customDefClassLoaders;

        public AntInstance(String mainClassPath, ClassLoader mainClassLoader, ClassLoader bridgeClassLoader, BridgeInterface bridge, Map<String, Map<String, Class>> customDefs, Map<String, ClassLoader> customDefClassLoaders) {
            this.mainClassPath = mainClassPath;
            this.mainClassLoader = mainClassLoader;
            this.bridgeClassLoader = bridgeClassLoader;
            this.bridge = bridge;
            this.customDefs = customDefs;
            this.customDefClassLoaders = customDefClassLoaders;
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.US).endsWith(".jar");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaskedClassLoader
    extends AllPermissionURLClassLoader {
        public MaskedClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (AntBridge.masked(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }

    private static final class MiscListener
    implements PropertyChangeListener,
    LookupListener {
        private ModuleInfo[] modules = null;

        MiscListener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if ("antHome".equals(prop) || "extraClasspath".equals(prop) || "automaticExtraClasspath".equals(prop)) {
                err.log("AntBridge got settings change in " + prop);
                AntBridge.fireChange();
            } else if ("enabled".equals(prop)) {
                err.log("AntBridge got module enablement change on " + ev.getSource());
                AntBridge.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            err.log("AntModule got ModuleInfo change");
            MiscListener miscListener = this;
            synchronized (miscListener) {
                if (this.modules != null) {
                    for (ModuleInfo module : this.modules) {
                        module.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.modules = null;
                }
            }
            AntBridge.fireChange();
        }

        public synchronized ModuleInfo[] getEnabledModules() {
            if (this.modules == null) {
                Collection c = modulesResult.allInstances();
                for (ModuleInfo module : this.modules = c.toArray(new ModuleInfo[c.size()])) {
                    module.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            ArrayList<ModuleInfo> enabledModules = new ArrayList<ModuleInfo>(this.modules.length);
            for (ModuleInfo module : this.modules) {
                if (!module.isEnabled()) continue;
                enabledModules.add(module);
            }
            return enabledModules.toArray(new ModuleInfo[enabledModules.size()]);
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        private InputStream delegate() {
            ThreadGroup tg;
            Thread t = Thread.currentThread();
            for (tg = t.getThreadGroup(); tg != null && !delegateIns.containsKey(tg); tg = tg.getParent()) {
            }
            InputStream is = (InputStream)delegateIns.get(tg);
            if (is != null && !suspendedDelegationTasks.contains(t)) {
                return is;
            }
            if (delegating > 0) {
                assert (origIn != null);
                return origIn;
            }
            return System.in;
        }

        public int read() throws IOException {
            return this.delegate().read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate().read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate().read(b, off, len);
        }

        public int available() throws IOException {
            return this.delegate().available();
        }

        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        public void mark(int readlimit) {
            this.delegate().mark(readlimit);
        }

        public void close() throws IOException {
            this.delegate().close();
        }

        public long skip(long n) throws IOException {
            return this.delegate().skip(n);
        }

        public void reset() throws IOException {
            this.delegate().reset();
        }
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;

        public MultiplexPrintStream(boolean err) {
            this(new NullOutputStream(), err);
        }

        private MultiplexPrintStream(NullOutputStream nos, boolean err) {
            super((OutputStream)nos);
            nos.throwException = true;
            this.err = err;
        }

        private PrintStream delegate() {
            PrintStream stream;
            ThreadGroup tg;
            Map delegates;
            Thread t = Thread.currentThread();
            Map map = delegates = this.err ? delegateErrs : delegateOuts;
            for (tg = t.getThreadGroup(); tg != null && !delegates.containsKey(tg); tg = tg.getParent()) {
            }
            PrintStream ps = (PrintStream)delegates.get(tg);
            if (ps != null && !suspendedDelegationTasks.contains(t)) {
                assert (!(ps instanceof MultiplexPrintStream));
                return ps;
            }
            if (delegating > 0) {
                PrintStream orig;
                PrintStream printStream = orig = this.err ? origErr : origOut;
                assert (orig != null);
                assert (!(orig instanceof MultiplexPrintStream));
                return orig;
            }
            PrintStream printStream = stream = this.err ? System.err : System.out;
            assert (!(stream instanceof MultiplexPrintStream));
            return stream;
        }

        public boolean checkError() {
            return this.delegate().checkError();
        }

        public void close() {
            this.delegate().close();
        }

        public void flush() {
            this.delegate().flush();
        }

        public void print(long l) {
            this.delegate().print(l);
        }

        public void print(char[] s) {
            this.delegate().print(s);
        }

        public void print(int i) {
            this.delegate().print(i);
        }

        public void print(boolean b) {
            this.delegate().print(b);
        }

        public void print(char c) {
            this.delegate().print(c);
        }

        public void print(float f) {
            this.delegate().print(f);
        }

        public void print(double d) {
            this.delegate().print(d);
        }

        public void print(Object obj) {
            this.delegate().print(obj);
        }

        public void print(String s) {
            this.delegate().print(s);
        }

        public void println(double x) {
            this.delegate().println(x);
        }

        public void println(Object x) {
            this.delegate().println(x);
        }

        public void println(float x) {
            this.delegate().println(x);
        }

        public void println(int x) {
            this.delegate().println(x);
        }

        public void println(char x) {
            this.delegate().println(x);
        }

        public void println(boolean x) {
            this.delegate().println(x);
        }

        public void println(String x) {
            this.delegate().println(x);
        }

        public void println(char[] x) {
            this.delegate().println(x);
        }

        public void println() {
            this.delegate().println();
        }

        public void println(long x) {
            this.delegate().println(x);
        }

        public void write(int b) {
            this.delegate().write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate().write(b);
        }

        public void write(byte[] b, int off, int len) {
            this.delegate().write(b, off, len);
        }
    }
}

