/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdvancedActionPanel
extends JPanel {
    private static final String ATTR_TARGETS = "org.apache.tools.ant.module.preferredTargets";
    private static final String ATTR_PROPERTIES = "org.apache.tools.ant.module.preferredProperties";
    private static final String ATTR_VERBOSITY = "org.apache.tools.ant.module.preferredVerbosity";
    private static final String[] VERBOSITIES = new String[]{NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_warn"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_info"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_verbose"), NbBundle.getMessage(AdvancedActionPanel.class, (String)"LBL_verbosity_debug")};
    private static final int[] VERBOSITY_LEVELS = new int[]{1, 2, 3, 4};
    private final AntProjectCookie project;
    private final Set<TargetLister.Target> allTargets;
    private String defaultTarget = null;
    private JLabel propertiesLabel;
    private JEditorPane propertiesPane;
    private JScrollPane propertiesScrollPane;
    private JComboBox targetComboBox;
    private JTextField targetDescriptionField;
    private JLabel targetDescriptionLabel;
    private JLabel targetLabel;
    private JComboBox verbosityComboBox;
    private JLabel verbosityLabel;

    public AdvancedActionPanel(AntProjectCookie project, Set<TargetLister.Target> allTargets) {
        this.project = project;
        this.allTargets = allTargets;
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.targetDescriptionLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.targetDescriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.propertiesLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.propertiesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.verbosityLabel, (String)NbBundle.getMessage(AdvancedActionPanel.class, (String)"AdvancedActionsPanel.verbosityLabel.text"));
        EditorKit kit = this.propertiesPane.getEditorKit();
        String clazz = kit.getClass().getName();
        if (clazz.equals("javax.swing.text.DefaultEditorKit") || clazz.equals("javax.swing.JEditorPane$PlainEditorKit")) {
            this.propertiesPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        }
        this.targetComboBox.getInputMap().remove(KeyStroke.getKeyStroke("ENTER"));
        this.initializeFields();
    }

    private void initializeFields() {
        String initialProperties;
        FileObject script;
        block9: {
            script = this.project.getFileObject();
            assert (script != null) : "No file found for " + this.project;
            String initialTargets = (String)script.getAttribute(ATTR_TARGETS);
            TreeSet<Object> relevantTargets = new TreeSet<Object>(Collator.getInstance());
            for (TargetLister.Target target : this.allTargets) {
                if (target.isOverridden() || target.isInternal()) continue;
                relevantTargets.add(target.getName());
                if (this.defaultTarget != null || !target.isDefault()) continue;
                this.defaultTarget = target.getName();
            }
            this.targetComboBox.setModel(new DefaultComboBoxModel<Object>(relevantTargets.toArray()));
            if (initialTargets != null) {
                this.targetComboBox.setSelectedItem(initialTargets);
            } else {
                this.targetComboBox.setSelectedItem(this.defaultTarget);
            }
            this.targetComboBoxActionPerformed(null);
            initialProperties = (String)script.getAttribute(ATTR_PROPERTIES);
            if (initialProperties == null) {
                Properties props = new Properties();
                props.putAll(AntSettings.getProperties());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    props.store(baos, null);
                    String text = baos.toString("ISO-8859-1");
                    initialProperties = text.replaceFirst("^#.*\n", "");
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)e);
                }
            }
        }
        this.propertiesPane.setText(initialProperties);
        Integer verbosity = (Integer)script.getAttribute(ATTR_VERBOSITY);
        if (verbosity == null) {
            verbosity = AntSettings.getVerbosity();
        }
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(VERBOSITIES));
        for (int i = 0; i < VERBOSITY_LEVELS.length; ++i) {
            if (VERBOSITY_LEVELS[i] != verbosity) continue;
            this.verbosityComboBox.setSelectedItem(VERBOSITIES[i]);
            break;
        }
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetComboBox = new JComboBox();
        this.targetDescriptionLabel = new JLabel();
        this.targetDescriptionField = new JTextField();
        this.propertiesLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesPane = new JEditorPane();
        this.verbosityLabel = new JLabel();
        this.verbosityComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.targetLabel.setText("Select target(s) to run:");
        this.targetLabel.setLabelFor(this.targetComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetComboBox.setEditable(true);
        this.targetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"sampleTarget1", "sampleTarget2", "sampleTarget3"}));
        this.targetComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdvancedActionPanel.this.targetComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.targetComboBox, gridBagConstraints);
        this.targetDescriptionLabel.setText("Target description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.targetDescriptionLabel, gridBagConstraints);
        this.targetDescriptionField.setEditable(false);
        this.targetDescriptionField.setText("Sample description here.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.targetDescriptionField, gridBagConstraints);
        this.propertiesLabel.setText("Special Ant properties:");
        this.propertiesLabel.setLabelFor(this.propertiesPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 12;
        this.add((Component)this.propertiesLabel, gridBagConstraints);
        this.propertiesScrollPane.setPreferredSize(new Dimension(400, 150));
        this.propertiesScrollPane.setMinimumSize(new Dimension(400, 150));
        this.propertiesPane.setText("# This is sample text for GUI design.\nsomeprop1=someval1\nsomeprop2=someval2\nsomeprop3=someval3\n");
        this.propertiesPane.setContentType("text/x-properties");
        this.propertiesScrollPane.setViewportView(this.propertiesPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
        this.verbosityLabel.setText("Verbosity level:");
        this.verbosityLabel.setLabelFor(this.verbosityComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.verbosityLabel, gridBagConstraints);
        this.verbosityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Errors only [SAMPLE]", "Normal [SAMPLE]", "Verbose [SAMPLE]"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.verbosityComboBox, gridBagConstraints);
    }

    private void targetComboBoxActionPerformed(ActionEvent evt) {
        String selection = (String)this.targetComboBox.getSelectedItem();
        if (selection == null) {
            selection = "";
        }
        StringTokenizer tok = new StringTokenizer(selection, " ,");
        ArrayList targetsL = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)tok, String.class, (boolean)true));
        String description = "";
        if (targetsL.size() == 1) {
            String targetName = (String)targetsL.get(0);
            for (TargetLister.Target target : this.allTargets) {
                if (target.isOverridden() || !target.getName().equals(targetName)) continue;
                description = target.getElement().getAttribute("description");
                break;
            }
        }
        this.targetDescriptionField.setText(description);
    }

    public void run() throws IOException {
        StringTokenizer tok;
        ArrayList<String> targetsL;
        String selection = (String)this.targetComboBox.getSelectedItem();
        String[] targets = null;
        if (selection != null && !(targetsL = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)(tok = new StringTokenizer(selection, " ,")), String.class, (boolean)true))).isEmpty()) {
            targets = targetsL.toArray(new String[targetsL.size()]);
        }
        Properties props = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.propertiesPane.getText().getBytes("ISO-8859-1"));
        props.load(bais);
        int verbosity = 2;
        String verbosityString = (String)this.verbosityComboBox.getSelectedItem();
        for (int i = 0; i < VERBOSITIES.length; ++i) {
            if (!VERBOSITIES[i].equals(verbosityString)) continue;
            verbosity = VERBOSITY_LEVELS[i];
            break;
        }
        FileObject script = this.project.getFileObject();
        assert (script != null);
        if (targets == null || targets.length == 1 && targets[0].equals(this.defaultTarget)) {
            script.setAttribute(ATTR_TARGETS, null);
        } else {
            StringBuffer targetsSpaceSep = new StringBuffer();
            for (int i = 0; i < targets.length; ++i) {
                if (i > 0) {
                    targetsSpaceSep.append(' ');
                }
                targetsSpaceSep.append(targets[i]);
            }
            script.setAttribute(ATTR_TARGETS, (Object)targetsSpaceSep.toString());
        }
        if (props.equals(AntSettings.getProperties())) {
            script.setAttribute(ATTR_PROPERTIES, null);
        } else {
            script.setAttribute(ATTR_PROPERTIES, (Object)this.propertiesPane.getText());
        }
        if (verbosity == AntSettings.getVerbosity()) {
            script.setAttribute(ATTR_VERBOSITY, null);
        } else {
            script.setAttribute(ATTR_VERBOSITY, (Object)verbosity);
        }
        TargetExecutor exec = new TargetExecutor(this.project, targets);
        exec.setProperties(NbCollections.checkedMapByCopy((Map)props, String.class, String.class, (boolean)true));
        exec.setVerbosity(verbosity);
        exec.execute();
    }
}

