/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastTargetExecuted {
    private static File buildScript;
    private static int verbosity;
    private static String[] targets;
    private static Map<String, String> properties;
    private static final ChangeSupport cs;

    private LastTargetExecuted() {
    }

    static void record(File buildScript, int verbosity, String[] targets, Map<String, String> properties) {
        LastTargetExecuted.buildScript = buildScript;
        LastTargetExecuted.verbosity = verbosity;
        LastTargetExecuted.targets = targets;
        LastTargetExecuted.properties = properties;
        cs.fireChange();
    }

    public static AntProjectCookie getLastBuildScript() {
        block4: {
            if (buildScript != null && buildScript.isFile()) {
                FileObject fo = FileUtil.toFileObject((File)buildScript);
                assert (fo != null);
                try {
                    return (AntProjectCookie)DataObject.find((FileObject)fo).getCookie(AntProjectCookie.class);
                }
                catch (DataObjectNotFoundException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return null;
    }

    public static String[] getLastTargets() {
        return targets;
    }

    public static String getProcessDisplayName() {
        AntProjectCookie apc = LastTargetExecuted.getLastBuildScript();
        if (apc != null) {
            return TargetExecutor.getProcessDisplayName(apc, targets != null ? Arrays.asList(targets) : null);
        }
        return null;
    }

    public static ExecutorTask rerun() throws IOException {
        AntProjectCookie apc = LastTargetExecuted.getLastBuildScript();
        if (apc == null) {
            cs.fireChange();
            return null;
        }
        TargetExecutor t = new TargetExecutor(apc, targets);
        t.setVerbosity(verbosity);
        t.setProperties(properties);
        return t.execute();
    }

    public static void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public static void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    static {
        cs = new ChangeSupport(LastTargetExecuted.class);
    }
}

