/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.LastTargetExecuted;
import org.apache.tools.ant.module.run.StopBuildingAction;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetExecutor
implements Runnable {
    private static final Map<InputOutput, String> freeTabs = new WeakHashMap<InputOutput, String>();
    private static final Set<String> activeDisplayNames = new HashSet<String>();
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getVerbosity();
    private Map<String, String> properties = AntSettings.getProperties();
    private List<String> targetNames;
    private String displayName;
    private static final Map<InputOutput, StopAction> stopActions = new HashMap<InputOutput, StopAction>();
    private static final Map<InputOutput, RerunAction> rerunActions = new HashMap<InputOutput, RerunAction>();

    public TargetExecutor(AntProjectCookie pcookie, String[] targets) {
        this.pcookie = pcookie;
        this.targetNames = targets == null ? null : Arrays.asList(targets);
    }

    public void setVerbosity(int v) {
        this.verbosity = v;
    }

    public synchronized void setProperties(Map<String, String> p) {
        this.properties = new HashMap<String, String>(p);
    }

    static String getProcessDisplayName(AntProjectCookie pcookie, List<String> targetNames) {
        Element projel = pcookie.getProjectElement();
        String projectName = projel != null ? Actions.cutAmpersand((String)projel.getAttribute("name")) : NbBundle.getMessage(TargetExecutor.class, (String)"LBL_unparseable_proj_name");
        String fileName = pcookie.getFileObject() != null ? pcookie.getFileObject().getNameExt() : (pcookie.getFile() != null ? pcookie.getFile().getName() : "");
        if (projectName.equals("")) {
            projectName = fileName;
        }
        if (targetNames != null) {
            StringBuffer targetList = new StringBuffer();
            Iterator<String> it = targetNames.iterator();
            if (it.hasNext()) {
                targetList.append(it.next());
            }
            while (it.hasNext()) {
                targetList.append(NbBundle.getMessage(TargetExecutor.class, (String)"SEP_output_target"));
                targetList.append(it.next());
            }
            return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_target", (Object)projectName, (Object)fileName, (Object)targetList);
        }
        return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_notarget", (Object)projectName, (Object)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute() throws IOException {
        ExecutorTask task;
        Object testdn;
        Object dn = TargetExecutor.getProcessDisplayName(this.pcookie, this.targetNames);
        if (activeDisplayNames.contains(dn)) {
            int i = 2;
            while (activeDisplayNames.contains(testdn = NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.uniquified", (Object)dn, (Object)i++))) {
            }
            dn = testdn;
        }
        assert (!activeDisplayNames.contains(dn));
        this.displayName = dn;
        activeDisplayNames.add(this.displayName);
        testdn = this;
        synchronized (testdn) {
            if (AntSettings.getAutoCloseTabs()) {
                Map<InputOutput, String> map = freeTabs;
                synchronized (map) {
                    for (Map.Entry<InputOutput, String> entry : freeTabs.entrySet()) {
                        InputOutput free = entry.getKey();
                        String freeName = entry.getValue();
                        if (this.io == null && freeName.equals(this.displayName)) {
                            this.io = free;
                            this.io.getOut().reset();
                            continue;
                        }
                        free.closeInputOutput();
                        stopActions.remove(free);
                        rerunActions.remove(free);
                    }
                    freeTabs.clear();
                }
            }
            if (this.io == null) {
                StopAction sa = new StopAction();
                RerunAction ra = new RerunAction(this);
                this.io = IOProvider.getDefault().getIO(this.displayName, new Action[]{ra, sa});
                stopActions.put(this.io, sa);
                rerunActions.put(this.io, ra);
            }
            task = ExecutionEngine.getDefault().execute(null, (Runnable)this, InputOutput.NULL);
        }
        WrapperExecutorTask wrapper = new WrapperExecutorTask(task, this.io);
        RequestProcessor.getDefault().post((Runnable)((Object)wrapper));
        return wrapper;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask task = ExecutionEngine.getDefault().execute(null, (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void run() {
        RerunAction ra;
        StopAction sa;
        Thread[] thisProcess;
        block21: {
            block19: {
                Map<InputOutput, String> map;
                block20: {
                    thisProcess = new Thread[1];
                    sa = stopActions.get(this.io);
                    assert (sa != null);
                    ra = rerunActions.get(this.io);
                    assert (ra != null);
                    try {
                        final boolean[] displayed = new boolean[]{AntSettings.getAlwaysShowOutput()};
                        if (this.outputStream == null && displayed[0]) {
                            this.io.select();
                        }
                        if (AntSettings.getSaveAll()) {
                            LifecycleManager.getDefault().saveAll();
                        }
                        if (this.outputStream != null) throw new RuntimeException("XXX No support for outputStream currently!");
                        OutputWriter out = this.io.getOut();
                        OutputWriter err = this.io.getErr();
                        File buildFile = this.pcookie.getFile();
                        if (buildFile == null) {
                            err.println(NbBundle.getMessage(TargetExecutor.class, (String)"EXC_non_local_proj_file"));
                            Object var12_8 = null;
                            if (this.io == null) break block19;
                            map = freeTabs;
                            break block20;
                        }
                        LastTargetExecuted.record(buildFile, this.verbosity, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null, this.properties);
                        Thread.currentThread().setPriority(3);
                        final Runnable interestingOutputCallback = new Runnable(){

                            public void run() {
                                if (!displayed[0]) {
                                    displayed[0] = true;
                                    TargetExecutor.this.io.select();
                                }
                            }
                        };
                        ReaderInputStream in = null;
                        if (this.outputStream == null) {
                            try {
                                in = new ReaderInputStream(this.io.getIn()){

                                    public int read() throws IOException {
                                        interestingOutputCallback.run();
                                        return super.read();
                                    }

                                    public int read(byte[] b) throws IOException {
                                        interestingOutputCallback.run();
                                        return super.read(b);
                                    }

                                    public int read(byte[] b, int off, int len) throws IOException {
                                        interestingOutputCallback.run();
                                        return super.read(b, off, len);
                                    }

                                    public long skip(long n) throws IOException {
                                        interestingOutputCallback.run();
                                        return super.skip(n);
                                    }
                                };
                            }
                            catch (IOException e) {
                                AntModule.err.notify(1, (Throwable)e);
                            }
                        }
                        thisProcess[0] = Thread.currentThread();
                        StopBuildingAction.registerProcess(thisProcess[0], this.displayName);
                        sa.t = thisProcess[0];
                        ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                            public boolean cancel() {
                                sa.actionPerformed(null);
                                return true;
                            }
                        }, (Action)new AbstractAction(){

                            public void actionPerformed(ActionEvent e) {
                                TargetExecutor.this.io.select();
                            }
                        });
                        handle.setInitialDelay(0);
                        handle.start();
                        sa.setEnabled(true);
                        ra.setEnabled(false);
                        this.ok = AntBridge.getInterface().run(buildFile, this.targetNames, (InputStream)in, out, err, this.properties, this.verbosity, this.displayName, interestingOutputCallback, handle);
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var12_10 = null;
                        if (this.io != null) {
                            Map<InputOutput, String> map2 = freeTabs;
                            synchronized (map2) {
                                freeTabs.put(this.io, this.displayName);
                            }
                        }
                        if (thisProcess[0] != null) {
                            StopBuildingAction.unregisterProcess(thisProcess[0]);
                        }
                        sa.t = null;
                        sa.setEnabled(false);
                        ra.setEnabled(true);
                        activeDisplayNames.remove(this.displayName);
                        throw throwable;
                    }
                }
                synchronized (map) {
                    freeTabs.put(this.io, this.displayName);
                }
            }
            if (thisProcess[0] != null) {
                StopBuildingAction.unregisterProcess(thisProcess[0]);
            }
            sa.t = null;
            sa.setEnabled(false);
            ra.setEnabled(true);
            activeDisplayNames.remove(this.displayName);
            return;
        }
        Object var12_9 = null;
        if (this.io != null) {
            Map<InputOutput, String> map = freeTabs;
            synchronized (map) {
                freeTabs.put(this.io, this.displayName);
            }
        }
        if (thisProcess[0] != null) {
            StopBuildingAction.unregisterProcess(thisProcess[0]);
        }
        sa.t = null;
        sa.setEnabled(false);
        ra.setEnabled(true);
        activeDisplayNames.remove(this.displayName);
    }

    static void stopProcess(Thread t) {
        AntBridge.getInterface().stop(t);
    }

    private static final class RerunAction
    extends AbstractAction
    implements FileChangeListener {
        private final AntProjectCookie pcookie;
        private final List<String> targetNames;
        private final int verbosity;
        private final Map<String, String> properties;

        public RerunAction(TargetExecutor prototype) {
            this.pcookie = prototype.pcookie;
            this.targetNames = prototype.targetNames;
            this.verbosity = prototype.verbosity;
            this.properties = prototype.properties;
            this.setEnabled(false);
            FileObject script = this.pcookie.getFileObject();
            if (script != null) {
                script.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)script));
            }
        }

        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/rerun.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.RerunAction.rerun");
            }
            return super.getValue(key);
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            try {
                TargetExecutor exec = new TargetExecutor(this.pcookie, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null);
                exec.setVerbosity(this.verbosity);
                exec.setProperties(this.properties);
                exec.execute();
            }
            catch (IOException x) {
                Logger.getLogger(TargetExecutor.class.getName()).log(Level.INFO, null, x);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.firePropertyChange("enabled", null, false);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public boolean isEnabled() {
            return super.isEnabled() && this.pcookie.getFileObject() != null && this.pcookie.getFileObject().isValid();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        public Thread t;

        public StopAction() {
            this.setEnabled(false);
        }

        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/stop.gif"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.StopAction.stop");
            }
            return super.getValue(key);
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (this.t != null) {
                TargetExecutor.stopProcess(this.t);
            }
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput io;

        public WrapperExecutorTask(ExecutorTask task, InputOutput io) {
            super((Runnable)new WrapperRunnable(task));
            this.task = task;
            this.io = io;
        }

        public void stop() {
            StopAction sa = (StopAction)stopActions.get(this.io);
            if (sa != null) {
                sa.actionPerformed(null);
            } else {
                this.task.stop();
            }
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.io;
        }
    }

    private static class WrapperRunnable
    implements Runnable {
        private final ExecutorTask task;

        public WrapperRunnable(ExecutorTask task) {
            this.task = task;
        }

        public void run() {
            this.task.waitFinished();
        }
    }
}

