/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectFolderPanel
extends JPanel
implements DocumentListener {
    private final String prop;
    private final boolean stripAmps;
    private final SelectFolderWizardPanel wiz;
    private final DataFolder top;
    private JTextField displayNameField;
    private JLabel displayNameLabel;
    private JPanel displayNamePanel;
    private JList folderList;
    private JScrollPane folderScrollPane;
    private JTextArea hintsArea;

    public SelectFolderPanel(SelectFolderWizardPanel wiz, String name, String hint, String displayNameLabelText, DataFolder top, boolean stripAmps, String prop) {
        this.wiz = wiz;
        this.initComponents();
        this.setName(name);
        this.hintsArea.setText(hint);
        this.initAccessibility(hint);
        this.displayNameLabel.setText(displayNameLabelText);
        this.prop = prop;
        this.top = top;
        this.stripAmps = stripAmps;
        DefaultListModel<DataFolder> model = new DefaultListModel<DataFolder>();
        DataFolder[] folders = SelectFolderPanel.findFolders(top);
        for (int i = 0; i < folders.length; ++i) {
            model.addElement(folders[i]);
        }
        this.folderList.setModel(model);
        this.folderList.setCellRenderer(new CellRenderer());
        this.displayNameField.getDocument().addDocumentListener(this);
    }

    ListModel getModel() {
        return this.folderList.getModel();
    }

    private String getDisplayName(DataFolder folder) {
        int idx;
        String name = folder.getNodeDelegate().getDisplayName();
        if (this.stripAmps && (idx = name.indexOf(38)) != -1) {
            name = name.substring(0, idx) + name.substring(idx + 1);
        }
        return name;
    }

    String getNestedDisplayName(DataFolder folder) {
        StringBuffer b = new StringBuffer();
        for (DataFolder f = folder; f != this.top; f = f.getFolder()) {
            if (b.length() > 0) {
                b.insert(0, " \u2192 ");
            }
            b.insert(0, this.getDisplayName(f));
        }
        return b.toString();
    }

    private DataFolder getFolder() {
        return (DataFolder)this.folderList.getSelectedValue();
    }

    private void setFolder(DataFolder f) {
        this.folderList.setSelectedValue(f, true);
    }

    private static DataFolder[] findFolders(DataFolder top) {
        ArrayList<DataFolder> folders = new ArrayList<DataFolder>();
        SelectFolderPanel.visit(folders, top);
        folders.remove(0);
        return folders.toArray(new DataFolder[folders.size()]);
    }

    private static void visit(List<DataFolder> folders, DataFolder f) {
        folders.add(f);
        DataObject[] kids = f.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (!(kids[i] instanceof DataFolder)) continue;
            SelectFolderPanel.visit(folders, (DataFolder)kids[i]);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.folderList.requestFocus();
    }

    private void initAccessibility(String hint) {
        this.getAccessibleContext().setAccessibleDescription(hint);
    }

    private void initComponents() {
        this.hintsArea = new JTextArea();
        this.folderScrollPane = new JScrollPane();
        this.folderList = new JList();
        this.displayNamePanel = new JPanel();
        this.displayNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.setLayout(new BorderLayout(0, 11));
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setText("<hints>");
        this.hintsArea.setBackground(new Color(204, 204, 204));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setForeground(new Color(102, 102, 153));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setOpaque(false);
        this.hintsArea.setEnabled(false);
        this.add((Component)this.hintsArea, "North");
        this.folderList.setSelectionMode(0);
        this.folderList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SelectFolderPanel.this.folderListValueChanged(evt);
            }
        });
        this.folderScrollPane.setViewportView(this.folderList);
        this.folderList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectFolderPanel.class, (String)"ACSN_folderList"));
        this.folderList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectFolderPanel.class, (String)"ACSD_folderList"));
        this.add((Component)this.folderScrollPane, "Center");
        this.displayNamePanel.setLayout(new FlowLayout(0));
        this.displayNameLabel.setText("<set display name>");
        this.displayNameLabel.setLabelFor(this.displayNameField);
        this.displayNamePanel.add(this.displayNameLabel);
        this.displayNameField.setColumns(30);
        this.displayNamePanel.add(this.displayNameField);
        this.add((Component)this.displayNamePanel, "South");
    }

    private void folderListValueChanged(ListSelectionEvent evt) {
        this.wiz.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.wiz.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.wiz.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private final class CellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataFolder f = (DataFolder)value;
            String display = SelectFolderPanel.this.getNestedDisplayName(f);
            return super.getListCellRendererComponent((JList<?>)list, display, index, isSelected, cellHasFocus);
        }
    }

    public static class SelectFolderWizardPanel
    implements WizardDescriptor.Panel {
        private SelectFolderPanel panel;
        private String namePanel;
        private String hintPanel;
        private String displayNameLabelText;
        private DataFolder topPanel;
        private boolean stripAmpsPanel;
        private String propPanel;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public SelectFolderWizardPanel(String name, String hint, String displayNameLabelText, DataFolder top, boolean stripAmps, String prop) {
            this.namePanel = name;
            this.hintPanel = hint;
            this.displayNameLabelText = displayNameLabelText;
            this.topPanel = top;
            this.stripAmpsPanel = stripAmps;
            this.propPanel = prop;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        SelectFolderPanel getPanel() {
            if (this.panel == null) {
                this.panel = new SelectFolderPanel(this, this.namePanel, this.hintPanel, this.displayNameLabelText, this.topPanel, this.stripAmpsPanel, this.propPanel);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return this.getPanel().getFolder() != null && this.getPanel().displayNameField.getText().length() > 0;
        }

        public final void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public final void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        protected final void fireChangeEvent() {
            this.cs.fireChange();
        }

        public void readSettings(Object settings) {
            WizardDescriptor wiz = (WizardDescriptor)settings;
            this.getPanel().setFolder((DataFolder)wiz.getProperty(this.getPanel().prop));
            String dn = (String)wiz.getProperty("wizdata.displayName");
            this.getPanel().displayNameField.setText(dn != null ? dn : "");
        }

        public void storeSettings(Object settings) {
            DataFolder folder = this.getPanel().getFolder();
            WizardDescriptor wiz = (WizardDescriptor)settings;
            wiz.putProperty(this.getPanel().prop, (Object)folder);
            wiz.putProperty("wizdata.displayName", (Object)this.getPanel().displayNameField.getText());
        }
    }
}

