/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.KeyStroke;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ShortcutWizard
extends WizardDescriptor {
    private static final String PROP_CONTENTS = "wizdata.contents";
    static final String PROP_DISPLAY_NAME = "wizdata.displayName";
    static final String PROP_SHOW_CUST = "wizdata.show.cust";
    static final String PROP_SHOW_MENU = "wizdata.show.menu";
    static final String PROP_SHOW_TOOL = "wizdata.show.tool";
    static final String PROP_SHOW_KEYB = "wizdata.show.keyb";
    static final String PROP_FOLDER_MENU = "wizdata.folder.menu";
    static final String PROP_FOLDER_TOOL = "wizdata.folder.tool";
    static final String PROP_STROKE = "wizdata.stroke";
    private final AntProjectCookie project;
    private final Element target;
    private final ShortcutIterator it;

    public static void show(AntProjectCookie project, Element target) {
        ShortcutWizard wiz = new ShortcutWizard(project, target, new ShortcutIterator());
        DialogDisplayer.getDefault().createDialog((DialogDescriptor)wiz).setVisible(true);
        if (wiz.getValue().equals(WizardDescriptor.FINISH_OPTION)) {
            try {
                wiz.finish();
            }
            catch (IOException ioe) {
                AntModule.err.notify((Throwable)ioe);
            }
        }
    }

    ShortcutWizard(AntProjectCookie project, Element target, ShortcutIterator it) {
        super((WizardDescriptor.Iterator)it);
        this.project = project;
        this.target = target;
        this.it = it;
        it.initialize(this);
        this.setTitle(NbBundle.getMessage(ShortcutWizard.class, (String)"TITLE_wizard"));
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        String desc = target.getAttribute("description");
        this.putProperty(PROP_DISPLAY_NAME, desc);
    }

    String getContents() {
        String c = (String)this.getProperty(PROP_CONTENTS);
        if (c == null) {
            c = this.generateContents();
            this.putContents(c);
        }
        return c;
    }

    void putContents(String c) {
        this.putProperty(PROP_CONTENTS, c);
    }

    private String generateContents() {
        try {
            Document doc = XMLUtil.createDocument((String)"project", null, null, null);
            Element pel = doc.getDocumentElement();
            String displayName = (String)this.getProperty(PROP_DISPLAY_NAME);
            if (displayName != null && displayName.length() > 0) {
                pel.setAttribute("name", displayName);
            }
            pel.setAttribute("default", "run");
            Element tel = doc.createElement("target");
            tel.setAttribute("name", "run");
            Element ael = doc.createElement("ant");
            ael.setAttribute("antfile", this.project.getFile().getAbsolutePath());
            ael.setAttribute("inheritall", "false");
            ael.setAttribute("target", this.target.getAttribute("name"));
            tel.appendChild(ael);
            pel.appendChild(tel);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            AntModule.err.notify((Throwable)e);
            return "";
        }
    }

    void finish() throws IOException {
        if (this.it.showing(PROP_SHOW_MENU)) {
            this.create((DataFolder)this.getProperty(PROP_FOLDER_MENU), null);
        }
        if (this.it.showing(PROP_SHOW_TOOL)) {
            this.create((DataFolder)this.getProperty(PROP_FOLDER_TOOL), null);
        }
        if (this.it.showing(PROP_SHOW_KEYB)) {
            FileObject shortcutsFolder = Repository.getDefault().getDefaultFileSystem().findResource("Shortcuts");
            KeyStroke stroke = (KeyStroke)this.getProperty(PROP_STROKE);
            this.create(DataFolder.findFolder((FileObject)shortcutsFolder), Utilities.keyToString((KeyStroke)stroke));
        }
    }

    private void create(DataFolder f, String name) throws IOException {
        assert (f != null);
        final String fname = name != null ? name + ".xml" : FileUtil.findFreeFileName((FileObject)f.getPrimaryFile(), (String)this.getTargetBaseName(), (String)"xml") + ".xml";
        final String contents = this.getContents();
        final FileObject folder = f.getPrimaryFile();
        final FileObject[] shortcut = new FileObject[1];
        folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                shortcut[0] = folder.createData(fname);
                FileLock lock = shortcut[0].lock();
                try {
                    OutputStream os = shortcut[0].getOutputStream(lock);
                    try {
                        os.write(contents.getBytes("UTF-8"));
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        });
    }

    String getTargetBaseName() {
        String projname = "";
        Document doc = this.project.getDocument();
        if (doc != null) {
            projname = doc.getDocumentElement().getAttribute("name");
        }
        return (projname + '-' + this.target.getAttribute("name")).replaceAll("[^a-zA-Z0-9_-]", "-");
    }
}

