/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.versioning.spi.VCSInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalHistoryVCSInterceptor
extends VCSInterceptor {
    private Map<String, StorageMoveHandler> moveHandlerMap;
    private Set<File> toBeDeleted = new HashSet<File>();
    private Set<File> toBeCreated = new HashSet<File>();
    private Set<File> wasJustCreated = new HashSet<File>();

    private LocalHistoryStore getStore() {
        return LocalHistory.getInstance().getLocalHistoryStore();
    }

    public boolean beforeDelete(File file) {
        if (!this.accept(file)) {
            return false;
        }
        this.toBeDeleted.add(file);
        this.storeFile(file);
        return false;
    }

    public void doDelete(File file) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDelete(File file) {
        if (!this.toBeDeleted.remove(file)) {
            return;
        }
        String key = file.getAbsolutePath();
        if (this.getMoveHandlerMap().containsKey(key)) {
            StorageMoveHandler handler = this.getMoveHandlerMap().get(key);
            try {
                handler.delete();
            }
            finally {
                this.getMoveHandlerMap().remove(key);
            }
        } else {
            this.getStore().fileDelete(file, System.currentTimeMillis());
        }
    }

    public boolean beforeMove(File from, File to) {
        if (!this.accept(from)) {
            return false;
        }
        StorageMoveHandler handler = new StorageMoveHandler(from, to);
        this.getMoveHandlerMap().put(to.getAbsolutePath(), handler);
        this.getMoveHandlerMap().put(from.getAbsolutePath(), handler);
        return false;
    }

    public void doMove(File from, File to) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(File from, File to) {
        String key = to.getAbsolutePath();
        if (this.getMoveHandlerMap().containsKey(key)) {
            StorageMoveHandler handler = this.getMoveHandlerMap().get(key);
            try {
                handler.create();
                handler.delete();
            }
            finally {
                this.getMoveHandlerMap().remove(key);
                this.getMoveHandlerMap().remove(from.getAbsolutePath());
            }
        }
    }

    public boolean beforeCreate(File file, boolean isDirectory) {
        this.toBeCreated.add(file);
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(File file) {
        this.toBeCreated.remove(file);
        if (file.isFile()) {
            this.wasJustCreated.add(file);
        }
        String key = file.getAbsolutePath();
        if (this.getMoveHandlerMap().containsKey(key)) {
            StorageMoveHandler handler = this.getMoveHandlerMap().get(key);
            try {
                handler.create();
            }
            finally {
                this.getMoveHandlerMap().remove(key);
            }
        }
    }

    public void beforeChange(File file) {
        if (this.toBeCreated.contains(file) || this.wasJustCreated.remove(file)) {
            return;
        }
        if (!this.accept(file)) {
            return;
        }
        this.storeFile(file);
    }

    public void afterChange(File file) {
        this.wasJustCreated.remove(file);
    }

    private void storeFile(File file) {
        this.getStore().fileChange(file, file.lastModified());
    }

    private Map<String, StorageMoveHandler> getMoveHandlerMap() {
        if (this.moveHandlerMap == null) {
            this.moveHandlerMap = new HashMap<String, StorageMoveHandler>();
        }
        return this.moveHandlerMap;
    }

    private boolean accept(File file) {
        return LocalHistory.getInstance().isManaged(file);
    }

    private class StorageMoveHandler {
        private long ts = -1L;
        private final File from;
        private final File to;

        StorageMoveHandler(File from, File to) {
            this.from = from;
            this.to = to;
        }

        public void delete() {
            LocalHistoryVCSInterceptor.this.getStore().fileDeleteFromMove(this.from, this.to, this.ts);
        }

        public void create() {
            this.ts = this.to.lastModified();
            LocalHistoryVCSInterceptor.this.getStore().fileCreateFromMove(this.from, this.to, this.ts);
        }
    }
}

