/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.DiffPanel;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent;
import org.netbeans.modules.localhistory.ui.view.StoreEntryNode;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class LocalHistoryDiffView
implements PropertyChangeListener,
ActionListener {
    private final LocalHistoryTopComponent master;
    private DiffPanel panel;
    private Component diffComponent;
    private DiffView diffView;

    public LocalHistoryDiffView(LocalHistoryTopComponent master) {
        this.master = master;
        this.panel = new DiffPanel();
        this.panel.nextButton.addActionListener(this);
        this.panel.prevButton.addActionListener(this);
        this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_NoVersion"));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.selectionChanged(evt);
        }
    }

    JPanel getPanel() {
        return this.panel;
    }

    private void selectionChanged(PropertyChangeEvent evt) {
        Node[] newSelection = (Node[])evt.getNewValue();
        if (newSelection == null || newSelection.length == 0) {
            this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_NoVersion"));
            return;
        }
        StoreEntry se = (StoreEntry)newSelection[0].getLookup().lookup(StoreEntry.class);
        if (se == null) {
            this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_IllegalSelection"));
            return;
        }
        this.refreshDiffPanel(se);
    }

    private void refreshDiffPanel(StoreEntry se) {
        DiffPrepareTask prepareTask = new DiffPrepareTask(se);
        RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)prepareTask);
        task.schedule(0);
    }

    private void showNoContent(String s) {
        this.setDiffComponent((Component)new NoContentPanel(s));
    }

    private void setDiffComponent(Component component) {
        if (this.diffComponent != null) {
            this.panel.diffPanel.remove(this.diffComponent);
        }
        this.panel.diffPanel.add(component, "Center");
        this.diffComponent = component;
        this.panel.diffPanel.revalidate();
        this.panel.diffPanel.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.nextButton) {
            this.onNextButton();
        } else if (evt.getSource() == this.panel.prevButton) {
            this.onPrevButton();
        }
    }

    private void onNextButton() {
        if (this.diffView == null) {
            return;
        }
        int nextDiffernce = this.diffView.getCurrentDifference() + 1;
        if (nextDiffernce < this.diffView.getDifferenceCount()) {
            this.setCurrentDifference(nextDiffernce);
        }
    }

    private void onPrevButton() {
        if (this.diffView == null) {
            return;
        }
        int prevDiffernce = this.diffView.getCurrentDifference() - 1;
        if (prevDiffernce > -1) {
            this.setCurrentDifference(prevDiffernce);
        }
    }

    private void setCurrentDifference(int idx) {
        this.diffView.setCurrentDifference(idx);
        this.refreshNavigationButtons();
    }

    private void refreshNavigationButtons() {
        int currentDifference = this.diffView.getCurrentDifference();
        this.panel.prevButton.setEnabled(currentDifference > 0);
        this.panel.nextButton.setEnabled(currentDifference < this.diffView.getDifferenceCount() - 1);
    }

    private class DiffPrepareTask
    implements Runnable {
        private final StoreEntry entry;

        public DiffPrepareTask(StoreEntry se) {
            this.entry = se;
        }

        public void run() {
            final Diff diff = Diff.getDefault();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        StreamSource ss2;
                        StreamSource ss1 = StreamSource.createSource((String)"historyfile", (String)(DiffPrepareTask.this.entry.getFile().getName() + " " + StoreEntryNode.getFormatedDate(DiffPrepareTask.this.entry)), (String)DiffPrepareTask.this.entry.getMIMEType(), (Reader)new InputStreamReader(DiffPrepareTask.this.entry.getStoreFileInputStream()));
                        File file = DiffPrepareTask.this.entry.getFile();
                        if (file.exists()) {
                            String title = NbBundle.getMessage(LocalHistoryDiffView.class, (String)"LBL_Diff_CurrentFile");
                            ss2 = new LHStreamSource(file, title, DiffPrepareTask.this.entry.getMIMEType());
                        } else {
                            String title = NbBundle.getMessage(LocalHistoryDiffView.class, (String)"LBL_Diff_FileDeleted");
                            ss2 = StreamSource.createSource((String)"currentfile", (String)title, (String)DiffPrepareTask.this.entry.getMIMEType(), (Reader)new StringReader(""));
                        }
                        LocalHistoryDiffView.this.diffView = diff.createDiff(ss1, ss2);
                        JComponent c = (JComponent)LocalHistoryDiffView.this.diffView.getComponent();
                        LocalHistoryDiffView.this.setDiffComponent(c);
                        LocalHistoryDiffView.this.master.setDiffView(c);
                        if (LocalHistoryDiffView.this.diffView.getDifferenceCount() > 0) {
                            LocalHistoryDiffView.this.setCurrentDifference(0);
                        } else {
                            LocalHistoryDiffView.this.refreshNavigationButtons();
                        }
                        LocalHistoryDiffView.this.panel.revalidate();
                        LocalHistoryDiffView.this.panel.repaint();
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            });
        }
    }

    private class LHStreamSource
    extends StreamSource {
        private final File file;
        private final String title;
        private final String mimeType;

        public LHStreamSource(File file, String title, String mimeType) {
            this.file = file;
            this.title = title;
            this.mimeType = mimeType;
        }

        public boolean isEditable() {
            FileObject fo = FileUtil.toFileObject((File)this.file);
            return this.isPrimary(fo);
        }

        private boolean isPrimary(FileObject fo) {
            if (fo != null) {
                try {
                    DataObject dao = DataObject.find((FileObject)fo);
                    return fo.equals(dao.getPrimaryFile());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }

        public Lookup getLookup() {
            FileObject fo = FileUtil.toFileObject((File)this.file);
            if (fo != null && this.isPrimary(fo)) {
                return Lookups.fixed((Object[])new Object[]{fo});
            }
            return Lookups.fixed((Object[])new Object[0]);
        }

        public String getName() {
            return this.title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            return new FileReader(this.file);
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }
}

