/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryDiffView;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryFileView;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ShowLocalHistoryAction
extends NodeAction {
    public ShowLocalHistoryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] activatedNodes) {
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        final Set rootSet = ctx.getRootFiles();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File[] files = rootSet.toArray(new File[rootSet.size()]);
                final LocalHistoryTopComponent tc = new LocalHistoryTopComponent();
                tc.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_LocalHistoryTopComponent", (Object)files[0].getName()));
                tc.open();
                tc.requestActive();
                if (files[0].isFile()) {
                    LocalHistoryFileView fileView = new LocalHistoryFileView();
                    LocalHistoryDiffView diffView = new LocalHistoryDiffView(tc);
                    fileView.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)diffView);
                    fileView.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("selectedNodes".equals(evt.getPropertyName())) {
                                tc.setActivatedNodes((Node[])evt.getNewValue());
                            }
                        }
                    });
                    tc.init(diffView.getPanel(), fileView);
                    fileView.refresh(files);
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        VCSContext ctx = VCSContext.forNodes((Node[])activatedNodes);
        Set rootSet = ctx.getRootFiles();
        if (rootSet == null) {
            return false;
        }
        for (File file : rootSet) {
            if (file == null || file.isFile()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowLocalHistory");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ShowLocalHistoryAction.class);
    }
}

