/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyVerifier {
    private ConsistencyVerifier() {
    }

    public static SortedMap<String, SortedSet<String>> findInconsistencies(Set<Manifest> modules) throws IllegalArgumentException {
        ModuleManager mgr = new ModuleManager(new DummyInstaller(), new DummyEvents());
        mgr.mutexPrivileged().enterWriteAccess();
        Manifest dummy = new Manifest();
        dummy.getMainAttributes().putValue("OpenIDE-Module", "__dummy__");
        dummy.getMainAttributes().putValue("OpenIDE-Module-Provides", "org.openide.modules.ModuleFormat1, org.openide.modules.os.Unix, org.openide.modules.os.PlainUnix, org.openide.modules.os.Windows, org.openide.modules.os.MacOSX, org.openide.modules.os.OS2");
        dummy.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
        try {
            mgr.createFixed(dummy, null, ClassLoader.getSystemClassLoader());
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
        HashSet<Module> mods = new HashSet<Module>();
        for (Manifest m : modules) {
            try {
                m.getMainAttributes().putValue("OpenIDE-Module-Public-Packages", "-");
                mods.add(mgr.createFixed(m, null, ClassLoader.getSystemClassLoader()));
            }
            catch (Exception x) {
                throw new IllegalArgumentException(x);
            }
        }
        TreeMap<String, SortedSet<String>> problems = new TreeMap<String, SortedSet<String>>();
        for (Module m : mods) {
            Set<Object> probs = m.getProblems();
            if (probs.isEmpty()) continue;
            TreeSet<String> probnames = new TreeSet<String>();
            for (Object prob : probs) {
                probnames.add(prob.toString());
            }
            problems.put(m.getCodeNameBase(), probnames);
        }
        return problems;
    }

    private static final class DummyEvents
    extends Events {
        private DummyEvents() {
        }

        protected void logged(String message, Object[] args) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyInstaller
    extends ModuleInstaller {
        private DummyInstaller() {
        }

        @Override
        public void prepare(Module m) throws InvalidException {
            throw new AssertionError();
        }

        @Override
        public void dispose(Module m) {
            throw new AssertionError();
        }

        @Override
        public void load(List<Module> modules) {
            throw new AssertionError();
        }

        @Override
        public void unload(List<Module> modules) {
            throw new AssertionError();
        }

        @Override
        public boolean closing(List<Module> modules) {
            throw new AssertionError();
        }

        @Override
        public void close(List<Module> modules) {
            throw new AssertionError();
        }
    }
}

