/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagBasedLexerFormatter
extends ExtFormatter {
    private static final Logger logger = Logger.getLogger(TagBasedLexerFormatter.class.getName());

    public TagBasedLexerFormatter(Class kitClass) {
        super(kitClass);
    }

    protected abstract boolean isClosingTag(TokenHierarchy var1, int var2);

    protected abstract boolean isUnformattableToken(TokenHierarchy var1, int var2);

    protected abstract boolean isUnformattableTag(String var1);

    protected abstract boolean isOpeningTag(TokenHierarchy var1, int var2);

    protected abstract String extractTagName(TokenHierarchy var1, int var2);

    protected abstract boolean areTagNamesEqual(String var1, String var2);

    protected abstract boolean isClosingTagRequired(BaseDocument var1, String var2);

    protected abstract int getOpeningSymbolOffset(TokenHierarchy var1, int var2);

    protected abstract int getTagEndingAtPosition(TokenHierarchy var1, int var2) throws BadLocationException;

    protected abstract int getTagEndOffset(TokenHierarchy var1, int var2);

    protected boolean isWSTag(Token tag) {
        char[] chars;
        for (char c : chars = ((Object)tag.text()).toString().toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected int getIndentForTagParameter(TokenHierarchy<?> tokenHierarchy, int tagOffset) throws BadLocationException {
        BaseDocument doc = (BaseDocument)tokenHierarchy.mutableInputSource();
        int tagStartLine = Utilities.getLineOffset((BaseDocument)doc, (int)tagOffset);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(tagOffset);
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            int tokenOffset = tokenSequence.offset();
            if (this.isWSTag(token) && tagStartLine == Utilities.getLineOffset((BaseDocument)doc, (int)tokenOffset)) continue;
            if (this.isWSTag(token) || tagStartLine != Utilities.getLineOffset((BaseDocument)doc, (int)tokenOffset)) break;
            return tokenOffset - Utilities.getRowIndent((BaseDocument)doc, (int)tokenOffset) - Utilities.getRowStart((BaseDocument)doc, (int)tokenOffset);
        }
        return this.getShiftWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer reformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException, IOException {
        LinkedList<TagIndentationData> unprocessedOpeningTags = new LinkedList<TagIndentationData>();
        ArrayList<TagIndentationData> matchedOpeningTags = new ArrayList<TagIndentationData>();
        doc.atomicLock();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        if (tokenHierarchy == null) {
            logger.severe("Could not retrieve TokenHierarchy for document " + doc);
            return null;
        }
        try {
            int lastLine = Utilities.getLineOffset((BaseDocument)doc, (int)doc.getLength());
            int firstRefBlockLine = Utilities.getLineOffset((BaseDocument)doc, (int)startOffset);
            int lastRefBlockLine = Utilities.getLineOffset((BaseDocument)doc, (int)endOffset);
            int firstUnformattableLine = -1;
            boolean[] unformattableLines = new boolean[lastLine + 1];
            int[] indentsWithinTags = new int[lastLine + 1];
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.moveStart();
            boolean thereAreMoreTokens = tokenSequence.moveNext();
            if (tokenSequence != null) {
                do {
                    boolean wasPreviousTokenUnformattable;
                    boolean isOpenTag = this.isOpeningTag(tokenHierarchy, tokenSequence.offset());
                    boolean isCloseTag = this.isClosingTag(tokenHierarchy, tokenSequence.offset());
                    if (isOpenTag || isCloseTag) {
                        String tagName = this.extractTagName(tokenHierarchy, tokenSequence.offset());
                        int tagEndOffset = this.getTagEndOffset(tokenHierarchy, tokenSequence.offset());
                        int lastTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tagEndOffset);
                        if (isOpenTag) {
                            TagIndentationData tagData = new TagIndentationData(tagName, lastTagLine);
                            unprocessedOpeningTags.add(tagData);
                            int firstTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset());
                            if (firstTagLine < lastTagLine) {
                                int indentWithinTag = this.getIndentForTagParameter(tokenHierarchy, tokenSequence.offset());
                                for (int i = firstTagLine + 1; i <= lastTagLine; ++i) {
                                    indentsWithinTags[i] = indentWithinTag;
                                }
                                thereAreMoreTokens &= tokenSequence.moveNext();
                                while (Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset()) < lastTagLine || this.isWSTag(tokenSequence.token())) {
                                    tokenSequence.moveNext();
                                }
                                if (tokenSequence.offset() == tagEndOffset) {
                                    indentsWithinTags[lastTagLine] = 0;
                                }
                            }
                        } else {
                            LinkedList<TagIndentationData> tagsToBeRemoved = new LinkedList<TagIndentationData>();
                            while (!unprocessedOpeningTags.isEmpty()) {
                                TagIndentationData processedTD = (TagIndentationData)unprocessedOpeningTags.removeLast();
                                if (this.areTagNamesEqual(tagName, processedTD.getTagName())) {
                                    processedTD.setClosedOnLine(lastTagLine);
                                    matchedOpeningTags.add(processedTD);
                                    if (this.isUnformattableTag(tagName)) {
                                        for (int i = lastTagLine - 1; i > processedTD.getLine(); --i) {
                                            unformattableLines[i] = true;
                                        }
                                    }
                                    tagsToBeRemoved.clear();
                                    break;
                                }
                                tagsToBeRemoved.add(processedTD);
                            }
                            unprocessedOpeningTags.addAll(tagsToBeRemoved);
                        }
                    }
                    if ((wasPreviousTokenUnformattable = this.isUnformattableToken(tokenHierarchy, tokenSequence.offset())) && firstUnformattableLine == -1) {
                        firstUnformattableLine = Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset());
                    }
                    if (firstUnformattableLine <= -1 || wasPreviousTokenUnformattable && (thereAreMoreTokens &= tokenSequence.moveNext())) continue;
                    int lastUnformattableLine = thereAreMoreTokens ? Utilities.getLineOffset((BaseDocument)doc, (int)(tokenSequence.offset() - 1)) : lastLine;
                    for (int i = firstUnformattableLine + 1; i < lastUnformattableLine; ++i) {
                        unformattableLines[i] = true;
                    }
                    firstUnformattableLine = -1;
                } while (thereAreMoreTokens);
            }
            int[] indentLevels = new int[lastLine + 1];
            Arrays.fill(indentLevels, 0);
            for (TagIndentationData td : matchedOpeningTags) {
                int i = td.getLine() + 1;
                while (i <= td.getClosedOnLine() - 1) {
                    int n = i++;
                    indentLevels[n] = indentLevels[n] + 1;
                }
            }
            InitialIndentData initialIndentData = new InitialIndentData(doc, indentLevels, indentsWithinTags, firstRefBlockLine, lastRefBlockLine);
            for (int line = firstRefBlockLine; line <= lastRefBlockLine; ++line) {
                int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
                if (unformattableLines[line] || !initialIndentData.isEligibleToIndent(line)) continue;
                this.changeRowIndent(doc, lineStart, initialIndentData.getIndent(line));
            }
        }
        finally {
            doc.atomicUnlock();
        }
        return null;
    }

    protected void enterPressed(JTextComponent txtComponent, int dotPos) throws BadLocationException {
        BaseDocument doc = Utilities.getDocument((JTextComponent)txtComponent);
        int lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)dotPos);
        int initialIndent = this.getInitialIndentFromPreviousLine(doc, lineNumber);
        int endOfPreviousLine = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)dotPos);
        endOfPreviousLine = endOfPreviousLine == -1 ? 0 : endOfPreviousLine;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        if (lineNumber == Utilities.getLineOffset((BaseDocument)doc, (int)endOfPreviousLine)) {
            return;
        }
        int openingTagOffset = this.getTagEndingAtPosition(tokenHierarchy, endOfPreviousLine);
        if (this.isOpeningTag(tokenHierarchy, openingTagOffset)) {
            int closingTagOffset = this.getNextClosingTagOffset(tokenHierarchy, dotPos + 1);
            if (closingTagOffset != -1) {
                int matchingOpeningTagOffset = this.getMatchingOpeningTagStart(tokenHierarchy, closingTagOffset);
                if (openingTagOffset == matchingOpeningTagOffset) {
                    int openingTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)openingTagOffset);
                    int closingTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)closingTagOffset);
                    if (closingTagLine == Utilities.getLineOffset((BaseDocument)doc, (int)dotPos)) {
                        if (openingTagLine == closingTagLine - 1) {
                            Position closingTagPos = doc.createPosition(this.getOpeningSymbolOffset(tokenHierarchy, closingTagOffset));
                            this.changeRowIndent(doc, dotPos, initialIndent + this.getShiftWidth());
                            doc.insertString(closingTagPos.getOffset(), "\n", null);
                            int newCaretPos = closingTagPos.getOffset() - 1;
                            this.changeRowIndent(doc, closingTagPos.getOffset() + 1, initialIndent);
                            newCaretPos = Utilities.getRowEnd((BaseDocument)doc, (int)newCaretPos);
                            txtComponent.setCaretPosition(newCaretPos);
                        } else {
                            this.changeRowIndent(doc, dotPos, initialIndent);
                        }
                    }
                }
                int indent = initialIndent;
                if (this.isClosingTagRequired(doc, this.extractTagName(tokenHierarchy, openingTagOffset))) {
                    indent += this.getShiftWidth();
                }
                this.changeRowIndent(doc, dotPos, indent);
            }
        } else {
            int indent = initialIndent;
            if (this.isJustBeforeClosingTag(tokenHierarchy, dotPos)) {
                indent = (indent -= this.getShiftWidth()) < 0 ? 0 : indent;
            }
            this.changeRowIndent(doc, dotPos, indent);
        }
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)target.getDocument());
        if (tokenHierarchy == null) {
            logger.severe("Could not retrieve TokenHierarchy for document " + target.getDocument());
            return null;
        }
        char lastChar = typedText.charAt(typedText.length() - 1);
        try {
            int dotPos = target.getCaret().getDot();
            if (lastChar == '>') {
                int closingTagSymbolLine;
                BaseDocument doc;
                int openingTagLine;
                int openingTagOffset;
                int precedingTokenOffset = this.getTagEndingAtPosition(tokenHierarchy, dotPos - 1);
                if (this.isClosingTag(tokenHierarchy, precedingTokenOffset) && (openingTagOffset = this.getMatchingOpeningTagStart(tokenHierarchy, precedingTokenOffset)) != -1 && (openingTagLine = Utilities.getLineOffset((BaseDocument)(doc = Utilities.getDocument((JTextComponent)target)), (int)openingTagOffset)) != (closingTagSymbolLine = Utilities.getLineOffset((BaseDocument)doc, (int)dotPos))) {
                    return new int[]{precedingTokenOffset, dotPos};
                }
            } else if (lastChar == '\n') {
                this.enterPressed(target, dotPos);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception during code formatting", e);
        }
        return null;
    }

    protected int getMatchingOpeningTagStart(TokenHierarchy tokenHierarchy, int closingTagOffset) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(closingTagOffset);
        String searchedTagName = this.extractTagName(tokenHierarchy, closingTagOffset);
        int balance = 0;
        while (tokenSequence.movePrevious()) {
            int currentTokenOffset = tokenSequence.offset();
            if (!this.areTagNamesEqual(searchedTagName, this.extractTagName(tokenHierarchy, currentTokenOffset))) continue;
            if (this.isOpeningTag(tokenHierarchy, currentTokenOffset)) {
                if (balance == 0) {
                    return currentTokenOffset;
                }
                --balance;
                continue;
            }
            if (!this.isClosingTag(tokenHierarchy, currentTokenOffset)) continue;
            ++balance;
        }
        return -1;
    }

    protected int getInitialIndentFromPreviousLine(BaseDocument doc, int line) throws BadLocationException {
        int lineStart;
        int previousNonWhiteLineEnd;
        int initialIndent = 0;
        if (line > 0 && (previousNonWhiteLineEnd = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)(lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line)))) > 0) {
            initialIndent = Utilities.getRowIndent((BaseDocument)doc, (int)previousNonWhiteLineEnd);
        }
        return initialIndent;
    }

    private int getInitialIndentFromNextLine(BaseDocument doc, int line) throws BadLocationException {
        int initialIndent = 0;
        int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
        int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)lineStart);
        int nextNonWhiteLineStart = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)lineEnd);
        if (nextNonWhiteLineStart > 0) {
            initialIndent = Utilities.getRowIndent((BaseDocument)doc, (int)nextNonWhiteLineStart, (boolean)true);
        }
        return initialIndent;
    }

    protected static int getNumberOfLines(BaseDocument doc) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)doc, (int)(doc.getLength() - 1)) + 1;
    }

    protected int getNextClosingTagOffset(TokenHierarchy tokenHierarchy, int offset) throws BadLocationException {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(offset);
        while (tokenSequence.moveNext()) {
            int currentOffset = tokenSequence.offset();
            if (!this.isClosingTag(tokenHierarchy, currentOffset)) continue;
            return currentOffset;
        }
        return -1;
    }

    protected boolean isJustBeforeClosingTag(TokenHierarchy tokenHierarchy, int pos) throws BadLocationException {
        return this.isClosingTag(tokenHierarchy, pos);
    }

    protected Token getTokenAtOffset(TokenHierarchy tokenHierarchy, int tagTokenOffset) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence != null) {
            tokenSequence.move(tagTokenOffset);
            if (tokenSequence.moveNext()) {
                return tokenSequence.token();
            }
        }
        return null;
    }

    protected class InitialIndentData {
        private final int indentLevelBias;
        private final int indentBias;
        private final int[] indentLevels;
        private final int[] indentsWithinTags;

        public InitialIndentData(BaseDocument doc, int[] indentLevels, int[] indentsWithinTags, int firstRefBlockLine, int lastRefBlockLine) throws BadLocationException {
            int initialIndent = TagBasedLexerFormatter.this.getInitialIndentFromPreviousLine(doc, firstRefBlockLine);
            int indentLevelBiasFromTheTop = initialIndent / TagBasedLexerFormatter.this.getShiftWidth() - (firstRefBlockLine > 0 ? indentLevels[firstRefBlockLine - 1] : 0);
            int initialIndentFromTheBottom = TagBasedLexerFormatter.this.getInitialIndentFromNextLine(doc, lastRefBlockLine);
            int indentLevelBiasFromTheBottom = initialIndentFromTheBottom / TagBasedLexerFormatter.this.getShiftWidth() - (lastRefBlockLine < TagBasedLexerFormatter.getNumberOfLines(doc) - 1 ? indentLevels[lastRefBlockLine + 1] : 0);
            if (indentLevelBiasFromTheBottom > indentLevelBiasFromTheTop) {
                this.indentLevelBias = indentLevelBiasFromTheBottom;
                initialIndent = initialIndentFromTheBottom;
            } else {
                this.indentLevelBias = indentLevelBiasFromTheTop;
            }
            this.indentBias = initialIndent % TagBasedLexerFormatter.this.getShiftWidth();
            this.indentLevels = indentLevels;
            this.indentsWithinTags = indentsWithinTags;
        }

        public boolean isEligibleToIndent(int line) {
            return this.getActualIndentLevel(line) >= 0;
        }

        public int getIndent(int line) {
            return this.indentBias + this.indentsWithinTags[line] + this.getActualIndentLevel(line) * TagBasedLexerFormatter.this.getShiftWidth();
        }

        private int getActualIndentLevel(int line) {
            return this.indentLevels[line] + this.indentLevelBias;
        }
    }

    protected static class TagIndentationData {
        private final String tagName;
        private final int line;
        private int closedOnLine;

        public TagIndentationData(String tagName, int line) {
            this.tagName = tagName;
            this.line = line;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getLine() {
            return this.line;
        }

        public int getClosedOnLine() {
            return this.closedOnLine;
        }

        public void setClosedOnLine(int closedOnLine) {
            this.closedOnLine = closedOnLine;
        }
    }
}

