/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Image;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ElementNode
extends AbstractNode {
    private static Node WAIT_NODE;
    private OpenAction openAction;
    private Description description;

    public ElementNode(Description description) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, description.ui.getFilters())));
        this.description = description;
        this.setDisplayName(description.name);
    }

    public Image getIcon(int type) {
        return this.description.kind == null ? super.getIcon(type) : Utilities.icon2Image((Icon)UiUtils.getElementIcon((ElementKind)this.description.kind, this.description.modifiers));
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        return this.description.name;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean context) {
        if (context || this.description.name == null) {
            return this.description.ui.getActions();
        }
        Action[] panelActions = this.description.ui.getActions();
        Action[] actions = new Action[2 + panelActions.length];
        actions[0] = this.getOpenAction();
        actions[1] = null;
        for (int i = 0; i < panelActions.length; ++i) {
            actions[2 + i] = panelActions[i];
        }
        return actions;
    }

    public Action getPreferredAction() {
        return this.getOpenAction();
    }

    private synchronized Action getOpenAction() {
        if (this.openAction == null) {
            FileObject fo = this.description.ui.getFileObject();
            this.openAction = new OpenAction(this.description.elementHandle, fo);
        }
        return this.openAction;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            ((ElementChilren)ch).resetKeys(this.description.subs, this.description.ui.getFilters());
            for (Node sub : ch.getNodes()) {
                this.description.ui.expandNode(sub);
                ((ElementNode)sub).refreshRecursively();
            }
        }
    }

    public void updateRecursively(Description newDescription) {
        Children ch = this.getChildren();
        if (ch instanceof ElementChilren) {
            HashSet<Description> oldSubs = new HashSet<Description>(this.description.subs);
            Node[] nodes = ch.getNodes(true);
            HashMap<Description, ElementNode> oldD2node = new HashMap<Description, ElementNode>();
            for (Node node : nodes) {
                oldD2node.put(((ElementNode)node).description, (ElementNode)node);
            }
            ((ElementChilren)ch).resetKeys(newDescription.subs, newDescription.ui.getFilters());
            nodes = ch.getNodes(true);
            for (Description newSub : newDescription.subs) {
                ElementNode node = (ElementNode)((Object)oldD2node.get(newSub));
                if (node == null) continue;
                if (!oldSubs.contains(newSub) && node.getChildren() != Children.LEAF) {
                    this.description.ui.expandNode((Node)node);
                }
                node.updateRecursively(newSub);
            }
        }
        Description oldDescription = this.description;
        this.description = newDescription;
        if (oldDescription.htmlHeader != null && !oldDescription.htmlHeader.equals(this.description.htmlHeader)) {
            this.fireDisplayNameChange(oldDescription.htmlHeader, this.description.htmlHeader);
        }
        if (oldDescription.modifiers != null && !((Object)oldDescription.modifiers).equals(newDescription.modifiers)) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public Description getDescritption() {
        return this.description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<Description> POSITION_COMPARATOR = new DescriptionComparator(false);
        ClassMemberPanelUI ui;
        FileObject fileObject;
        final String name;
        final ElementHandle<? extends Element> elementHandle;
        final ElementKind kind;
        Set<Modifier> modifiers;
        List<Description> subs;
        String htmlHeader;
        long pos;

        Description(ClassMemberPanelUI ui) {
            this.ui = ui;
            this.name = null;
            this.elementHandle = null;
            this.kind = null;
        }

        Description(ClassMemberPanelUI ui, String name, ElementHandle<? extends Element> elementHandle, ElementKind kind) {
            this.ui = ui;
            this.name = name;
            this.elementHandle = elementHandle;
            this.kind = kind;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description d = (Description)o;
            if (this.kind != d.kind) {
                return false;
            }
            if (!this.name.equals(d.name)) {
                return false;
            }
            return this.elementHandle.signatureEquals(d.elementHandle);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 29 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DescriptionComparator
        implements Comparator<Description> {
            boolean alpha;

            DescriptionComparator(boolean alpha) {
                this.alpha = alpha;
            }

            @Override
            public int compare(Description d1, Description d2) {
                if (this.alpha) {
                    if (this.k2i(d1.kind) != this.k2i(d2.kind)) {
                        return this.k2i(d1.kind) - this.k2i(d2.kind);
                    }
                    return d1.name.compareTo(d2.name);
                }
                return d1.pos == d2.pos ? 0 : (d1.pos < d2.pos ? -1 : 1);
            }

            int k2i(ElementKind kind) {
                switch (kind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        return 4;
                    }
                }
                return 100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> descriptions, ClassMemberFilters filters) {
            this.resetKeys(descriptions, filters);
        }

        protected Node[] createNodes(Description key) {
            return new Node[]{new ElementNode(key)};
        }

        void resetKeys(List<Description> descriptions, ClassMemberFilters filters) {
            this.setKeys(filters.filter(descriptions));
        }
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ElementNode.class, (String)"LBL_WaitNode");
        }
    }
}

