/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private ClassMemberPanelUI ui;
    private FindChildrenElementVisitor scanner;
    private volatile boolean canceled;

    public ElementScanningTask(ClassMemberPanelUI ui) {
        this.ui = ui;
    }

    public void cancel() {
        this.canceled = true;
        if (this.scanner != null) {
            this.scanner.cancel();
        }
    }

    public void run(CompilationInfo info) throws Exception {
        this.canceled = false;
        ElementNode.Description rootDescription = new ElementNode.Description(this.ui);
        rootDescription.fileObject = info.getFileObject();
        rootDescription.subs = new ArrayList<ElementNode.Description>();
        CompilationUnitTree cuTree = info.getCompilationUnit();
        List<? extends Tree> typeDecls = cuTree.getTypeDecls();
        ArrayList<Element> elements = new ArrayList<Element>(typeDecls.size());
        TreePath cuPath = new TreePath(cuTree);
        for (Tree tree : typeDecls) {
            TreePath p = new TreePath(cuPath, tree);
            Element e = info.getTrees().getElement(p);
            if (e == null) continue;
            elements.add(e);
        }
        if (!this.canceled) {
            this.scanner = new FindChildrenElementVisitor(info);
            for (Element element : elements) {
                this.scanner.scan(element, rootDescription);
            }
        }
        if (!this.canceled) {
            this.ui.refresh(rootDescription);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindChildrenElementVisitor
    extends ElementScanner6<Void, ElementNode.Description> {
        private CompilationInfo info;
        private volatile boolean canceled = false;

        public FindChildrenElementVisitor(CompilationInfo info) {
            this.info = info;
        }

        void cancel() {
            this.canceled = true;
        }

        @Override
        public Void visitPackage(PackageElement e, ElementNode.Description p) {
            return null;
        }

        @Override
        public Void visitType(TypeElement e, ElementNode.Description p) {
            if (!this.canceled && !this.info.getElementUtilities().isSynthetic((Element)e)) {
                ElementNode.Description d = new ElementNode.Description(p.ui, e.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), e.getKind());
                d.modifiers = e.getModifiers();
                d.subs = new ArrayList<ElementNode.Description>();
                d.pos = this.getPosition(e);
                d.htmlHeader = this.createHtmlHeader(e, this.info.getElements().isDeprecated(e));
                if (d.pos == -1L) {
                    return null;
                }
                super.visitType(e, d);
                p.subs.add(d);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, ElementNode.Description p) {
            if (!(this.canceled || this.info.getElementUtilities().isSynthetic((Element)e) || e.getKind() != ElementKind.FIELD && e.getKind() != ElementKind.ENUM_CONSTANT)) {
                ElementNode.Description d = new ElementNode.Description(p.ui, e.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), e.getKind());
                d.modifiers = e.getModifiers();
                d.pos = this.getPosition(e);
                d.htmlHeader = this.createHtmlHeader(e, this.info.getElements().isDeprecated(e));
                if (d.pos == -1L) {
                    return null;
                }
                super.visitVariable(e, d);
                p.subs.add(d);
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, ElementNode.Description p) {
            if (!this.canceled && !this.info.getElementUtilities().isSynthetic((Element)e)) {
                ElementNode.Description d = new ElementNode.Description(p.ui, e.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), e.getKind());
                d.modifiers = e.getModifiers();
                d.pos = this.getPosition(e);
                if (d.pos == -1L) {
                    return null;
                }
                d.htmlHeader = this.createHtmlHeader(e, this.info.getElements().isDeprecated(e));
                super.visitExecutable(e, d);
                p.subs.add(d);
            }
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, ElementNode.Description p) {
            return null;
        }

        private long getPosition(Element e) {
            Trees trees = this.info.getTrees();
            CompilationUnitTree cut = this.info.getCompilationUnit();
            Tree t = trees.getTree(e);
            if (t == null) {
                return -1L;
            }
            SourcePositions sourcePositions = trees.getSourcePositions();
            return sourcePositions.getStartPosition(cut, t);
        }

        private String createHtmlHeader(ExecutableElement e, boolean isDeprecated) {
            TypeMirror rt;
            StringBuilder sb = new StringBuilder();
            if (isDeprecated) {
                sb.append("<s>");
            }
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                sb.append(e.getEnclosingElement().getSimpleName());
            } else {
                sb.append(e.getSimpleName());
            }
            if (isDeprecated) {
                sb.append("</s>");
            }
            sb.append("(");
            List<? extends VariableElement> params = e.getParameters();
            Iterator<? extends VariableElement> it = params.iterator();
            while (it.hasNext()) {
                VariableElement param = it.next();
                sb.append(this.print(param.asType()));
                sb.append(" ");
                sb.append(param.getSimpleName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
                sb.append(" : ");
                sb.append(this.print(e.getReturnType()));
            }
            return sb.toString();
        }

        private String createHtmlHeader(VariableElement e, boolean isDeprecated) {
            StringBuilder sb = new StringBuilder();
            if (isDeprecated) {
                sb.append("<s>");
            }
            sb.append(e.getSimpleName());
            if (isDeprecated) {
                sb.append("</s>");
            }
            if (e.getKind() != ElementKind.ENUM_CONSTANT) {
                sb.append(" : ");
                sb.append(this.print(e.asType()));
            }
            return sb.toString();
        }

        private String createHtmlHeader(TypeElement e, boolean isDeprecated) {
            List<? extends TypeParameterElement> typeParams;
            StringBuilder sb = new StringBuilder();
            if (isDeprecated) {
                sb.append("<s>");
            }
            sb.append(e.getSimpleName());
            if (isDeprecated) {
                sb.append("</s>");
            }
            if ((typeParams = e.getTypeParameters()) != null && !typeParams.isEmpty()) {
                sb.append("&lt;");
                Iterator<? extends TypeParameterElement> it = typeParams.iterator();
                while (it.hasNext()) {
                    TypeParameterElement tp = it.next();
                    sb.append(tp.getSimpleName());
                    try {
                        List<? extends TypeMirror> bounds = tp.getBounds();
                        if (!bounds.isEmpty()) {
                            sb.append(this.printBounds(bounds));
                        }
                    }
                    catch (NullPointerException npe) {
                        System.err.println("El " + e);
                        npe.printStackTrace();
                    }
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append("&gt;");
            }
            return sb.toString();
        }

        private String printBounds(List<? extends TypeMirror> bounds) {
            if (bounds.size() == 1 && "java.lang.Object".equals(((Object)bounds.get(0)).toString())) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" extends ");
            Iterator<? extends TypeMirror> it = bounds.iterator();
            while (it.hasNext()) {
                TypeMirror bound = it.next();
                sb.append(this.print(bound));
                if (!it.hasNext()) continue;
                sb.append(" & ");
            }
            return sb.toString();
        }

        private String print(TypeMirror tm) {
            switch (tm.getKind()) {
                case DECLARED: {
                    DeclaredType dt = (DeclaredType)tm;
                    StringBuilder sb = new StringBuilder(dt.asElement().getSimpleName().toString());
                    List<? extends TypeMirror> typeArgs = dt.getTypeArguments();
                    if (!typeArgs.isEmpty()) {
                        sb.append("&lt;");
                        Iterator<? extends TypeMirror> it = typeArgs.iterator();
                        while (it.hasNext()) {
                            TypeMirror ta = it.next();
                            sb.append(this.print(ta));
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                        sb.append("&gt;");
                    }
                    return sb.toString();
                }
                case TYPEVAR: {
                    TypeVariable tv = (TypeVariable)tm;
                    StringBuilder sb = new StringBuilder(tv.asElement().getSimpleName().toString());
                    return sb.toString();
                }
                case ARRAY: {
                    ArrayType at = (ArrayType)tm;
                    StringBuilder sb = new StringBuilder(this.print(at.getComponentType()));
                    sb.append("[]");
                    return sb.toString();
                }
                case WILDCARD: {
                    WildcardType wt = (WildcardType)tm;
                    StringBuilder sb = new StringBuilder("?");
                    if (wt.getExtendsBound() != null) {
                        sb.append(" extends ");
                        sb.append(this.print(wt.getExtendsBound()));
                    }
                    if (wt.getSuperBound() != null) {
                        sb.append(" super ");
                        sb.append(this.print(wt.getSuperBound()));
                    }
                    return sb.toString();
                }
            }
            return ((Object)tm).toString();
        }
    }
}

