/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.javadoc.Doc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaHierarchyModel
extends DefaultTreeModel {
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private String pattern = "";
    private String patternLowerCase = "";
    private FileObject fileObject;
    private ElementHandle[] elementHandles;

    public JavaHierarchyModel(FileObject fileObject, Element[] elements, CompilationInfo compilationInfo) {
        super(null);
        this.fileObject = fileObject;
        if (elements == null || elements.length == 0) {
            this.elementHandles = EMPTY_ELEMENTHANDLES_ARRAY;
        } else {
            ArrayList<ElementHandle> elementHandlesList = new ArrayList<ElementHandle>(elements.length);
            for (Element element : elements) {
                elementHandlesList.add(ElementHandle.create((Element)element));
            }
            this.elementHandles = elementHandlesList.toArray(EMPTY_ELEMENTHANDLES_ARRAY);
        }
        this.update(elements, compilationInfo);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.patternLowerCase = pattern == null ? null : pattern.toLowerCase();
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandles) {
        if (elementHandles == null && elementHandles.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> elementsList = new ArrayList<Element>(elementHandles.length);
                        for (ElementHandle elementHandle : elementHandles) {
                            elementsList.add(elementHandle.resolve((CompilationInfo)compilationController));
                        }
                        Element[] elements = elementsList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaHierarchyModel.this.update(elements, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    private void update(Element[] elements, CompilationInfo compilationInfo) {
        if (elements == null && elements.length == 0) {
            return;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Element element : elements) {
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM && element.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            if (JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                root.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo));
                continue;
            }
            Types types = compilationInfo.getTypes();
            TypeElement typeElement = (TypeElement)element;
            ArrayList<TypeElement> superClasses = new ArrayList<TypeElement>();
            superClasses.add(typeElement);
            TypeElement superClass = (TypeElement)types.asElement(typeElement.getSuperclass());
            while (superClass != null) {
                superClasses.add(0, superClass);
                superClass = (TypeElement)types.asElement(superClass.getSuperclass());
            }
            DefaultMutableTreeNode parent = root;
            for (TypeElement superTypeElement : superClasses) {
                FileObject fileObject = SourceUtils.getFile((Element)superTypeElement, (ClasspathInfo)compilationInfo.getClasspathInfo());
                SimpleTypeTreeNode child = new SimpleTypeTreeNode(fileObject, superTypeElement, compilationInfo, typeElement != superTypeElement || ((Object)typeElement.getQualifiedName()).equals(Object.class.getName()));
                parent.insert(child, 0);
                parent = child;
            }
            JavaMembersAndHierarchyOptions.setSubTypeHierarchyDepth(superClasses.size() + 2);
        }
        this.setRoot(root);
    }

    public boolean patternMatch(JavaElement javaToolsJavaElement) {
        return Utils.patternMatch(javaToolsJavaElement, this.pattern, this.patternLowerCase);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractHierarchyTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String tooltip = null;
        private Icon icon = null;
        private String javaDoc = "";
        private boolean loaded = false;

        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo) {
            this(fileObject, element, compilationInfo, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, boolean lazyLoadChildren) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            this.setName(element.getSimpleName().toString());
            this.setIcon(UiUtils.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setToolTip(Utils.format(element, true));
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            if (doc != null) {
                String javadocText;
                StringBuilder stringBuilder = new StringBuilder();
                List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
                if (annotationMirrors != null && annotationMirrors.size() > 0) {
                    stringBuilder.append("<b>" + NbBundle.getMessage(JavaHierarchyModel.class, (String)"LBL_Annotations") + "</b>");
                    stringBuilder.append("<br>");
                    for (AnnotationMirror annotationMirror : annotationMirrors) {
                        stringBuilder.append(annotationMirror.toString());
                        stringBuilder.append("<br>");
                    }
                    stringBuilder.append("<hr>");
                }
                if ((javadocText = doc.getRawCommentText()) != null && javadocText.length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("<b>" + NbBundle.getMessage(JavaHierarchyModel.class, (String)"LBL_Javadoc") + "</b>");
                        stringBuilder.append("<br>");
                    }
                    stringBuilder.append(Utils.formatJavaDoc(javadocText));
                }
                this.setJavaDoc(stringBuilder.toString());
            }
            if (!lazyLoadChildren) {
                try {
                    this.loadChildren(element, compilationInfo);
                }
                finally {
                    this.loaded = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getChildCount() {
            if (!this.loaded) {
                try {
                    this.loadChildren();
                }
                finally {
                    this.loaded = true;
                }
            }
            return super.getChildCount();
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public String getJavaDoc() {
            return this.javaDoc;
        }

        public void setJavaDoc(String javaDoc) {
            this.javaDoc = javaDoc;
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected void loadChildren() {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = AbstractHierarchyTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                            if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().toString().equals(Object.class.getName())) {
                                AbstractHierarchyTreeNode.this.loadChildren(element, (CompilationInfo)compilationController);
                            }
                        }
                    }, true);
                    return;
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return this.getLabel();
        }

        protected void openElementHandle() {
            if (this.elementHandle == null) {
                return;
            }
            UiUtils.open((FileObject)this.fileObject, this.elementHandle);
        }
    }

    private class SimpleTypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean inSuperClassRole) {
            super(fileObject, typeElement, compilationInfo, inSuperClassRole);
            this.inSuperClassRole = inSuperClassRole;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            if (this.inSuperClassRole) {
                return;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.getQualifiedName().toString().equals(Object.class.getName())) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_WontShowSubTypesOfObject", (Object)Object.class.getName()));
                return;
            }
            Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
            if (openProjects == null) {
                return;
            }
            LinkedHashSet<ElementHandle> processedImplementorElementHandles = new LinkedHashSet<ElementHandle>();
            ElementHandle typeElementHandle = ElementHandle.create((Element)typeElement);
            final int[] index = new int[]{0};
            for (Project project : openProjects) {
                Collection sourcess = project.getLookup().lookupAll(Sources.class);
                if (sourcess == null) continue;
                for (Sources sources : sourcess) {
                    SourceGroup[] sourceGroups = sources.getSourceGroups("java");
                    if (sourceGroups == null) continue;
                    for (SourceGroup sourceGroup : sourceGroups) {
                        ClassIndex classIndex;
                        ClasspathInfo classpathInfo;
                        ClassPath classPath;
                        FileObject rootFileObject = sourceGroup.getRootFolder();
                        if (rootFileObject == null || (classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{rootFileObject})) == null || (classpathInfo = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)classPath)) == null || (classIndex = classpathInfo.getClassIndex()) == null) continue;
                        Set implementors = classIndex.getElements(typeElementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
                        for (ElementHandle implementorElementHandle : implementors) {
                            JavaSource javaSource;
                            if (processedImplementorElementHandles.contains(implementorElementHandle)) continue;
                            processedImplementorElementHandles.add(implementorElementHandle);
                            final ElementHandle finalImplementorElementHandle = implementorElementHandle;
                            FileObject implementorfileObject = SourceUtils.getFile((ElementHandle)implementorElementHandle, (ClasspathInfo)classpathInfo);
                            if (implementorfileObject == null || (javaSource = JavaSource.forFileObject((FileObject)implementorfileObject)) == null) continue;
                            try {
                                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                                    public void cancel() {
                                    }

                                    public void run(CompilationController compilationController) throws Exception {
                                        FileObject fo;
                                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                        Element implementor = finalImplementorElementHandle.resolve((CompilationInfo)compilationController);
                                        if (implementor instanceof TypeElement && ((TypeElement)implementor).getNestingKind() != NestingKind.ANONYMOUS && (fo = SourceUtils.getFile((Element)implementor, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                            int n = index[0];
                                            index[0] = n + 1;
                                            SimpleTypeTreeNode.this.insert(new SimpleTypeTreeNode(fo, (TypeElement)implementor, (CompilationInfo)compilationController), n);
                                        }
                                    }
                                }, true);
                            }
                            catch (IOException ioe) {
                                ErrorManager.getDefault().notify((Throwable)ioe);
                            }
                        }
                    }
                }
            }
        }
    }

    private class TypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean inSuperClassRole) {
            super(fileObject, typeElement, compilationInfo);
            this.inSuperClassRole = inSuperClassRole;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int index) {
            TypeElement typeElement;
            Types types = compilationInfo.getTypes();
            TypeElement superClass = (TypeElement)types.asElement((typeElement = (TypeElement)element).getSuperclass());
            if (superClass != null && !superClass.getQualifiedName().toString().equals(Object.class.getName())) {
                FileObject fileObject = SourceUtils.getFile((Element)superClass, (ClasspathInfo)compilationInfo.getClasspathInfo());
                this.insert(new TypeTreeNode(fileObject, superClass, compilationInfo, true), index++);
            }
            List<? extends TypeMirror> interfaces = typeElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                TypeElement interfaceElement = (TypeElement)types.asElement(typeMirror);
                if (interfaceElement == null) continue;
                FileObject fileObject = SourceUtils.getFile((Element)interfaceElement, (ClasspathInfo)compilationInfo.getClasspathInfo());
                this.insert(new TypeTreeNode(fileObject, interfaceElement, compilationInfo, true), index++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole) {
                for (Element element2 : typeElement.getEnclosedElements()) {
                    TypeTreeNode node = null;
                    if (element2.getKind() != ElementKind.CLASS && element2.getKind() != ElementKind.INTERFACE && element2.getKind() != ElementKind.ENUM && element2.getKind() != ElementKind.ANNOTATION_TYPE) continue;
                    node = new TypeTreeNode(JavaHierarchyModel.this.fileObject, (TypeElement)element2, compilationInfo, true);
                    this.insert(node, index++);
                }
            }
            return index;
        }
    }
}

