/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.javadoc.Doc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaMembersModel
extends DefaultTreeModel {
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private String pattern = "";
    private String patternLowerCase = "";
    private FileObject fileObject;
    private ElementHandle[] elementHandles;

    public JavaMembersModel(FileObject fileObject, Element[] elements, CompilationInfo compilationInfo) {
        super(null);
        this.fileObject = fileObject;
        if (elements == null || elements.length == 0) {
            this.elementHandles = EMPTY_ELEMENTHANDLES_ARRAY;
        } else {
            ArrayList<ElementHandle> elementHandlesList = new ArrayList<ElementHandle>(elements.length);
            for (Element element : elements) {
                elementHandlesList.add(ElementHandle.create((Element)element));
            }
            this.elementHandles = elementHandlesList.toArray(EMPTY_ELEMENTHANDLES_ARRAY);
        }
        this.update(elements, compilationInfo);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.patternLowerCase = pattern == null ? null : pattern.toLowerCase();
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandles) {
        if (elementHandles == null && elementHandles.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> elementsList = new ArrayList<Element>(elementHandles.length);
                        for (ElementHandle elementHandle : elementHandles) {
                            elementsList.add(elementHandle.resolve((CompilationInfo)compilationController));
                        }
                        Element[] elements = elementsList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaMembersModel.this.update(elements, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    private void update(Element[] elements, CompilationInfo compilationInfo) {
        if (elements == null && elements.length == 0) {
            return;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Element element : elements) {
            if (element.getKind() == ElementKind.PACKAGE) {
                root.add(new PackageTreeNode(this.fileObject, (PackageElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.ANNOTATION_TYPE) {
                root.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                root.add(new ConstructorTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.METHOD) {
                root.add(new MethodTreeNode(this.fileObject, (ExecutableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() == ElementKind.FIELD) {
                root.add(new FieldTreeNode(this.fileObject, (VariableElement)element, compilationInfo));
                continue;
            }
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            root.add(new EnumConstantTreeNode(this.fileObject, (VariableElement)element, compilationInfo));
        }
        this.setRoot(root);
    }

    boolean patternMatch(JavaElement javaToolsJavaElement) {
        return Utils.patternMatch(javaToolsJavaElement, this.pattern, this.patternLowerCase);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractMembersTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String tooltip = null;
        private Icon icon = null;
        private String javaDoc = "";

        AbstractMembersTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                this.setName(element.getEnclosingElement().getSimpleName().toString());
            } else {
                this.setName(element.getSimpleName().toString());
            }
            this.setIcon(UiUtils.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setToolTip(Utils.format(element, true));
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            if (doc != null) {
                String javadocText;
                StringBuilder stringBuilder = new StringBuilder();
                List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
                if (annotationMirrors != null && annotationMirrors.size() > 0) {
                    stringBuilder.append("<b>" + NbBundle.getMessage(JavaMembersModel.class, (String)"LBL_Annotations") + "</b>");
                    stringBuilder.append("<br>");
                    for (AnnotationMirror annotationMirror : annotationMirrors) {
                        stringBuilder.append(annotationMirror.toString());
                        stringBuilder.append("<br>");
                    }
                    stringBuilder.append("<hr>");
                }
                if ((javadocText = doc.getRawCommentText()) != null && javadocText.length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("<b>" + NbBundle.getMessage(JavaMembersModel.class, (String)"LBL_Javadoc") + "</b>");
                        stringBuilder.append("<br>");
                    }
                    stringBuilder.append(Utils.formatJavaDoc(javadocText));
                }
                this.setJavaDoc(stringBuilder.toString());
            }
            this.loadChildren(element, compilationInfo);
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public String getJavaDoc() {
            return this.javaDoc;
        }

        public void setJavaDoc(String javaDoc) {
            this.javaDoc = javaDoc;
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return this.getLabel();
        }

        protected void openElementHandle() {
            if (this.fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaMembersModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getLabel()));
                return;
            }
            if (this.elementHandle == null) {
                return;
            }
            UiUtils.open((FileObject)this.fileObject, this.elementHandle);
        }
    }

    private class ConstructorTreeNode
    extends AbstractMembersTreeNode {
        ConstructorTreeNode(FileObject fileObject, ExecutableElement contructorElement, CompilationInfo compilationInfo) {
            super(fileObject, contructorElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class EnumConstantTreeNode
    extends AbstractMembersTreeNode {
        EnumConstantTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo) {
            super(fileObject, variableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class FieldTreeNode
    extends AbstractMembersTreeNode {
        FieldTreeNode(FileObject fileObject, VariableElement variableElement, CompilationInfo compilationInfo) {
            super(fileObject, variableElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class MethodTreeNode
    extends AbstractMembersTreeNode {
        MethodTreeNode(FileObject fileObject, ExecutableElement methodElement, CompilationInfo compilationInfo) {
            super(fileObject, methodElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class PackageTreeNode
    extends AbstractMembersTreeNode {
        PackageTreeNode(FileObject fileObject, PackageElement packageElement, CompilationInfo compilationInfo) {
            super(fileObject, packageElement, compilationInfo);
        }

        public boolean isLeaf() {
            return true;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
        }
    }

    private class TypeTreeNode
    extends AbstractMembersTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo) {
            this(fileObject, typeElement, compilationInfo, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, boolean inSuperClassRole) {
            super(fileObject, typeElement, compilationInfo);
            this.inSuperClassRole = inSuperClassRole;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int index) {
            AbstractMembersTreeNode node;
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
            for (Element element2 : enclosedElements) {
                node = null;
                if (element2.getKind() == ElementKind.CLASS || element2.getKind() == ElementKind.INTERFACE || element2.getKind() == ElementKind.ENUM) {
                    if (!JavaMembersAndHierarchyOptions.isShowInner() || JavaMembersAndHierarchyOptions.isShowInherited()) continue;
                    node = new TypeTreeNode(this.getFileObject(), (TypeElement)element2, compilationInfo);
                } else {
                    Set<Modifier> set = element2.getModifiers();
                    if (element2.getKind() == ElementKind.CONSTRUCTOR) {
                        if (!JavaMembersAndHierarchyOptions.isShowConstructors()) continue;
                        ExecutableElement constructor = (ExecutableElement)element2;
                        if (!set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.PROTECTED) && !set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate()) continue;
                        node = new ConstructorTreeNode(this.getFileObject(), constructor, compilationInfo);
                    } else if (element2.getKind() == ElementKind.METHOD) {
                        if (!JavaMembersAndHierarchyOptions.isShowMethods()) continue;
                        ExecutableElement method = (ExecutableElement)element2;
                        if (!set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.PROTECTED) && !set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate() || set.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) continue;
                        node = new MethodTreeNode(this.getFileObject(), method, compilationInfo);
                    } else if (element2.getKind() == ElementKind.FIELD) {
                        if (!JavaMembersAndHierarchyOptions.isShowFields()) continue;
                        VariableElement field = (VariableElement)element2;
                        if (!set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.PROTECTED) && !set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate() || set.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) continue;
                        node = new FieldTreeNode(this.getFileObject(), field, compilationInfo);
                    } else if (element2.getKind() == ElementKind.ENUM_CONSTANT) {
                        if (!JavaMembersAndHierarchyOptions.isShowEnumConstants()) continue;
                        VariableElement enumConstant = (VariableElement)element2;
                        if (!set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.PROTECTED) && !set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPackage() || set.contains((Object)Modifier.PROTECTED) && !JavaMembersAndHierarchyOptions.isShowProtected() || set.contains((Object)Modifier.PRIVATE) && !JavaMembersAndHierarchyOptions.isShowPrivate() || set.contains((Object)Modifier.STATIC) && !JavaMembersAndHierarchyOptions.isShowStatic()) continue;
                        node = new EnumConstantTreeNode(this.getFileObject(), enumConstant, compilationInfo);
                    }
                    if (node == null || !JavaMembersModel.this.patternMatch(node)) continue;
                }
                if (node == null) continue;
                this.insert(node, index++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInherited()) {
                TypeElement typeElement2;
                TypeMirror superClassTypeMirror = typeElement.getSuperclass();
                if (superClassTypeMirror.getKind() != TypeKind.NONE && (typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement()) != null && !typeElement2.getQualifiedName().toString().equals(Object.class.getName())) {
                    FileObject fileObject = SourceUtils.getFile((Element)typeElement2, (ClasspathInfo)compilationInfo.getClasspathInfo());
                    this.insert(new TypeTreeNode(fileObject, typeElement2, compilationInfo, true), index++);
                }
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                for (TypeMirror typeMirror : list) {
                    TypeElement anInterface = (TypeElement)((DeclaredType)typeMirror).asElement();
                    FileObject fileObject = SourceUtils.getFile((Element)anInterface, (ClasspathInfo)compilationInfo.getClasspathInfo());
                    this.insert(new TypeTreeNode(fileObject, anInterface, compilationInfo, true), index++);
                }
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole && JavaMembersAndHierarchyOptions.isShowInherited()) {
                for (Element element3 : enclosedElements) {
                    if (element3.getKind() != ElementKind.CLASS && element3.getKind() != ElementKind.INTERFACE && element3.getKind() != ElementKind.ENUM) continue;
                    node = new TypeTreeNode(this.getFileObject(), (TypeElement)element3, compilationInfo);
                    this.insert(node, index++);
                }
            }
            return index;
        }
    }
}

