/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class JavadocTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(JavadocTopComponent.class.getName());
    private static JavadocTopComponent instance;
    public static final String ICON_PATH = "org/netbeans/modules/java/navigation/resources/javadoc_action.png";
    private static final String PREFERRED_ID = "JavadocTopComponent";
    private static final Rectangle ZERO;
    private JEditorPane javadocEditorPane;
    private JScrollPane javadocScrollPane;

    private JavadocTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(JavadocTopComponent.class, (String)"CTL_JavadocTopComponent"));
        this.setToolTipText(NbBundle.getMessage(JavadocTopComponent.class, (String)"HINT_JavadocTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    void setJavadoc(String header, String javadoc) {
        if (javadoc == null) {
            this.javadocEditorPane.setText("");
        } else {
            javadoc = javadoc.replaceAll("@author", "<br><b>Author:</b>").replaceAll("@deprecated", "<br><b>Deprecated.</b>").replaceAll("@exception", "<br><b>Throws:</b>").replaceAll("@param", "<br><b>Parameter:</b>").replaceAll("@return", "<br><b>Returns:</b>").replaceAll("@see", "<br><b>See Also:</b>").replaceAll("@since", "<br><b>Since:</b>").replaceAll("@throws", "<br><b>Throws:</b>").replaceAll("@version", "<br><b>Version:</b>").replaceAll("@beaninfo", "<br><b>@beaninfo</b><br>").replaceAll("\\{@link ([^}]+)\\}", "$1").replaceAll("\\{@code ([^}]+)\\}", "\\<code\\>$1\\</code\\>");
            this.javadocEditorPane.setText("<html><head><link rel=\"StyleSheet\" href=\"nbresloc:/org/netbeans/modules/java/navigation/resources/ide.css\" type=\"text/css\"></head><body style=\"background-color: rgb(255,255,222);\">" + (header == null ? "" : "<b>" + header + "</b><br><hr>") + javadoc + "</body>" + "</html>");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavadocTopComponent.this.javadocEditorPane.scrollRectToVisible(ZERO);
            }
        });
    }

    public static boolean shouldUpdate() {
        if (instance == null) {
            return false;
        }
        return instance.isShowing();
    }

    private void initComponents() {
        this.javadocScrollPane = new JScrollPane();
        this.javadocEditorPane = new JEditorPane();
        this.javadocEditorPane.setBackground(new Color(255, 255, 222));
        this.javadocEditorPane.setContentType("text/html");
        this.javadocEditorPane.setEditable(false);
        this.javadocEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                JavadocTopComponent.this.javadocEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.javadocScrollPane.setViewportView(this.javadocEditorPane);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.javadocScrollPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.javadocScrollPane, -1, 300, Short.MAX_VALUE));
    }

    private void javadocEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (!HyperlinkEvent.EventType.ENTERED.equals(evt.getEventType())) {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(evt.getEventType())) {
                URL url = evt.getURL();
                if (url != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            } else if (HyperlinkEvent.EventType.EXITED.equals(evt.getEventType())) {
                // empty if block
            }
        }
    }

    public static synchronized JavadocTopComponent getDefault() {
        if (instance == null) {
            instance = new JavadocTopComponent();
        }
        return instance;
    }

    public static synchronized JavadocTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            LOGGER.log(Level.WARNING, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return JavadocTopComponent.getDefault();
        }
        if (win instanceof JavadocTopComponent) {
            return (JavadocTopComponent)win;
        }
        LOGGER.log(Level.WARNING, "There seem to be multiple components with the 'JavadocTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return JavadocTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.javadocEditorPane.requestFocusInWindow();
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        ZERO = new Rectangle(0, 0, 1, 1);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return JavadocTopComponent.getDefault();
        }
    }
}

