/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import org.openide.windows.WindowManager;

final class ResizablePopup {
    private static Rectangle lastBounds;
    private static final WindowListener windowListener;

    ResizablePopup() {
    }

    static JDialog getDialog() {
        JDialog dialog = new JDialog(WindowManager.getDefault().getMainWindow(), "", false){

            public void setVisible(boolean visible) {
                boolean wasVisible = this.isVisible();
                if (wasVisible && !visible) {
                    lastBounds = this.getBounds();
                }
                super.setVisible(visible);
            }
        };
        dialog.setBounds(lastBounds);
        dialog.addWindowListener(windowListener);
        dialog.setDefaultCloseOperation(1);
        return dialog;
    }

    static {
        Dimension dimensions = Toolkit.getDefaultToolkit().getScreenSize();
        lastBounds = new Rectangle(dimensions.width / 2 - 410, dimensions.height / 2 - 300, 820, 600);
        windowListener = new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                this.cleanup(windowEvent.getWindow());
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.cleanup(windowEvent.getWindow());
            }

            private void cleanup(Window window) {
                window.setVisible(false);
                if (window instanceof RootPaneContainer) {
                    ((RootPaneContainer)((Object)window)).setContentPane(new JPanel());
                }
                window.removeWindowListener(this);
                window.dispose();
            }
        };
    }
}

