/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Rectangle;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    Utils() {
    }

    static String format(Element element) {
        return Utils.format(element, false);
    }

    static String format(Element element, boolean forSignature) {
        StringBuilder stringBuilder = new StringBuilder();
        Utils.format(element, stringBuilder, forSignature);
        return stringBuilder.toString();
    }

    static void format(Element element, StringBuilder stringBuilder, boolean forSignature) {
        if (element == null) {
            return;
        }
        boolean first = true;
        Set<javax.lang.model.element.Modifier> modifiers = element.getModifiers();
        switch (element.getKind()) {
            case PACKAGE: {
                PackageElement packageElement = (PackageElement)element;
                if (forSignature) {
                    stringBuilder.append("package ");
                }
                stringBuilder.append(packageElement.getQualifiedName());
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                }
                if (forSignature) {
                    switch (element.getKind()) {
                        case CLASS: {
                            stringBuilder.append("class ");
                            break;
                        }
                        case INTERFACE: {
                            stringBuilder.append("interface ");
                            break;
                        }
                        case ENUM: {
                            stringBuilder.append("enum ");
                            break;
                        }
                        case ANNOTATION_TYPE: {
                            stringBuilder.append("@interface ");
                        }
                    }
                }
                TypeElement typeElement = (TypeElement)element;
                stringBuilder.append(JavaMembersAndHierarchyOptions.isShowFQN() ? typeElement.getQualifiedName().toString() : typeElement.getSimpleName().toString());
                Utils.formatTypeParameters(typeElement.getTypeParameters(), stringBuilder);
                break;
            }
            case CONSTRUCTOR: {
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                }
                ExecutableElement constructorElement = (ExecutableElement)element;
                stringBuilder.append(constructorElement.getEnclosingElement().getSimpleName().toString());
                stringBuilder.append("(");
                Utils.formatVariableElements(constructorElement.getParameters(), constructorElement.isVarArgs(), stringBuilder);
                stringBuilder.append(")");
                List<? extends TypeMirror> thrownTypesMirrors = constructorElement.getThrownTypes();
                if (thrownTypesMirrors.isEmpty()) break;
                stringBuilder.append(" throws ");
                Utils.formatTypeMirrors(thrownTypesMirrors, stringBuilder);
                break;
            }
            case METHOD: {
                ExecutableElement methodElement = (ExecutableElement)element;
                TypeMirror returnTypeMirror = methodElement.getReturnType();
                List<? extends TypeParameterElement> typeParameters = methodElement.getTypeParameters();
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (modifiers.size() > 0 && stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    if (typeParameters != null && typeParameters.size() > 0) {
                        Utils.formatTypeParameters(typeParameters, stringBuilder);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" ");
                        }
                    }
                    Utils.formatTypeMirror(returnTypeMirror, stringBuilder);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(methodElement.getSimpleName().toString());
                stringBuilder.append("(");
                Utils.formatVariableElements(methodElement.getParameters(), methodElement.isVarArgs(), stringBuilder);
                stringBuilder.append(")");
                List<? extends TypeMirror> thrownTypesMirrorsByMethod = methodElement.getThrownTypes();
                if (!thrownTypesMirrorsByMethod.isEmpty()) {
                    stringBuilder.append(" throws ");
                    Utils.formatTypeMirrors(thrownTypesMirrorsByMethod, stringBuilder);
                }
                if (forSignature) {
                    Object annotationValueValue;
                    AnnotationValue annotationValue = methodElement.getDefaultValue();
                    if (annotationValue == null || (annotationValueValue = annotationValue.getValue()) == null) break;
                    stringBuilder.append(" default ");
                    if (annotationValueValue instanceof String) {
                        stringBuilder.append("\"");
                    } else if (annotationValueValue instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(annotationValueValue));
                    if (annotationValueValue instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(annotationValueValue instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                Utils.formatTypeMirror(returnTypeMirror, stringBuilder);
                if (typeParameters != null && typeParameters.size() > 0) {
                    stringBuilder.append(":");
                    Utils.formatTypeParameters(typeParameters, stringBuilder);
                }
                if (!JavaMembersAndHierarchyOptions.isShowInherited()) break;
                stringBuilder.append(" [");
                stringBuilder.append(element.getEnclosingElement());
                stringBuilder.append("]");
                break;
            }
            case TYPE_PARAMETER: {
                TypeParameterElement typeParameterElement = (TypeParameterElement)element;
                stringBuilder.append(typeParameterElement.getSimpleName());
                List<? extends TypeMirror> bounds = null;
                try {
                    bounds = typeParameterElement.getBounds();
                    if (bounds == null || bounds.size() <= 0 || bounds.size() == 1 && "java.lang.Object".equals(((Object)bounds.get(0)).toString())) break;
                    stringBuilder.append(" extends ");
                    first = true;
                    for (TypeMirror typeMirror : bounds) {
                        if (first) {
                            first = false;
                        } else {
                            stringBuilder.append(" & ");
                        }
                        Utils.formatTypeMirror(typeMirror, stringBuilder);
                    }
                    break;
                }
                catch (NullPointerException npe) {
                    break;
                }
            }
            case FIELD: {
                VariableElement fieldElement = (VariableElement)element;
                if (forSignature) {
                    stringBuilder.append(Utils.toString(modifiers));
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    Utils.formatTypeMirror(fieldElement.asType(), stringBuilder);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(fieldElement.getSimpleName().toString());
                if (forSignature) {
                    Object object = fieldElement.getConstantValue();
                    if (object == null) break;
                    stringBuilder.append(" = ");
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                    } else if (object instanceof Character) {
                        stringBuilder.append("'");
                    }
                    stringBuilder.append(String.valueOf(object));
                    if (object instanceof String) {
                        stringBuilder.append("\"");
                        break;
                    }
                    if (!(object instanceof Character)) break;
                    stringBuilder.append("'");
                    break;
                }
                stringBuilder.append(":");
                Utils.formatTypeMirror(fieldElement.asType(), stringBuilder);
                if (!JavaMembersAndHierarchyOptions.isShowInherited()) break;
                stringBuilder.append(" [");
                stringBuilder.append(element.getEnclosingElement());
                stringBuilder.append("]");
                break;
            }
            case ENUM_CONSTANT: {
                stringBuilder.append(element.toString());
                if (!JavaMembersAndHierarchyOptions.isShowInherited()) break;
                stringBuilder.append(" [");
                stringBuilder.append(element.getEnclosingElement());
                stringBuilder.append("]");
                break;
            }
            case PARAMETER: {
                VariableElement variableElement = (VariableElement)element;
                Utils.formatTypeMirror(variableElement.asType(), stringBuilder);
                stringBuilder.append(" ");
                stringBuilder.append(element.getSimpleName().toString());
            }
        }
    }

    static void formatTypeMirror(TypeMirror typeMirror, StringBuilder stringBuilder) {
        if (typeMirror == null) {
            return;
        }
        boolean first = true;
        switch (typeMirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NONE: 
            case NULL: 
            case SHORT: 
            case VOID: {
                stringBuilder.append(typeMirror);
                break;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                stringBuilder.append(typeVariable.asElement().getSimpleName().toString());
                break;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                stringBuilder.append("?");
                if (wildcardType.getExtendsBound() != null) {
                    stringBuilder.append(" extends ");
                    Utils.formatTypeMirror(wildcardType.getExtendsBound(), stringBuilder);
                }
                if (wildcardType.getSuperBound() == null) break;
                stringBuilder.append(" super ");
                Utils.formatTypeMirror(wildcardType.getSuperBound(), stringBuilder);
                break;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                Element element = declaredType.asElement();
                if (element instanceof TypeElement) {
                    stringBuilder.append(JavaMembersAndHierarchyOptions.isShowFQN() ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
                } else {
                    stringBuilder.append(element.getSimpleName().toString());
                }
                List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
                if (typeArgs.isEmpty()) break;
                stringBuilder.append("<");
                Utils.formatTypeMirrors(typeArgs, stringBuilder);
                stringBuilder.append(">");
                break;
            }
            case ARRAY: {
                int dims = 0;
                while (typeMirror.getKind() == TypeKind.ARRAY) {
                    ++dims;
                    typeMirror = ((ArrayType)typeMirror).getComponentType();
                }
                Utils.formatTypeMirror(typeMirror, stringBuilder);
                for (int i = 0; i < dims; ++i) {
                    stringBuilder.append("[]");
                }
                break;
            }
        }
    }

    static void formatTypeParameters(List<? extends TypeParameterElement> typeParameters, StringBuilder stringBuilder) {
        if (typeParameters == null || typeParameters.size() == 0) {
            return;
        }
        boolean first = true;
        if (typeParameters.size() > 0) {
            stringBuilder.append("<");
            first = true;
            for (TypeParameterElement typeParameterElement : typeParameters) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                Utils.format(typeParameterElement, stringBuilder, false);
            }
            stringBuilder.append(">");
        }
    }

    static void formatVariableElements(List<? extends VariableElement> variableElements, boolean varArgs, StringBuilder stringBuilder) {
        if (variableElements == null || variableElements.size() == 0) {
            return;
        }
        boolean first = true;
        for (VariableElement variableElement : variableElements) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            Utils.format(variableElement, stringBuilder, false);
        }
        if (varArgs) {
            stringBuilder.append("...");
        }
    }

    static void formatTypeMirrors(List<? extends TypeMirror> thrownTypeMirros, StringBuilder stringBuilder) {
        if (thrownTypeMirros == null || thrownTypeMirros.size() == 0) {
            return;
        }
        boolean first = true;
        for (TypeMirror typeMirror : thrownTypeMirros) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            Utils.formatTypeMirror(typeMirror, stringBuilder);
        }
    }

    static int getIntModifiers(Set<javax.lang.model.element.Modifier> modifiers) {
        int intModifiers = 0;
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            intModifiers |= 0x400;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.FINAL)) {
            intModifiers |= 0x10;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.NATIVE)) {
            intModifiers |= 0x100;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PRIVATE)) {
            intModifiers |= 2;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PROTECTED)) {
            intModifiers |= 4;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            intModifiers |= 1;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            intModifiers |= 8;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.STRICTFP)) {
            intModifiers |= 0x800;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.SYNCHRONIZED)) {
            intModifiers |= 0x20;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.TRANSIENT)) {
            intModifiers |= 0x80;
        }
        if (modifiers.contains((Object)javax.lang.model.element.Modifier.VOLATILE)) {
            intModifiers |= 0x40;
        }
        return intModifiers;
    }

    static String toString(Set<javax.lang.model.element.Modifier> modifiers) {
        return Modifier.toString(Utils.getIntModifiers(modifiers));
    }

    static Set<javax.lang.model.element.Modifier> getModifiers(int intModifiers) {
        EnumSet<javax.lang.model.element.Modifier> modifiers = EnumSet.noneOf(javax.lang.model.element.Modifier.class);
        if ((intModifiers & 0x400) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.ABSTRACT);
        }
        if ((intModifiers & 0x10) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.FINAL);
        }
        if ((intModifiers & 0x100) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.NATIVE);
        }
        if ((intModifiers & 2) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.PRIVATE);
        }
        if ((intModifiers & 4) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.PROTECTED);
        }
        if ((intModifiers & 1) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        if ((intModifiers & 8) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.STATIC);
        }
        if ((intModifiers & 0x800) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.STRICTFP);
        }
        if ((intModifiers & 0x20) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.SYNCHRONIZED);
        }
        if ((intModifiers & 0x80) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.TRANSIENT);
        }
        if ((intModifiers & 0x40) != 0) {
            modifiers.add(javax.lang.model.element.Modifier.VOLATILE);
        }
        return modifiers;
    }

    static boolean patternMatch(JavaElement javaToolsJavaElement, String pattern, String patternLowerCase) {
        if (pattern == null) {
            return true;
        }
        String patternRegexpString = pattern;
        patternRegexpString = pattern.trim().length() == 0 ? pattern + ".*" : pattern.replaceAll(Pattern.quote("*"), Matcher.quoteReplacement(".*")).replaceAll(Pattern.quote("?"), Matcher.quoteReplacement(".")) + (pattern.endsWith("$") ? "" : ".*");
        String name = javaToolsJavaElement.getName();
        try {
            Pattern compiledPattern = Pattern.compile(patternRegexpString, JavaMembersAndHierarchyOptions.isCaseSensitive() ? 0 : 2);
            Matcher m = compiledPattern.matcher(name);
            return m.matches();
        }
        catch (PatternSyntaxException pse) {
            if (JavaMembersAndHierarchyOptions.isCaseSensitive()) {
                return name.startsWith(pattern);
            }
            return name.toLowerCase().startsWith(patternLowerCase);
        }
    }

    static String getClassName(String className) {
        int lastDot;
        int firstLessThan = className.indexOf(60);
        if (firstLessThan != -1) {
            className = className.substring(0, firstLessThan);
        }
        if (!JavaMembersAndHierarchyOptions.isShowFQN() && (lastDot = className.lastIndexOf(46)) != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    static String getClassNameSansPackage(String className) {
        int lastDot;
        int firstLessThan = className.indexOf(60);
        if (firstLessThan != -1) {
            className = className.substring(0, firstLessThan);
        }
        if ((lastDot = className.lastIndexOf(46)) != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    static void firstRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            tree.setSelectionRow(0);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void previousRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            int selectedRow = tree.getSelectionModel().getMinSelectionRow();
            if (selectedRow == -1) {
                selectedRow = rowCount - 1;
            } else if (--selectedRow < 0) {
                selectedRow = rowCount - 1;
            }
            tree.setSelectionRow(selectedRow);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void nextRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            int selectedRow = tree.getSelectionModel().getMinSelectionRow();
            if (selectedRow == -1) {
                selectedRow = 0;
                tree.setSelectionRow(selectedRow);
            } else {
                ++selectedRow;
            }
            tree.setSelectionRow(selectedRow % rowCount);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void lastRow(JTree tree) {
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            tree.setSelectionRow(rowCount - 1);
            Utils.scrollTreeToSelectedRow(tree);
        }
    }

    static void scrollTreeToSelectedRow(final JTree tree) {
        final int selectedRow = tree.getLeadSelectionRow();
        if (selectedRow >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tree.scrollRectToVisible(tree.getRowBounds(selectedRow));
                }
            });
        }
    }

    static void showJavaDoc(JavaElement node, final JEditorPane javaDocPane) {
        javaDocPane.setText("");
        String javaDoc = node.getJavaDoc();
        if (javaDoc != null) {
            javaDocPane.setText("<html><head><link rel=\"StyleSheet\" href=\"nbresloc:/org/netbeans/modules/java/navigation/resources/ide.css\" type=\"text/css\"></head><body>" + javaDoc + "</body>" + "</html>");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                javaDocPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    static String formatJavaDoc(String javaDoc) {
        if (javaDoc != null) {
            return javaDoc.replaceAll("@author", "<br><b>Author:</b>").replaceAll("@deprecated", "<br><b>Deprecated.</b>").replaceAll("@exception", "<br><b>Throws:</b>").replaceAll("@param", "<br><b>Parameter:</b>").replaceAll("@return", "<br><b>Returns:</b>").replaceAll("@see", "<br><b>See Also:</b>").replaceAll("@since", "<br><b>Since:</b>").replaceAll("@throws", "<br><b>Throws:</b>").replaceAll("@version", "<br><b>Version:</b>").replaceAll("@beaninfo ?", "<br><b>@beaninfo</b><br>").replaceAll("\\{@link ([^}]+)\\}", "$1").replaceAll("\\{@code ([^}]+)\\}", "\\<code\\>$1\\</code\\>");
        }
        return null;
    }
}

