/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.java.navigation.JavaHierarchy;
import org.netbeans.modules.java.navigation.actions.InspectMembersAtCaretAction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class InspectHierarchyAtCaretAction
extends BaseAction {
    private static final String INSPECT_HIERARCHY_AT_CARET = "inspect-hierarchy-at-caret";

    public InspectHierarchyAtCaretAction() {
        super(NbBundle.getMessage(InspectMembersAtCaretAction.class, (String)INSPECT_HIERARCHY_AT_CARET), 0);
        this.putValue("ActionCommandKey", INSPECT_HIERARCHY_AT_CARET);
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("trimmed-text", this.getValue("Name"));
        this.putValue("PopupMenuText", this.getValue("Name"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)target.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Document document = compilationController.getDocument();
                    if (document != null) {
                        int dot = target.getCaret().getDot();
                        TreePath tp = compilationController.getTreeUtilities().pathFor(dot);
                        Element element = compilationController.getTrees().getElement(tp);
                        if (element instanceof TypeElement) {
                            FileObject elementFileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
                            if (elementFileObject != null) {
                                JavaHierarchy.show(elementFileObject, new Element[]{element}, compilationController);
                            }
                        } else if (element instanceof VariableElement) {
                            FileObject elementFileObject;
                            TypeMirror typeMirror = ((VariableElement)element).asType();
                            if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null && (elementFileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                JavaHierarchy.show(elementFileObject, new Element[]{element}, compilationController);
                            }
                        } else if (element instanceof ExecutableElement) {
                            FileObject elementFileObject;
                            if (element.getKind() == ElementKind.METHOD) {
                                FileObject elementFileObject2;
                                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                                if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null && (elementFileObject2 = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                    JavaHierarchy.show(elementFileObject2, new Element[]{element}, compilationController);
                                }
                            } else if (element.getKind() == ElementKind.CONSTRUCTOR && (element = element.getEnclosingElement()) != null && (elementFileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo())) != null) {
                                JavaHierarchy.show(elementFileObject, new Element[]{element}, compilationController);
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(InspectHierarchyAtCaretAction.class.getName()).log(Level.WARNING, e.getMessage(), e);
        }
    }
}

