/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.palette.Utils;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

class ItemNode
extends FilterNode {
    private Action[] actions;

    public ItemNode(Node originalNode) {
        super(originalNode, FilterNode.Children.LEAF);
    }

    public Action[] getActions(boolean context) {
        PaletteActions customActions;
        if (this.actions == null) {
            Node n = this.getParentNode();
            this.actions = new Action[]{new Utils.CutItemAction((Node)this), new Utils.CopyItemAction((Node)this), new Utils.PasteItemAction(n), null, new Utils.RemoveItemAction((Node)this), null, new Utils.SortItemsAction(n), null, new Utils.RefreshPaletteAction()};
        }
        if (null != (customActions = this.getCustomActions())) {
            return Utils.mergeActions(this.actions, customActions.getCustomItemActions(this.getLookup()));
        }
        return this.actions;
    }

    public Transferable clipboardCut() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCut());
        this.customizeTransferable(t);
        t.put(this.createTransferable());
        return t;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCopy());
        this.customizeTransferable(t);
        t.put(this.createTransferable());
        return t;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    public Transferable drag() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.drag());
        this.customizeTransferable(t);
        t.put(this.createTransferable());
        return t;
    }

    private ExTransferable.Single createTransferable() {
        final Lookup lkp = this.getLookup();
        return new ExTransferable.Single(PaletteController.ITEM_DATA_FLAVOR){

            public Object getData() {
                return lkp;
            }
        };
    }

    private void customizeTransferable(ExTransferable t) {
        DragAndDropHandler tp = this.getTransferableProvider();
        if (null != tp) {
            tp.customize(t, this.getLookup());
        }
    }

    private PaletteActions getCustomActions() {
        Node category = this.getParentNode();
        assert (null != category);
        Node root = category.getParentNode();
        assert (null != root);
        return (PaletteActions)root.getLookup().lookup(PaletteActions.class);
    }

    private DragAndDropHandler getTransferableProvider() {
        Node category = this.getParentNode();
        assert (null != category);
        Node root = category.getParentNode();
        assert (null != root);
        return (DragAndDropHandler)root.getLookup().lookup(DragAndDropHandler.class);
    }

    public Action getPreferredAction() {
        PaletteActions customActions = this.getCustomActions();
        if (null == customActions) {
            return null;
        }
        return customActions.getPreferredAction(this.getLookup());
    }

    public boolean canDestroy() {
        return !Utils.isReadonly(this.getOriginal());
    }

    Node getOriginalNode() {
        return this.getOriginal();
    }

    public HelpCtx getHelpCtx() {
        return Utils.getHelpCtx((Node)this, super.getHelpCtx());
    }
}

