/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteSwitch;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

final class PaletteTopComponent
extends TopComponent
implements PropertyChangeListener {
    static final long serialVersionUID = 4248268998485315735L;
    private static PaletteTopComponent instance;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private TopComponent paletteSource;

    private PaletteTopComponent() {
        this.setName(Utils.getBundleString("CTL_Component_palette"));
        this.setToolTipText(Utils.getBundleString("HINT_PaletteComponent"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/palette/resources/palette.png"));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(505, 88));
        this.add(PalettePanel.getDefault().getScrollPane(), "Center");
        this.putClientProperty("keepPreferredSizeWhenSlideIn", Boolean.TRUE);
    }

    public void requestActive() {
        super.requestActive();
        PalettePanel.getDefault().requestFocusInWindow();
    }

    public static synchronized PaletteTopComponent getDefault() {
        if (instance == null) {
            instance = new PaletteTopComponent();
        }
        return instance;
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        PaletteSwitch switcher = PaletteSwitch.getDefault();
        switcher.addPropertyChangeListener(this);
        this.setPaletteController(switcher.getCurrentPalette());
    }

    public void componentClosed() {
        this.setPaletteController(null);
        PaletteSwitch.getDefault().removePropertyChangeListener(this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("component_palette_contents".equals(e.getPropertyName())) {
            PaletteController pc = (PaletteController)e.getNewValue();
            this.setPaletteController(pc);
        }
    }

    private void setPaletteController(PaletteController pc) {
        if (null != pc) {
            PalettePanel.getDefault().setContent(pc, pc.getModel(), pc.getSettings());
        } else {
            PalettePanel.getDefault().setContent(null, null, null);
        }
    }

    public HelpCtx getHelpCtx() {
        return PalettePanel.getDefault().getHelpCtx();
    }

    static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457788L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return PaletteTopComponent.getDefault();
        }
    }
}

