/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaDrawLayerFactory {
    public static final String JAVA_LAYER_NAME = "java-layer";
    public static final int JAVA_LAYER_VISIBILITY = 1010;
    static /* synthetic */ Class class$org$netbeans$editor$ext$ExtSyntaxSupport;

    public static class JavaLayer
    extends DrawLayer.AbstractLayer {
        private int resolvedEndOffset;
        private boolean resolvedValue;
        private NonWhitespaceFwdFinder nwFinder = new NonWhitespaceFwdFinder();

        public JavaLayer() {
            super(JavaDrawLayerFactory.JAVA_LAYER_NAME);
        }

        public void init(DrawContext ctx) {
            this.resolvedEndOffset = 0;
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            int nextOffset = ctx.getTokenOffset() + ctx.getTokenLength();
            this.setNextActivityChangeOffset(nextOffset);
            return true;
        }

        protected Coloring getMethodColoring(DrawContext ctx) {
            TokenContextPath path = ctx.getTokenContextPath().replaceStart(JavaLayerTokenContext.contextPath);
            return ctx.getEditorUI().getColoring(path.getFullTokenName((TokenCategory)JavaLayerTokenContext.METHOD));
        }

        private boolean isMethod(DrawContext ctx) {
            block10: {
                int idEndOffset = ctx.getTokenOffset() + ctx.getTokenLength();
                if (idEndOffset > this.resolvedEndOffset) {
                    this.resolvedEndOffset = idEndOffset;
                    int endOffset = ctx.getEndOffset();
                    int bufferStartOffset = ctx.getBufferStartOffset();
                    char[] buffer = ctx.getBuffer();
                    ExtSyntaxSupport sup = (ExtSyntaxSupport)ctx.getEditorUI().getDocument().getSyntaxSupport().get(class$org$netbeans$editor$ext$ExtSyntaxSupport == null ? (class$org$netbeans$editor$ext$ExtSyntaxSupport = JavaDrawLayerFactory.class$("org.netbeans.editor.ext.ExtSyntaxSupport")) : class$org$netbeans$editor$ext$ExtSyntaxSupport);
                    int nwOffset = Analyzer.findFirstNonWhite((char[])buffer, (int)(idEndOffset - bufferStartOffset), (int)(endOffset - idEndOffset));
                    if (nwOffset >= 0) {
                        boolean bl = this.resolvedValue = buffer[nwOffset] == '(';
                        if (!this.resolvedValue && buffer[nwOffset] == '<') {
                            try {
                                int off;
                                int[] block = sup.findMatchingBlock(ctx.getBufferStartOffset() + nwOffset, true);
                                if (block == null || (off = Utilities.getFirstNonWhiteFwd((BaseDocument)ctx.getEditorUI().getDocument(), (int)block[1])) <= -1) break block10;
                                if (bufferStartOffset + buffer.length > off) {
                                    this.resolvedValue = buffer[off - bufferStartOffset] == '(';
                                    break block10;
                                }
                                this.resolvedValue = ctx.getEditorUI().getDocument().getChars(off, 1)[0] == '(';
                            }
                            catch (BadLocationException e) {
                                this.resolvedValue = false;
                            }
                        }
                    } else {
                        try {
                            int[] block;
                            int off = ctx.getEditorUI().getDocument().find((Finder)this.nwFinder, endOffset, -1);
                            boolean bl = this.resolvedValue = off >= 0 && this.nwFinder.getFoundChar() == '(';
                            if (!this.resolvedValue && this.nwFinder.getFoundChar() == '<' && (block = sup.findMatchingBlock(off, true)) != null && (off = Utilities.getFirstNonWhiteFwd((BaseDocument)ctx.getEditorUI().getDocument(), (int)block[1])) > -1) {
                                this.resolvedValue = ctx.getEditorUI().getDocument().getChars(off, 1)[0] == '(';
                            }
                        }
                        catch (BadLocationException e) {
                            this.resolvedValue = false;
                        }
                    }
                }
            }
            return this.resolvedValue;
        }

        public void updateContext(DrawContext ctx) {
            Coloring mc;
            if (ctx.getTokenID() == JavaTokenContext.IDENTIFIER && this.isMethod(ctx) && (mc = this.getMethodColoring(ctx)) != null) {
                mc.apply(ctx);
            }
        }
    }

    public static class LParenWatcher
    implements DocumentListener {
        NonWhitespaceBwdFinder nwFinder = new NonWhitespaceBwdFinder();

        private void check(DocumentEvent evt) {
            if (evt.getDocument() instanceof BaseDocument) {
                BaseDocument doc = (BaseDocument)evt.getDocument();
                BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
                String text = bevt.getText();
                if (text != null) {
                    boolean found = false;
                    for (int i = text.length() - 1; i >= 0; --i) {
                        if (text.charAt(i) != '(') continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        int offset = evt.getOffset();
                        int redrawOffset = 0;
                        if (offset > 0) {
                            try {
                                redrawOffset = doc.find((Finder)this.nwFinder, offset - 1, 0);
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                            if (redrawOffset < 0) {
                                redrawOffset = 0;
                            }
                        }
                        doc.repaintBlock(redrawOffset, offset);
                    }
                }
            }
        }

        public void insertUpdate(DocumentEvent evt) {
            this.check(evt);
        }

        public void removeUpdate(DocumentEvent evt) {
            this.check(evt);
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }

    public static class NonWhitespaceBwdFinder
    extends FinderFactory.GenericBwdFinder {
        private char foundChar;

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!Character.isWhitespace(ch)) {
                this.found = true;
                this.foundChar = ch;
                return 0;
            }
            return -1;
        }
    }

    static class NonWhitespaceFwdFinder
    extends FinderFactory.GenericFwdFinder {
        private char foundChar;

        NonWhitespaceFwdFinder() {
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char ch, boolean lastChar) {
            if (!Character.isWhitespace(ch)) {
                this.found = true;
                this.foundChar = ch;
                return 0;
            }
            return 1;
        }
    }
}

