/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.Map;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "java-settings-initializer";
    private Class javaKitClass;

    public JavaSettingsInitializer(Class javaKitClass) {
        super(NAME);
        this.javaKitClass = javaKitClass;
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == BaseKit.class) {
            new JavaSettingsDefaults.JavaTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
            new JavaSettingsDefaults.JavaLayerTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
        }
        if (kitClass == this.javaKitClass) {
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])JavaSettingsDefaults.getJavaKeyBindings());
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{JavaTokenContext.context, JavaLayerTokenContext.context});
            settingsMap.put("abbrev-map", JavaSettingsDefaults.getJavaAbbrevMap());
            settingsMap.put("macro-map", JavaSettingsDefaults.getJavaMacroMap());
            settingsMap.put("caret-simple-match-brace", JavaSettingsDefaults.defaultCaretSimpleMatchBrace);
            settingsMap.put("highlight-match-brace", JavaSettingsDefaults.defaultHighlightMatchBrace);
            settingsMap.put("identifier-acceptor", JavaSettingsDefaults.defaultIdentifierAcceptor);
            settingsMap.put("abbrev-reset-acceptor", JavaSettingsDefaults.defaultAbbrevResetAcceptor);
            settingsMap.put("word-match-match-case", JavaSettingsDefaults.defaultWordMatchMatchCase);
            settingsMap.put("word-match-static-words", "Exception IntrospectionException FileNotFoundException IOException ArrayIndexOutOfBoundsException ClassCastException ClassNotFoundException CloneNotSupportedException NullPointerException NumberFormatException SQLException IllegalAccessException IllegalArgumentException");
            settingsMap.put("java-format-space-before-parenthesis", JavaSettingsDefaults.defaultJavaFormatSpaceBeforeParenthesis);
            settingsMap.put("java-format-space-after-comma", JavaSettingsDefaults.defaultJavaFormatSpaceAfterComma);
            settingsMap.put("java-format-newline-before-brace", JavaSettingsDefaults.defaultJavaFormatNewlineBeforeBrace);
            settingsMap.put("java-format-leading-space-in-comment", JavaSettingsDefaults.defaultJavaFormatLeadingSpaceInComment);
            settingsMap.put("java-format-leading-star-in-comment", JavaSettingsDefaults.defaultJavaFormatLeadingStarInComment);
            settingsMap.put("indent-hot-chars-acceptor", JavaSettingsDefaults.defaultIndentHotCharsAcceptor);
            settingsMap.put("reindent-with-text-before", Boolean.FALSE);
            settingsMap.put("pair-characters-completion", JavaSettingsDefaults.defaultPairCharactersCompletion);
            settingsMap.put("goto-class-case-sensitive", JavaSettingsDefaults.defaultGotoClassCaseSensitive);
            settingsMap.put("goto-class-show-inner-classes", JavaSettingsDefaults.defaultGotoClassShowInnerClasses);
            settingsMap.put("goto-class-show-library-classes", JavaSettingsDefaults.defaultGotoClassShowLibraryClasses);
        }
    }
}

