/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.navigator.NavigatorTC;
import org.netbeans.modules.navigator.ProviderRegistry;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorLookupPanelsPolicy;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.netbeans.spi.navigator.NavigatorPanelWithUndo;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NavigatorController
implements LookupListener,
ActionListener,
Lookup.Provider,
PropertyChangeListener {
    static final int COALESCE_TIME = 100;
    private NavigatorTC navigatorTC;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private static final Lookup.Template<Node> CUR_NODES = new Lookup.Template(Node.class);
    private static final Lookup.Template<NavigatorLookupHint> CUR_HINTS = new Lookup.Template(NavigatorLookupHint.class);
    private Lookup.Result<Node> curNodes;
    private Lookup.Result<NavigatorLookupHint> curHints;
    private Node curNode;
    private final Lookup clientsLookup;
    private final Lookup panelLookup;
    private Lookup.Result<Node> panelLookupNodesResult;
    private final LookupListener panelLookupListener;
    private Reference<TopComponent> lastActivatedRef;

    public NavigatorController(NavigatorTC navigatorTC) {
        this.navigatorTC = navigatorTC;
        this.clientsLookup = Lookups.proxy((Lookup.Provider)this);
        this.panelLookup = Lookups.proxy((Lookup.Provider)new PanelLookupWrapper());
        this.panelLookupListener = new PanelLookupListener();
    }

    public void navigatorTCOpened() {
        this.curNodes = Utilities.actionsGlobalContext().lookup(CUR_NODES);
        this.curNodes.addLookupListener((LookupListener)this);
        this.curHints = Utilities.actionsGlobalContext().lookup(CUR_HINTS);
        this.curHints.addLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult = this.panelLookup.lookup(CUR_NODES);
        this.panelLookupNodesResult.addLookupListener(this.panelLookupListener);
        this.updateContext();
    }

    public void navigatorTCClosed() {
        this.curNodes.removeLookupListener((LookupListener)this);
        this.curHints.removeLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult.removeLookupListener(this.panelLookupListener);
        this.curNodes = null;
        this.curHints = null;
        this.curNode = null;
        this.lastActivatedRef = null;
        this.navigatorTC.setPanels(null);
        this.panelLookupNodesResult = null;
    }

    public Lookup getPanelLookup() {
        return this.panelLookup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.navigatorTC.getPanelSelector().getSelectedIndex();
        if (index == -1) {
            return;
        }
        NavigatorPanel newPanel = this.navigatorTC.getPanels().get(index);
        this.activatePanel(newPanel);
    }

    public void activatePanel(NavigatorPanel panel) {
        if (!this.navigatorTC.getPanels().contains(panel)) {
            throw new IllegalArgumentException("Panel is not available for activation: " + panel);
        }
        NavigatorPanel oldPanel = this.navigatorTC.getSelectedPanel();
        if (!panel.equals(oldPanel)) {
            if (oldPanel != null) {
                oldPanel.panelDeactivated();
            }
            panel.panelActivated(this.clientsLookup);
            this.navigatorTC.setSelectedPanel(panel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        if (!((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated())) {
            ActNodeSetter nodeSetter = new ActNodeSetter();
            Object object = this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (this.nodeSetterTask != null) {
                    this.nodeSetterTask.cancel();
                }
                this.nodeSetterTask = RequestProcessor.getDefault().post((Runnable)nodeSetter, 100);
                this.nodeSetterTask.addTaskListener((TaskListener)nodeSetter);
            }
        }
    }

    private Node obtainFirstCurNode() {
        Collection nodeList = this.curNodes.allInstances();
        return nodeList.isEmpty() ? null : (Node)nodeList.iterator().next();
    }

    private boolean shouldUpdate() {
        return TopComponent.getRegistry().getCurrentNodes() != null || Utilities.actionsGlobalContext().lookup(NavigatorLookupHint.class) != null;
    }

    private void updateContext() {
        boolean areNewProviders;
        Node node = this.obtainFirstCurNode();
        if (node == null && !this.shouldUpdate()) {
            return;
        }
        this.curNode = node;
        List<NavigatorPanel> providers = this.obtainProviders(node);
        List<NavigatorPanel> oldProviders = this.navigatorTC.getPanels();
        boolean bl = areNewProviders = providers != null && !providers.isEmpty();
        if (oldProviders == null && providers == null) {
            return;
        }
        NavigatorPanel selPanel = this.navigatorTC.getSelectedPanel();
        if (oldProviders != null && oldProviders.contains(selPanel) && providers != null && providers.contains(selPanel)) {
            this.clientsLookup.lookup(Node.class);
            if (!((Object)oldProviders).equals(providers)) {
                this.navigatorTC.getPanelSelector().removeActionListener(this);
                this.navigatorTC.setPanels(providers);
                this.navigatorTC.setSelectedPanel(selPanel);
                this.navigatorTC.getPanelSelector().addActionListener(this);
            }
            this.updateTCTitle((Node)(areNewProviders ? node : null));
            return;
        }
        if (selPanel != null) {
            if (!areNewProviders) {
                return;
            }
            selPanel.panelDeactivated();
        }
        if (areNewProviders) {
            NavigatorPanel newSel = providers.get(0);
            newSel.panelActivated(this.clientsLookup);
        }
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        this.navigatorTC.setPanels(providers);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        this.navigatorTC.setActivatedNodes(this.obtainActivatedNodes());
        this.updateTCTitle((Node)(areNewProviders ? node : null));
    }

    private void updateTCTitle(Node node) {
        String newTitle = node != null ? NbBundle.getMessage(NavigatorTC.class, (String)"FMT_Navigator", (Object)node.getDisplayName()) : NbBundle.getMessage(NavigatorTC.class, (String)"LBL_Navigator");
        this.navigatorTC.setName(newTitle);
    }

    List<NavigatorPanel> obtainProviders(Node node) {
        Lookup globalContext = Utilities.actionsGlobalContext();
        NavigatorLookupPanelsPolicy panelsPolicy = (NavigatorLookupPanelsPolicy)globalContext.lookup(NavigatorLookupPanelsPolicy.class);
        ArrayList<? extends NavigatorPanel> result = null;
        Collection lkpHints = globalContext.lookupAll(NavigatorLookupHint.class);
        for (NavigatorLookupHint curHint : lkpHints) {
            Collection<? extends NavigatorPanel> providers = ProviderRegistry.getInstance().getProviders(curHint.getContentType());
            if (providers == null || providers.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList<NavigatorPanel>(providers.size() * lkpHints.size());
            }
            result.addAll(providers);
        }
        if (panelsPolicy != null && panelsPolicy.getPanelsPolicy() == 1) {
            return result;
        }
        if (node != null) {
            FileObject fo;
            DataObject dObj = (DataObject)node.getLookup().lookup(DataObject.class);
            while (dObj instanceof DataShadow) {
                dObj = ((DataShadow)dObj).getOriginal();
            }
            if (dObj != null && !(fo = dObj.getPrimaryFile()).isVirtual()) {
                String contentType = fo.getMIMEType();
                Collection<? extends NavigatorPanel> providers = ProviderRegistry.getInstance().getProviders(contentType);
                if (providers != null && !providers.isEmpty()) {
                    if (result == null) {
                        result = new ArrayList(providers.size());
                    }
                    result.addAll(providers);
                }
            }
        }
        return result;
    }

    private Node[] obtainActivatedNodes() {
        Collection nodes = this.getPanelLookup().lookupAll(Node.class);
        if (nodes.isEmpty()) {
            Node[] nodeArray;
            if (this.curNode == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = this.curNode;
            }
            return nodeArray;
        }
        return nodes.toArray(new Node[0]);
    }

    public Lookup getLookup() {
        if (this.curNode == null) {
            return Lookup.EMPTY;
        }
        return this.curNode.getLookup();
    }

    UndoRedo getUndoRedo() {
        NavigatorPanel panel = this.navigatorTC.getSelectedPanel();
        if (panel == null || !(panel instanceof NavigatorPanelWithUndo)) {
            return UndoRedo.NONE;
        }
        return ((NavigatorPanelWithUndo)panel).getUndoRedo();
    }

    public void installActions() {
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        this.navigatorTC.getInputMap(2).put(returnKey, "return");
        this.navigatorTC.getActionMap().put("return", new ESCHandler());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TopComponent tc;
        if ("activated".equals(evt.getPropertyName()) && (tc = TopComponent.getRegistry().getActivated()) != null && tc != this.navigatorTC) {
            this.lastActivatedRef = new WeakReference<TopComponent>(tc);
        }
    }

    private class ActNodeSetter
    implements Runnable,
    TaskListener {
        private ActNodeSetter() {
        }

        public void run() {
            if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                SwingUtilities.invokeLater(this);
            } else if (NavigatorController.this.curNodes != null) {
                NavigatorController.this.updateContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = NavigatorController.this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (task == NavigatorController.this.nodeSetterTask) {
                    NavigatorController.this.nodeSetterTask = null;
                }
            }
        }
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            if (NavigatorController.this.lastActivatedRef == null || focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)NavigatorController.this.navigatorTC)) || focusOwner instanceof JComboBox) {
                return;
            }
            TopComponent prevFocusedTc = (TopComponent)NavigatorController.this.lastActivatedRef.get();
            if (prevFocusedTc != null) {
                prevFocusedTc.requestActive();
            }
        }
    }

    private final class PanelLookupListener
    implements LookupListener {
        private PanelLookupListener() {
        }

        public void resultChanged(LookupEvent ev) {
            NavigatorController.this.navigatorTC.setActivatedNodes(NavigatorController.this.obtainActivatedNodes());
        }
    }

    private final class PanelLookupWrapper
    implements Lookup.Provider {
        private PanelLookupWrapper() {
        }

        public Lookup getLookup() {
            Lookup panelLkp;
            NavigatorPanel selPanel = NavigatorController.this.navigatorTC.getSelectedPanel();
            if (selPanel != null && (panelLkp = selPanel.getLookup()) != null) {
                return panelLkp;
            }
            return Lookup.EMPTY;
        }
    }
}

