/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.RecognizedOptions;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Messages;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.MissingResourceException;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Main.java\t1.111 06/08/02")
public class Main {
    String ownName;
    PrintWriter out;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private JavacOption.Option[] recognizedOptions = RecognizedOptions.getJavaCompilerOptions(new RecognizedOptions.OptionHelper(){

        public void setOut(PrintWriter out) {
            Main.this.out = out;
        }

        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        public void printVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("version", Main.this.ownName, JavaCompiler.version()));
        }

        public void printFullVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("fullVersion", Main.this.ownName, JavaCompiler.fullVersion()));
        }

        public void printHelp() {
            Main.this.help();
        }

        public void printXhelp() {
            Main.this.xhelp();
        }

        public void addFile(File f) {
            if (!Main.this.filenames.contains(f)) {
                Main.this.filenames.append(f);
            }
        }

        public void addClassName(String s) {
            Main.this.classnames.append(s);
        }
    });
    private Options options = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.sun.tools.javac.resources.javac";
    private static Messages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void help() {
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.header", this.ownName));
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].help(this.out);
        }
        this.out.println();
    }

    void xhelp() {
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].xhelp(this.out);
        }
        this.out.println();
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.nonstandard.footer", new Object[0]));
    }

    void error(String key, Object ... args) {
        this.warning(key, args);
        Log.printLines(this.out, Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines(this.out, this.ownName + ": " + Main.getLocalizedString(key, args));
    }

    public JavacOption.Option getOption(String flag) {
        for (JavacOption.Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public List<File> processArgs(String[] flags) {
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            int firstOptionToCheck;
            int j;
            String flag = flags[ac];
            ++ac;
            for (j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length && !this.recognizedOptions[j].matches(flag); ++j) {
            }
            if (j == this.recognizedOptions.length) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            JavacOption.Option option = this.recognizedOptions[j];
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.options, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.options, flag)) continue;
            return null;
        }
        if (!this.checkDirectory("-d")) {
            return null;
        }
        if (!this.checkDirectory("-s")) {
            return null;
        }
        String sourceString = this.options.get("-source");
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get("-target");
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                this.options.put("-target", source.requiredTarget().name);
            } else if (targetString == null && !source.allowGenerics()) {
                this.options.put("-target", Target.JDK1_4.name);
            }
        }
        return this.filenames.toList();
    }

    private boolean checkDirectory(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    public int compile(String[] args) {
        Context context = new Context();
        DefaultFileManager.preRegister(context);
        int result = this.compile(args, context);
        if (this.fileManager instanceof DefaultFileManager) {
            ((DefaultFileManager)this.fileManager).close();
        }
        return result;
    }

    public int compile(String[] args, Context context) {
        return this.compile(args, context, List.<JavaFileObject>nil(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        int forceStdOut;
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            if (args.length == 0 && fileObjects.isEmpty()) {
                this.help();
                int n = 2;
                return n;
            }
            List<File> filenames = this.processArgs(CommandLine.parse(args));
            if (filenames == null) {
                int n = 2;
                return n;
            }
            if (filenames.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.get("-help") != null || this.options.get("-X") != null || this.options.get("-version") != null || this.options.get("-fullversion") != null) {
                    int n = 0;
                    return n;
                }
                this.error("err.no.source.files", new Object[0]);
                int n = 2;
                return n;
            }
            int n = forceStdOut = this.options.get("stdout") != null ? 1 : 0;
            if (forceStdOut != 0) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            this.fileManager = context.get(JavaFileManager.class);
            comp = JavaCompiler.instance(context);
            if (comp == null) {
                int n2 = 3;
                return n2;
            }
            if (!filenames.isEmpty()) {
                comp = JavaCompiler.instance(context);
                List<JavaFileObject> otherFiles = List.nil();
                DefaultFileManager dfm = (DefaultFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(filenames)) {
                    otherFiles = otherFiles.prepend(javaFileObject);
                }
                for (JavaFileObject javaFileObject : otherFiles) {
                    fileObjects = fileObjects.prepend(javaFileObject);
                }
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            if (comp.errorCount() != 0 || this.options.get("-Werror") != null && comp.warningCount() != 0) {
                int n3 = 1;
                return n3;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            forceStdOut = 3;
            return forceStdOut;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            forceStdOut = 3;
            return forceStdOut;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            forceStdOut = 3;
            return forceStdOut;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            forceStdOut = 3;
            return forceStdOut;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            forceStdOut = 3;
            return forceStdOut;
        }
        catch (ClientCodeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw new RuntimeException(cause);
            }
            throw new Error(cause);
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            int n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
        }
        return 0;
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace();
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new Messages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new Messages(javacBundleName){

            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new Messages(javacBundleName);
    }
}

