/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.MissingResourceException;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class NbDocsStreamHandler
extends URLStreamHandler {
    NbDocsStreamHandler() {
    }

    protected URLConnection openConnection(URL u) throws IOException {
        if (u.getProtocol().equals("nbdocs")) {
            return new NbDocsURLConnection(u);
        }
        throw new IOException("mismatched protocol");
    }

    public static final class Factory
    implements URLStreamHandlerFactory {
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("nbdocs")) {
                return new NbDocsStreamHandler();
            }
            return null;
        }
    }

    private static final class InfoURLConnection
    extends URLConnection {
        private ByteArrayInputStream stream;
        private String moduleName;

        public InfoURLConnection(URL u, String moduleName) {
            super(u);
            this.moduleName = moduleName;
        }

        public synchronized void connect() throws IOException {
            if (!this.connected) {
                InputStream is = this.url.openStream();
                if (is == null) {
                    throw new IOException("Info file not found.");
                }
                byte[] arr = this.readData(is);
                String s1 = new String(arr, "UTF-8");
                String s2 = s1.replaceAll("\\{0\\}", this.moduleName);
                arr = s2.getBytes("UTF-8");
                this.stream = new ByteArrayInputStream(arr);
                this.connected = true;
            }
        }

        private byte[] readData(InputStream is) throws IOException {
            int step = 4096;
            byte[] buff = new byte[step];
            byte[] sum = new byte[]{};
            int len = -1;
            int readLen = 0;
            int allocLen = 0;
            while (true) {
                if ((len = is.read(buff)) == -1) {
                    byte[] result = new byte[readLen];
                    System.arraycopy(sum, 0, result, 0, readLen);
                    return result;
                }
                if (allocLen < readLen + len) {
                    byte[] tmp = new byte[sum.length];
                    System.arraycopy(sum, 0, tmp, 0, readLen);
                    sum = new byte[allocLen + step];
                    allocLen += step;
                    System.arraycopy(tmp, 0, sum, 0, readLen);
                }
                System.arraycopy(buff, 0, sum, readLen, len);
                readLen += len;
            }
        }

        private void tryToConnect() {
            if (this.connected) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.stream;
        }

        public String getContentType() {
            return "text/html";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.stream.available();
            }
            return 0;
        }
    }

    private static final class NbDocsURLConnection
    extends URLConnection {
        private URLConnection real = null;
        private IOException exception = null;

        public NbDocsURLConnection(URL u) {
            super(u);
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException e = this.exception;
                this.exception = null;
                throw e;
            }
            if (!this.connected) {
                URL target;
                String basename;
                String ext;
                int index;
                String resource;
                String host = this.url.getHost();
                if (host.length() > 0) {
                    ModuleInfo moduleInfo = NbDocsURLConnection.findModule(host);
                    if (moduleInfo != null) {
                        if (!moduleInfo.isEnabled()) {
                            URL info = new URL("nbdocs:/org/netbeans/modules/javahelp/resources/notEnabledModule.html");
                            String moduleName = moduleInfo.getDisplayName();
                            this.real = new InfoURLConnection(info, moduleName);
                            this.real.connect();
                            this.connected = true;
                            return;
                        }
                    } else {
                        URL info = new URL("nbdocs:/org/netbeans/modules/javahelp/resources/notInstalledModule.html");
                        String moduleName = "";
                        try {
                            moduleName = NbBundle.getMessage(NbDocsStreamHandler.class, (String)host);
                        }
                        catch (MissingResourceException exc) {
                            moduleName = host;
                        }
                        this.real = new InfoURLConnection(info, moduleName);
                        this.real.connect();
                        this.connected = true;
                        return;
                    }
                }
                if ((resource = this.url.getFile()).startsWith("/")) {
                    resource = resource.substring(1);
                }
                if ((index = resource.lastIndexOf(46)) != -1 && index > resource.lastIndexOf(47)) {
                    ext = resource.substring(index + 1);
                    basename = resource.substring(0, index).replace('/', '.');
                } else {
                    ext = null;
                    basename = resource.replace('/', '.');
                }
                try {
                    target = NbBundle.getLocalizedFile((String)basename, (String)ext);
                }
                catch (MissingResourceException mre) {
                    File f = InstalledFileLocator.getDefault().locate("docs/" + resource, null, true);
                    if (f != null) {
                        target = f.toURI().toURL();
                    }
                    IOException ioe = new IOException("cannot connect to " + this.url + ": " + mre);
                    ioe.initCause(mre);
                    Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(NbDocsStreamHandler.class, (String)"EXC_nbdocs_cannot_connect", (Object)this.url));
                    throw ioe;
                }
                this.real = target.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private static ModuleInfo findModule(String codeNameBase) {
            Lookup.Result modulesResult = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
            for (ModuleInfo curInfo : modulesResult.allInstances()) {
                if (!curInfo.getCodeNameBase().equals(codeNameBase)) continue;
                return curInfo;
            }
            return null;
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String key) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(key);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }
    }
}

