/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.Actions;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class Favorites
extends FilterNode {
    private static Node node;
    private static Node root;

    private Favorites(Node node) {
        super(node, (Children)new Chldrn(node, false));
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionSelect.png");
    }

    public Image getOpenedIcon(int type) {
        return Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionSelect.png");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public static DataFolder getFolder() {
        try {
            FileObject fo = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)"Favorites");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            return folder;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
        }
    }

    public static synchronized Node getNode() {
        if (node == null) {
            node = new Favorites(Favorites.getFolder().getNodeDelegate());
        }
        return node;
    }

    public static URL getHome() throws FileStateInvalidException, MalformedURLException {
        String s = System.getProperty("user.home");
        File home = new File(s);
        home = FileUtil.normalizeFile((File)home);
        return home.toURI().toURL();
    }

    static File fileForNode(Node n) {
        DataObject obj = (DataObject)n.getCookie(DataObject.class);
        if (obj == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)obj.getPrimaryFile());
    }

    public Node.Handle getHandle() {
        return new RootHandle();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{Actions.addOnFavoritesNode()};
    }

    private static class Chldrn
    extends FilterNode.Children
    implements ChangeListener,
    Runnable {
        private ChangeListener weak;
        private boolean hideHidden;

        public Chldrn(Node node, boolean hideHidden) {
            super(node);
            this.hideHidden = hideHidden;
            this.weak = WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault());
            VisibilityQuery.getDefault().addChangeListener(this.weak);
        }

        protected Node[] createNodes(Node node) {
            DataObject obj;
            if (this.hideHidden && (obj = (DataObject)node.getCookie(DataObject.class)) != null && !VisibilityQuery.getDefault().isVisible(obj.getPrimaryFile())) {
                return null;
            }
            return new Node[]{new ProjectFilterNode(node, (Children)(node.isLeaf() ? Children.LEAF : new Chldrn(node, true)))};
        }

        public void stateChanged(ChangeEvent e) {
            MUTEX.postWriteRequest((Runnable)this);
        }

        public void run() {
            Node[] arr = this.original.getChildren().getNodes();
            for (int i = 0; i < arr.length; ++i) {
                this.refreshKey(arr[i]);
            }
        }
    }

    private static class ProjectFilterNode
    extends FilterNode {
        public ProjectFilterNode(Node node, Children children) {
            super(node, children);
        }

        public String getDisplayName() {
            if (Favorites.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = (DataShadow)this.getCookie(DataShadow.class);
                if (ds != null) {
                    String name = ds.getOriginal().getName();
                    String path = FileUtil.getFileDisplayName((FileObject)ds.getOriginal().getPrimaryFile());
                    return NbBundle.getMessage(Favorites.class, (String)"CTL_DisplayNameTemplate", (Object)name, (Object)path);
                }
                return super.getDisplayName();
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            return this.getOriginal().getHtmlDisplayName();
        }

        public boolean canDestroy() {
            boolean canDestroy = super.canDestroy();
            DataShadow link = (DataShadow)this.getCookie(DataShadow.class);
            if (canDestroy && this.isDeleteOriginal(link)) {
                canDestroy = link.getOriginal().isDeleteAllowed();
            }
            return canDestroy;
        }

        public void destroy() throws IOException {
            if (this.canDestroy()) {
                DataShadow link = (DataShadow)this.getCookie(DataShadow.class);
                DataObject original = this.isDeleteOriginal(link) ? link.getOriginal() : null;
                super.destroy();
                if (original != null) {
                    original.delete();
                }
            }
        }

        private boolean isDeleteOriginal(DataShadow link) {
            return false;
        }

        public Action[] getActions(boolean context) {
            File file;
            FileObject fo;
            Action[] arr = super.getActions(context);
            boolean isRoot = false;
            DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
            if (dataObject != null && (fo = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fo)) != null && file.getParent() == null) {
                isRoot = true;
            }
            if (isRoot) {
                return this.createActionsForRoot(arr);
            }
            if (Favorites.getNode().equals((Object)this.getParentNode())) {
                DataShadow ds = (DataShadow)this.getCookie(DataShadow.class);
                if (ds != null) {
                    if (ds.getOriginal().getPrimaryFile().isFolder()) {
                        return this.createActionsForFavoriteFolder(arr);
                    }
                    return this.createActionsForFavoriteFile(arr);
                }
            } else {
                DataObject dObj = (DataObject)this.getCookie(DataObject.class);
                if (dObj != null) {
                    if (dObj.getPrimaryFile().isFolder()) {
                        return this.createActionsForFolder(arr);
                    }
                    return this.createActionsForFile(arr);
                }
            }
            return arr;
        }

        private Action[] createActionsForRoot(Action[] arr) {
            return arr;
        }

        private Action[] createActionsForFavoriteFolder(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.remove());
                    newArr.add(null);
                }
                if (arr[i] instanceof DeleteAction) continue;
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.remove());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFavoriteFile(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.remove());
                    newArr.add(null);
                }
                if (arr[i] instanceof DeleteAction) continue;
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.remove());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFolder(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.add());
                    newArr.add(null);
                }
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.add());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }

        private Action[] createActionsForFile(Action[] arr) {
            boolean added = false;
            ArrayList<Action> newArr = new ArrayList<Action>();
            for (int i = 0; i < arr.length; ++i) {
                if (!added && (arr[i] instanceof CopyAction || arr[i] instanceof CutAction)) {
                    added = true;
                    newArr.add(Actions.add());
                    newArr.add(null);
                }
                newArr.add(arr[i]);
            }
            if (!added) {
                added = true;
                newArr.add(null);
                newArr.add(Actions.add());
            }
            return newArr.toArray(new Action[newArr.size()]);
        }
    }

    private static class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = 1907300072945111595L;

        private RootHandle() {
        }

        public Node getNode() {
            return Favorites.getNode();
        }
    }
}

