/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.NbBundle;

class CodeTemplatesModel
implements TableModelListener {
    private List languages = new ArrayList();
    private Map languageToMimeType = new HashMap();
    private Set modifiedLanguages = new HashSet();
    private Map languageToModel = new HashMap();
    private Map modelToLanguage = new HashMap();
    private KeyStroke expander;

    CodeTemplatesModel() {
        Vector<String> columns = new Vector<String>();
        columns.add(CodeTemplatesModel.loc("Abbreviation_Title"));
        columns.add(CodeTemplatesModel.loc("Expanded_Text_Title"));
        Set mimeTypes = EditorSettings.getDefault().getAllMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions baseOptions;
            if (this.isCompoundMimeType(mimeType) || (baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class)) == null) continue;
            String language = EditorSettings.getDefault().getLanguageName(mimeType);
            this.languages.add(language);
            Collections.sort(this.languages);
            this.languageToMimeType.put(language, mimeType);
            Map abbreviationsMap = baseOptions.getAbbrevMap();
            ArrayList table = new ArrayList();
            for (String abbreviation : abbreviationsMap.keySet()) {
                Vector<String> line = new Vector<String>(2);
                line.add(abbreviation);
                line.add((String)abbreviationsMap.get(abbreviation));
                table.add(line);
            }
            Collections.sort(table, new MComparator());
            DefaultTableModel tableModel = new DefaultTableModel(new Vector(table), columns){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            tableModel.addTableModelListener(this);
            this.modelToLanguage.put(tableModel, language);
            this.languageToModel.put(language, tableModel);
        }
        this.expander = BaseOptions.getCodeTemplateExpandKey();
    }

    private boolean isCompoundMimeType(String mimeType) {
        int idx = mimeType.lastIndexOf(43);
        return idx != -1 && idx < mimeType.length() - 1;
    }

    List getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    String getMimeType(String language) {
        return (String)this.languageToMimeType.get(language);
    }

    DefaultTableModel getTableModel(String language) {
        return (DefaultTableModel)this.languageToModel.get(language);
    }

    void addRow(String language, String abbreviation, String text) {
        DefaultTableModel tableModel = this.getTableModel(language);
        Vector<String> newLine = new Vector<String>();
        newLine.add(abbreviation);
        newLine.add(text);
        tableModel.insertRow(0, newLine);
        this.modifiedLanguages.add(language);
    }

    void removeRow(String language, int index) {
        DefaultTableModel tableModel = this.getTableModel(language);
        tableModel.removeRow(index);
        this.modifiedLanguages.add(language);
    }

    void saveChanges() {
        for (String language : this.modifiedLanguages) {
            String mimeType = (String)this.languageToMimeType.get(language);
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
            DefaultTableModel tableModel = this.getTableModel(language);
            HashMap<Object, Object> abbreviationsMap = new HashMap<Object, Object>();
            for (int idx = 0; idx < tableModel.getRowCount(); ++idx) {
                abbreviationsMap.put(tableModel.getValueAt(idx, 0), tableModel.getValueAt(idx, 1));
            }
            baseOptions.setAbbrevMap(abbreviationsMap);
        }
        if (this.expander != null && !BaseOptions.getCodeTemplateExpandKey().equals(this.expander)) {
            BaseOptions.setCodeTemplateExpandKey((KeyStroke)this.expander);
        }
    }

    boolean isChanged() {
        return !this.modifiedLanguages.isEmpty() || !BaseOptions.getCodeTemplateExpandKey().equals(this.expander);
    }

    public void tableChanged(TableModelEvent e) {
        DefaultTableModel tableModel = (DefaultTableModel)e.getSource();
        String language = (String)this.modelToLanguage.get(tableModel);
        this.modifiedLanguages.add(language);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(CodeTemplatesModel.class, (String)key);
    }

    KeyStroke getExpander() {
        return this.expander;
    }

    void setExpander(KeyStroke expander) {
        this.expander = expander;
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)((Vector)o1).get(0);
            String s2 = (String)((Vector)o2).get(0);
            return s1.compareTo(s2);
        }
    }
}

