/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.netbeans.modules.options.colors.ColorComboBoxRenderer;
import org.netbeans.modules.options.colors.ColorValue;
import org.openide.util.NbBundle;

public class ColorComboBox {
    public static final String PROP_COLOR = "color";
    private static Object[] content = new Object[]{new ColorValue(Color.BLACK), new ColorValue(Color.BLUE), new ColorValue(Color.CYAN), new ColorValue(Color.DARK_GRAY), new ColorValue(Color.GRAY), new ColorValue(Color.GREEN), new ColorValue(Color.LIGHT_GRAY), new ColorValue(Color.MAGENTA), new ColorValue(Color.ORANGE), new ColorValue(Color.PINK), new ColorValue(Color.RED), new ColorValue(Color.WHITE), new ColorValue(Color.YELLOW), ColorValue.CUSTOM_COLOR, new ColorValue(ColorComboBox.loc("CTL_None_Color"), null)};

    static void init(JComboBox combo) {
        combo.setModel(new DefaultComboBoxModel<Object>(content));
        combo.setRenderer(new ColorComboBoxRenderer(combo));
        combo.setEditable(true);
        combo.setEditor(new ColorComboBoxRenderer(combo));
        combo.setSelectedItem(new ColorValue(null, null));
        combo.addActionListener(new ComboBoxListener(combo));
    }

    static void setInheritedColor(JComboBox combo, Color color) {
        Object[] ncontent = new Object[content.length];
        System.arraycopy(content, 0, ncontent, 0, content.length);
        ncontent[ColorComboBox.content.length - 1] = color != null ? new ColorValue(ColorComboBox.loc("CTL_Inherited_Color"), color) : new ColorValue(ColorComboBox.loc("CTL_None_Color"), null);
        combo.setModel(new DefaultComboBoxModel<Object>(ncontent));
    }

    static void setColor(JComboBox combo, Color color) {
        if (color == null) {
            combo.setSelectedIndex(content.length - 1);
        } else {
            combo.setSelectedItem(new ColorValue(color));
        }
    }

    static Color getColor(JComboBox combo) {
        if (combo.getSelectedIndex() == content.length - 1) {
            return null;
        }
        return ((ColorValue)combo.getSelectedItem()).color;
    }

    private static String loc(String key) {
        return NbBundle.getMessage(ColorComboBox.class, (String)key);
    }

    private static class ComboBoxListener
    implements ActionListener {
        private JComboBox combo;
        private Object lastSelection;

        ComboBoxListener(JComboBox combo) {
            this.combo = combo;
            this.lastSelection = combo.getSelectedItem();
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.combo.getSelectedItem() == ColorValue.CUSTOM_COLOR) {
                Color c = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, this.combo), ColorComboBox.loc("SelectColor"), null);
                if (c != null) {
                    ColorComboBox.setColor(this.combo, c);
                } else if (this.lastSelection != null) {
                    this.combo.setSelectedItem(this.lastSelection);
                }
            }
            this.lastSelection = this.combo.getSelectedItem();
        }
    }
}

