/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public final class ColorModel {
    private static final Logger LOG = Logger.getLogger(ColorModel.class.getName());
    static final String ALL_LANGUAGES = NbBundle.getMessage(ColorModel.class, (String)"CTL_All_Languages");
    private static final String[] EMPTY_MIMEPATH = new String[0];
    private Map languageToMimeType;
    private Set hiddenCategories = new HashSet();

    public Set getProfiles() {
        return EditorSettings.getDefault().getFontColorProfiles();
    }

    public String getCurrentProfile() {
        return EditorSettings.getDefault().getCurrentFontColorProfile();
    }

    public boolean isCustomProfile(String profile) {
        return EditorSettings.getDefault().isCustomFontColorProfile(profile);
    }

    public void setCurrentProfile(String profile) {
        EditorSettings.getDefault().setCurrentFontColorProfile(profile);
    }

    public Collection getAnnotations(String profile) {
        ArrayList<SimpleAttributeSet> annotations = new ArrayList<SimpleAttributeSet>();
        Iterator it = AnnotationTypes.getTypes().getAnnotationTypeNames();
        while (it.hasNext()) {
            String description;
            String name = (String)it.next();
            AnnotationType annotationType = AnnotationTypes.getTypes().getType(name);
            if (!annotationType.isVisible() || (description = annotationType.getDescription()) == null) continue;
            SimpleAttributeSet category = new SimpleAttributeSet();
            category.addAttribute(EditorStyleConstants.DisplayName, description);
            category.addAttribute(StyleConstants.NameAttribute, description);
            URL iconURL = annotationType.getGlyph();
            Image image = null;
            image = iconURL.getProtocol().equals("nbresloc") ? org.openide.util.Utilities.loadImage((String)iconURL.getPath().substring(1)) : Toolkit.getDefaultToolkit().getImage(iconURL);
            if (image != null) {
                category.addAttribute("icon", new ImageIcon(image));
            }
            Color bgColor = annotationType.getHighlight();
            if (annotationType.isUseHighlightColor() && bgColor != null) {
                category.addAttribute(StyleConstants.Background, bgColor);
            }
            Color fgColor = annotationType.getForegroundColor();
            if (!annotationType.isInheritForegroundColor() && fgColor != null) {
                category.addAttribute(StyleConstants.Foreground, fgColor);
            }
            Color underColor = annotationType.getWaveUnderlineColor();
            if (annotationType.isUseWaveUnderlineColor() && underColor != null) {
                category.addAttribute(EditorStyleConstants.WaveUnderlineColor, underColor);
            }
            category.addAttribute("annotationType", annotationType);
            annotations.add(category);
        }
        return annotations;
    }

    public void setAnnotations(String profile, Collection annotations) {
        for (AttributeSet category : annotations) {
            AnnotationType annotationType = (AnnotationType)category.getAttribute("annotationType");
            if (category.isDefined(StyleConstants.Background)) {
                annotationType.setUseHighlightColor(true);
                annotationType.setHighlight((Color)category.getAttribute(StyleConstants.Background));
            } else {
                annotationType.setUseHighlightColor(false);
            }
            if (category.isDefined(StyleConstants.Foreground)) {
                annotationType.setInheritForegroundColor(false);
                annotationType.setForegroundColor((Color)category.getAttribute(StyleConstants.Foreground));
            } else {
                annotationType.setInheritForegroundColor(true);
            }
            if (category.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                annotationType.setUseWaveUnderlineColor(true);
                annotationType.setWaveUnderlineColor((Color)category.getAttribute(EditorStyleConstants.WaveUnderlineColor));
                continue;
            }
            annotationType.setUseWaveUnderlineColor(false);
        }
    }

    public Collection getHighlightings(String profile) {
        Map m = EditorSettings.getDefault().getHighlightings(profile);
        if (m == null) {
            return null;
        }
        return this.hideDummyCategories(m.values());
    }

    public Collection getHighlightingDefaults(String profile) {
        Collection r = EditorSettings.getDefault().getHighlightingDefaults(profile).values();
        if (r == null) {
            return null;
        }
        return this.hideDummyCategories(r);
    }

    public void setHighlightings(String profile, Collection highlihgtings) {
        EditorSettings.getDefault().setHighlightings(profile, ColorModel.toMap(highlihgtings));
    }

    public Set getLanguages() {
        return this.getLanguageToMimeTypeMap().keySet();
    }

    public Collection getCategories(String profile, String language) {
        String[] mimePath = this.getMimePath(language);
        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(mimePath);
        return fcs.getAllFontColors(profile);
    }

    public Collection getDefaults(String profile, String language) {
        String[] mimePath = this.getMimePath(language);
        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(mimePath);
        return fcs.getAllFontColorDefaults(profile);
    }

    public void setCategories(String profile, String language, Collection categories) {
        String[] mimePath = this.getMimePath(language);
        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(mimePath);
        fcs.setAllFontColors(profile, categories);
    }

    public Component getSyntaxColoringPreviewComponent(String language) {
        String mimeType = this.getMimeType(language);
        return new Preview("test" + this.hashCode(), mimeType);
    }

    private String getMimeType(String language) {
        if (language.equals(ALL_LANGUAGES)) {
            return "";
        }
        String mimeType = (String)this.getLanguageToMimeTypeMap().get(language);
        assert (mimeType != null) : "Invalid language '" + language + "'";
        return mimeType;
    }

    private String[] getMimePath(String language) {
        if (language.equals(ALL_LANGUAGES)) {
            return EMPTY_MIMEPATH;
        }
        String mimeType = (String)this.getLanguageToMimeTypeMap().get(language);
        assert (mimeType != null) : "Invalid language '" + language + "'";
        return new String[]{mimeType};
    }

    private Map getLanguageToMimeTypeMap() {
        if (this.languageToMimeType == null) {
            this.languageToMimeType = new HashMap();
            Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
            for (String mimeType : mimeTypes) {
                this.languageToMimeType.put(EditorSettings.getDefault().getLanguageName(mimeType), mimeType);
            }
            this.languageToMimeType.put(ALL_LANGUAGES, "Defaults");
        }
        return this.languageToMimeType;
    }

    private Collection hideDummyCategories(Collection categories) {
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>();
        for (AttributeSet as : categories) {
            if (this.hiddenCategories.contains(as.getAttribute(StyleConstants.NameAttribute))) continue;
            result.add(as);
        }
        return result;
    }

    private static Map toMap(Collection categories) {
        if (categories == null) {
            return null;
        }
        HashMap<Object, AttributeSet> result = new HashMap<Object, AttributeSet>();
        for (AttributeSet as : categories) {
            result.put(as.getAttribute(StyleConstants.NameAttribute), as);
        }
        return result;
    }

    final class Preview
    extends JPanel {
        static final String PROP_CURRENT_ELEMENT = "currentAElement";
        private String testProfileName;
        private String currentMimeType;
        private JEditorPane editorPane;
        private FontColorSettingsFactory fontColorSettings;

        public Preview(String testProfileName, final String mimeType) {
            super(new BorderLayout());
            this.testProfileName = testProfileName;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Preview.this.editorPane = new JEditorPane();
                    Preview.this.updateMimeType(mimeType);
                    Preview.this.add((Component)Preview.this.editorPane, "Center");
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void setParameters(String language, final Collection defaults, final Collection highlightings, final Collection syntaxColorings) {
            final String mimeType = ColorModel.this.getMimeType(language);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!mimeType.equals(Preview.this.currentMimeType)) {
                        Preview.this.updateMimeType(mimeType);
                    }
                    if (defaults != null) {
                        EditorSettings.getDefault().getFontColorSettings(EMPTY_MIMEPATH).setAllFontColors(Preview.this.testProfileName, defaults);
                    }
                    if (highlightings != null) {
                        EditorSettings.getDefault().setHighlightings(Preview.this.testProfileName, ColorModel.toMap(highlightings));
                    }
                    if (syntaxColorings != null && Preview.this.currentMimeType.length() != 0) {
                        FontColorSettingsFactory fcs = EditorSettings.getDefault().getFontColorSettings(new String[]{Preview.this.currentMimeType});
                        fcs.setAllFontColors(Preview.this.testProfileName, syntaxColorings);
                    }
                }
            });
        }

        private void updateMimeType(String mimeType) {
            this.currentMimeType = mimeType;
            String[] ret = this.loadPreviewExample(mimeType);
            String exampleText = ret[0];
            String exampleMimeType = ret[1];
            String hackMimeType = this.hackMimeType(exampleMimeType);
            Document document = this.editorPane.getDocument();
            document.putProperty("mimeType", hackMimeType);
            this.editorPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)hackMimeType));
            document = this.editorPane.getDocument();
            document.putProperty("mimeType", hackMimeType);
            this.editorPane.firePropertyChange((String)null, 0, 1);
            this.editorPane.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    int position = e.getDot();
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)Preview.this.editorPane);
                    if (editorUI == null) {
                        return;
                    }
                    SyntaxSupport ss = Utilities.getSyntaxSupport((JTextComponent)editorUI.getComponent());
                    if (!(ss instanceof ExtSyntaxSupport)) {
                        return;
                    }
                    try {
                        TokenItem tokenItem = ((ExtSyntaxSupport)ss).getTokenChain(position, position + 1);
                        if (tokenItem == null) {
                            return;
                        }
                        String elementName = tokenItem.getTokenContextPath().getNamePrefix();
                        elementName = tokenItem.getTokenID().getCategory() != null ? elementName + tokenItem.getTokenID().getCategory().getName() : elementName + tokenItem.getTokenID().getName();
                        Preview.this.firePropertyChange(Preview.PROP_CURRENT_ELEMENT, null, elementName);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.editorPane.setEnabled(false);
            this.editorPane.setText(exampleText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] loadPreviewExample(String mimeType) {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject exampleFile = null;
            String exampleMimeType = null;
            if (mimeType == null || mimeType.length() == 0) {
                FileObject f = fs.findResource("OptionsDialog/PreviewExamples");
                if (f != null && f.isFolder()) {
                    FileObject[] ff = f.getChildren();
                    for (int i = 0; i < ff.length; ++i) {
                        if (!ff[i].isData()) continue;
                        exampleFile = ff[i];
                        break;
                    }
                }
                if (exampleFile != null) {
                    exampleMimeType = exampleFile.getMIMEType().equals("content/unknown") ? "text/x-java" : exampleFile.getMIMEType();
                }
            } else {
                exampleFile = fs.findResource("OptionsDialog/PreviewExamples/" + mimeType);
                exampleMimeType = mimeType;
            }
            if (exampleFile != null) {
                StringBuilder sb = new StringBuilder((int)exampleFile.getSize());
                try {
                    InputStreamReader is = new InputStreamReader(exampleFile.getInputStream());
                    char[] buffer = new char[1024];
                    try {
                        int size;
                        while (0 < (size = is.read(buffer, 0, buffer.length))) {
                            sb.append(buffer, 0, size);
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "Can't read font & colors preview example", ioe);
                }
                return new String[]{sb.toString(), exampleMimeType};
            }
            return new String[]{"", "text/plain"};
        }

        private String hackMimeType(String mimeType) {
            return this.testProfileName + "_" + mimeType;
        }
    }
}

