/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.general;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.ProxySettings;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.NbPreferences;

class GeneralOptionsModel {
    GeneralOptionsModel() {
    }

    private static Preferences getProxyPreferences() {
        return NbPreferences.root().node("org/netbeans/core");
    }

    private static Preferences getAutoupdatePreferences() {
        return NbPreferences.root().node("org/netbeans/modules/autoupdate");
    }

    int getProxyType() {
        return GeneralOptionsModel.getProxyPreferences().getInt("proxyType", 1);
    }

    void setProxyType(int proxyType) {
        if (proxyType != this.getProxyType()) {
            GeneralOptionsModel.getProxyPreferences().putInt("proxyType", proxyType);
        }
    }

    String getHttpProxyHost() {
        return ProxySettings.getHttpHost();
    }

    void setHttpProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpHost", proxyHost);
        }
    }

    String getHttpProxyPort() {
        return ProxySettings.getHttpPort();
    }

    void setHttpProxyPort(String proxyPort) {
        if (proxyPort != this.getHttpProxyPort()) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpPort", GeneralOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getHttpsProxyHost() {
        return ProxySettings.getHttpsHost();
    }

    void setHttpsProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpsProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsHost", proxyHost);
        }
    }

    String getHttpsProxyPort() {
        return ProxySettings.getHttpsPort();
    }

    void setHttpsProxyPort(String proxyPort) {
        if (proxyPort != this.getHttpsProxyPort()) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsPort", GeneralOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getSocksHost() {
        return ProxySettings.getSocksHost();
    }

    void setSocksHost(String socksHost) {
        if (socksHost != this.getSocksHost()) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksHost", socksHost);
        }
    }

    String getSocksPort() {
        return ProxySettings.getSocksPort();
    }

    void setSocksPort(String socksPort) {
        if (socksPort != this.getSocksPort()) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksPort", GeneralOptionsModel.validatePort(socksPort) ? socksPort : "");
        }
    }

    String getNonProxyHosts() {
        return GeneralOptionsModel.code2view(ProxySettings.getNonProxyHosts());
    }

    void setNonProxyHosts(String nonProxy) {
        if (!nonProxy.equals(this.getNonProxyHosts())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyNonProxyHosts", GeneralOptionsModel.view2code(nonProxy));
        }
    }

    boolean useProxyAuthentication() {
        return ProxySettings.useAuthentication();
    }

    void setUseProxyAuthentication(boolean use) {
        if (use != this.useProxyAuthentication()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAuthentication", use);
        }
    }

    boolean useProxyAllProtocols() {
        return ProxySettings.useProxyAllProtocols();
    }

    void setUseProxyAllProtocols(boolean use) {
        if (use != this.useProxyAllProtocols()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAllProtocols", use);
        }
    }

    String getProxyAuthenticationUsername() {
        return ProxySettings.getAuthenticationUsername();
    }

    void setAuthenticationUsername(String username) {
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationUsername", username);
    }

    char[] getProxyAuthenticationPassword() {
        return ProxySettings.getAuthenticationPassword();
    }

    void setAuthenticationPassword(char[] password) {
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationPassword", new String(password));
    }

    boolean getAutoUpdateAskBeforeCheck() {
        return GeneralOptionsModel.getAutoupdatePreferences().getBoolean("askBefore", false);
    }

    void setAutoUpdateAskBeforeCheck(boolean ask) {
        if (ask != this.getAutoUpdateAskBeforeCheck()) {
            GeneralOptionsModel.getAutoupdatePreferences().putBoolean("askBefore", ask);
        }
    }

    int getAutoUpdatePeriod() {
        return GeneralOptionsModel.getAutoupdatePreferences().getInt("period", 2);
    }

    void setAutoUpdatePeriod(int period) {
        if (period != this.getAutoUpdatePeriod()) {
            GeneralOptionsModel.getAutoupdatePreferences().putInt("period", period);
        }
    }

    boolean isTextAntialiasing() {
        return AllOptionsFolder.getDefault().isTextAntialiasing();
    }

    void setTextAntialiasing(boolean textAntialiasing) {
        AllOptionsFolder.getDefault().setTextAntialiasing(textAntialiasing);
    }

    Map getCodeFoldingProperties() {
        return (Map)GeneralOptionsModel.getEditorOption("getCodeFoldingProps", "text/x-java");
    }

    void setCodeFoldingProperties(Map properties) {
        GeneralOptionsModel.setEditorOption("setCodeFoldingProps", Map.class, properties);
    }

    boolean getAutoPopupCompletion() {
        Boolean b = (Boolean)GeneralOptionsModel.getEditorOption("getCompletionAutoPopup", "text/x-java");
        if (b == null) {
            return true;
        }
        return b;
    }

    void setAutoPopupCompletion(boolean auto) {
        GeneralOptionsModel.setEditorOption("setCompletionAutoPopup", Boolean.TYPE, new Boolean(auto));
    }

    boolean getAutoPopupJavaDoc() {
        Boolean b = (Boolean)GeneralOptionsModel.getEditorOption("getJavaDocAutoPopup", "text/x-java");
        if (b == null) {
            return true;
        }
        return b;
    }

    void setAutoPopupJavaDoc(boolean auto) {
        GeneralOptionsModel.setEditorOption("setJavaDocAutoPopup", Boolean.TYPE, new Boolean(auto));
    }

    private static Object getEditorOption(String methodName, String mimeType) {
        BaseOptions options = GeneralOptionsModel.getOptions(mimeType);
        if (options != null) {
            try {
                Method m = options.getClass().getMethod(methodName, new Class[0]);
                return m.invoke((Object)options, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static void setEditorOption(String methodName, Class paramType, Object value) {
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            try {
                Method m = baseOptions.getClass().getMethod(methodName, paramType);
                m.invoke((Object)baseOptions, value);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {}
        }
    }

    private static boolean validatePort(String port) {
        boolean ok;
        block3: {
            if (port.trim().length() == 0) {
                return true;
            }
            ok = false;
            try {
                Integer.parseInt(port);
                ok = true;
            }
            catch (NumberFormatException nfe) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)nfe);
            }
        }
        return ok;
    }

    private static BaseOptions getOptions(String mimeType) {
        return (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
    }

    private static String code2view(String code) {
        return code == null ? code : code.replace("|", ", ");
    }

    private static String view2code(String view) {
        return view == null ? view : view.replace(", ", "|");
    }
}

