/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

class IndentationModel {
    private boolean originalExpandedTabs = this.isExpandTabs();
    private boolean originalAddStar = this.getJavaFormatLeadingStarInComment();
    private boolean originalNewLine = this.getJavaFormatNewlineBeforeBrace();
    private boolean originalSpace = this.getJavaFormatSpaceBeforeParenthesis();
    private int originalStatementIndent = this.getJavaFormatStatementContinuationIndent();
    private int originalIndent = this.getSpacesPerTab();
    private boolean changed = false;
    private IndentEngine javaIndentEngine = null;
    private ClassLoader classLoader;

    IndentationModel() {
    }

    boolean isExpandTabs() {
        return (Boolean)this.getParameter("isExpandTabs", Boolean.FALSE);
    }

    void setExpandTabs(boolean expand) {
        this.setParameter("setExpandTabs", expand, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatLeadingStarInComment() {
        return (Boolean)this.getParameter("getJavaFormatLeadingStarInComment", Boolean.FALSE);
    }

    void setJavaFormatLeadingStarInComment(boolean star) {
        this.setParameter("setJavaFormatLeadingStarInComment", star, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatSpaceBeforeParenthesis() {
        return (Boolean)this.getParameter("getJavaFormatSpaceBeforeParenthesis", Boolean.FALSE);
    }

    void setJavaFormatSpaceBeforeParenthesis(boolean space) {
        this.setParameter("setJavaFormatSpaceBeforeParenthesis", space, Boolean.TYPE);
        this.updateChanged();
    }

    boolean getJavaFormatNewlineBeforeBrace() {
        return (Boolean)this.getParameter("getJavaFormatNewlineBeforeBrace", Boolean.FALSE);
    }

    void setJavaFormatNewlineBeforeBrace(boolean newLine) {
        this.setParameter("setJavaFormatNewlineBeforeBrace", newLine, Boolean.TYPE);
        this.updateChanged();
    }

    Integer getJavaFormatStatementContinuationIndent() {
        return (Integer)this.getParameter("getJavaFormatStatementContinuationIndent", new Integer(4));
    }

    void setJavaFormatStatementContinuationIndent(Integer continuation) {
        if (continuation > 0) {
            this.setParameter("setJavaFormatStatementContinuationIndent", continuation, Integer.TYPE);
        }
        this.updateChanged();
    }

    Integer getSpacesPerTab() {
        return (Integer)this.getParameter("getSpacesPerTab", new Integer(4));
    }

    void setSpacesPerTab(Integer spaces) {
        if (spaces > 0) {
            this.setParameter("setSpacesPerTab", spaces, Integer.TYPE);
        }
        this.updateChanged();
    }

    boolean isChanged() {
        return this.changed;
    }

    void applyChanges() {
        this.applyParameterToAll("setJavaFormatLeadingStarInComment", this.getJavaFormatLeadingStarInComment(), Boolean.TYPE);
        this.applyParameterToAll("setJavaFormatNewlineBeforeBrace", this.getJavaFormatNewlineBeforeBrace(), Boolean.TYPE);
        this.applyParameterToAll("setJavaFormatSpaceBeforeParenthesis", this.getJavaFormatSpaceBeforeParenthesis(), Boolean.TYPE);
        this.applyParameterToAll("setJavaFormatStatementContinuationIndent", this.getJavaFormatStatementContinuationIndent(), Integer.TYPE);
        this.applyParameterToAll("setExpandTabs", this.isExpandTabs(), Boolean.TYPE);
        this.applyParameterToAll("setSpacesPerTab", this.getSpacesPerTab(), Integer.TYPE);
    }

    void revertChanges() {
        if (!this.changed) {
            return;
        }
        if (this.getJavaFormatLeadingStarInComment() != this.originalAddStar) {
            this.setJavaFormatLeadingStarInComment(this.originalAddStar);
        }
        if (this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine) {
            this.setJavaFormatNewlineBeforeBrace(this.originalNewLine);
        }
        if (this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace) {
            this.setJavaFormatSpaceBeforeParenthesis(this.originalSpace);
        }
        if (this.isExpandTabs() != this.originalExpandedTabs) {
            this.setExpandTabs(this.originalExpandedTabs);
        }
        if (this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent && this.originalStatementIndent > 0) {
            this.setJavaFormatStatementContinuationIndent(new Integer(this.originalStatementIndent));
        }
        if (this.getSpacesPerTab() != this.originalIndent && this.originalIndent > 0) {
            this.setSpacesPerTab(new Integer(this.originalIndent));
        }
    }

    private void updateChanged() {
        this.changed = this.isExpandTabs() != this.originalExpandedTabs || this.getJavaFormatLeadingStarInComment() != this.originalAddStar || this.getJavaFormatNewlineBeforeBrace() != this.originalNewLine || this.getJavaFormatSpaceBeforeParenthesis() != this.originalSpace || this.getJavaFormatStatementContinuationIndent() != this.originalStatementIndent || this.getSpacesPerTab() != this.originalIndent;
    }

    private IndentEngine getDefaultIndentEngine() {
        if (this.javaIndentEngine == null) {
            BaseOptions options = IndentationModel.getOptions("text/x-java");
            if (options == null) {
                options = IndentationModel.getOptions("text/plain");
            }
            this.javaIndentEngine = options == null ? null : options.getIndentEngine();
        }
        return this.javaIndentEngine;
    }

    private Object getParameter(String parameterName, Object defaultValue) {
        IndentEngine eng = this.getDefaultIndentEngine();
        if (eng != null) {
            try {
                Method method = eng.getClass().getMethod(parameterName, new Class[0]);
                return method.invoke((Object)eng, new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private void setParameter(String parameterName, Object parameterValue, Class parameterType) {
        IndentEngine eng = this.getDefaultIndentEngine();
        if (eng != null) {
            try {
                Method method = eng.getClass().getMethod(parameterName, parameterType);
                method.invoke((Object)eng, parameterValue);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void applyParameterToAll(String parameterName, Object parameterValue, Class parameterType) {
        HashSet<IndentEngine> mimeTypeBoundEngines = new HashSet<IndentEngine>();
        Set mimeTypes = EditorSettings.getDefault().getMimeTypes();
        for (String mimeType : mimeTypes) {
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            IndentEngine indentEngine = baseOptions.getIndentEngine();
            mimeTypeBoundEngines.add(indentEngine);
            try {
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.java.editor.options.JavaOptions") && !indentEngine.getClass().getName().equals("org.netbeans.modules.editor.java.JavaIndentEngine")) {
                    Class<?> javaIndentEngineClass = this.getClassLoader().loadClass("org.netbeans.modules.editor.java.JavaIndentEngine");
                    indentEngine = (IndentEngine)Lookup.getDefault().lookup(javaIndentEngineClass);
                    baseOptions.setIndentEngine(indentEngine);
                }
                if (baseOptions.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JSPOptions") && !indentEngine.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JspIndentEngine")) {
                    Class<?> jspIndentEngineClass = this.getClassLoader().loadClass("org.netbeans.modules.web.core.syntax.JspIndentEngine");
                    indentEngine = (IndentEngine)Lookup.getDefault().lookup(jspIndentEngineClass);
                    baseOptions.setIndentEngine(indentEngine);
                }
                Method method = indentEngine.getClass().getMethod(parameterName, parameterType);
                method.invoke((Object)indentEngine, parameterValue);
            }
            catch (Exception ex) {}
        }
        Collection allEngines = Lookup.getDefault().lookupAll(IndentEngine.class);
        for (IndentEngine indentEngine : allEngines) {
            if (mimeTypeBoundEngines.contains(indentEngine)) continue;
            try {
                Method method = indentEngine.getClass().getMethod(parameterName, parameterType);
                method.invoke((Object)indentEngine, parameterValue);
            }
            catch (Exception e) {}
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        }
        return this.classLoader;
    }

    private static BaseOptions getOptions(String mimeType) {
        return (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(BaseOptions.class);
    }
}

