/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.macros.MacrosModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MacrosPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private MacrosModel model;
    private boolean listen = true;
    private String currentMacro;
    private JButton bNew;
    private JButton bRemove;
    private JButton bSetShortcut;
    private JEditorPane epMacroCode;
    private JLabel lMacroCode;
    private JLabel lMacros;
    private JScrollPane sMacroCode;
    private JScrollPane spMacros;
    private JTable tMacros;
    private Lookup lookup;

    public MacrosPanel() {
        this.initComponents();
        this.tMacros.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macros_Table"));
        this.tMacros.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macros_Table"));
        this.epMacroCode.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macro"));
        this.epMacroCode.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macro"));
        this.bRemove.setEnabled(false);
        this.bSetShortcut.setEnabled(false);
        MacrosPanel.loc(this.bNew, "New_Macro");
        MacrosPanel.loc(this.bRemove, "Remove_Macro");
        MacrosPanel.loc(this.bSetShortcut, "Shortcut");
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.bSetShortcut.addActionListener(this);
        this.tMacros.getSelectionModel().setSelectionMode(0);
        this.tMacros.getSelectionModel().addListSelectionListener(this);
        this.tMacros.getTableHeader().setReorderingAllowed(false);
        this.epMacroCode.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        MacrosPanel.loc(this.lMacros, "Macro_List");
        this.lMacros.setLabelFor(this.tMacros);
        MacrosPanel.loc(this.lMacroCode, "Macro_Code");
        this.lMacroCode.setLabelFor(this.epMacroCode);
    }

    private void initComponents() {
        this.lMacros = new JLabel();
        this.spMacros = new JScrollPane();
        this.tMacros = new JTable();
        this.bNew = new JButton();
        this.bSetShortcut = new JButton();
        this.bRemove = new JButton();
        this.lMacroCode = new JLabel();
        this.sMacroCode = new JScrollPane();
        this.epMacroCode = new JEditorPane();
        this.lMacros.setText("Macros:");
        this.tMacros.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.spMacros.setViewportView(this.tMacros);
        this.bNew.setText("New");
        this.bSetShortcut.setText("Set Shortcut...");
        this.bRemove.setText("Remove");
        this.lMacroCode.setText("Macro Code:");
        this.sMacroCode.setViewportView(this.epMacroCode);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lMacros).add((Component)this.lMacroCode).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.sMacroCode, -1, 327, Short.MAX_VALUE).add((Component)this.spMacros, -1, 327, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.bNew, -1, 128, Short.MAX_VALUE).add((Component)this.bSetShortcut, -1, -1, Short.MAX_VALUE).add(1, (Component)this.bRemove, -1, -1, Short.MAX_VALUE)).add(13, 13, 13))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lMacros).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bNew).addPreferredGap(0).add((Component)this.bSetShortcut).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.spMacros, -2, 113, -2)).addPreferredGap(0).add((Component)this.lMacroCode).addPreferredGap(0).add((Component)this.sMacroCode, -1, 147, Short.MAX_VALUE)));
    }

    private static String loc(String key) {
        return NbBundle.getMessage(MacrosPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)MacrosPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)MacrosPanel.loc("CTL_" + key));
        }
    }

    public void update() {
        this.model = new MacrosModel(this.lookup);
        this.listen = false;
        DefaultTableModel tableModel = this.model.getShortcutsTableModel();
        this.currentMacro = null;
        tableModel.setColumnIdentifiers(new String[]{MacrosPanel.loc("Macro_Name_Title"), MacrosPanel.loc("Macro_Code_Title")});
        this.tMacros.setModel(tableModel);
        this.listen = true;
        if (this.model.getMacroNames().size() > 0) {
            this.tMacros.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void applyChanges() {
        this.saveCurrentMacro();
        if (this.model != null) {
            this.model.applyChanges();
        }
    }

    public void cancel() {
        if (this.model != null) {
            this.model.cancel();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.bNew) {
            NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(MacrosPanel.loc("CTL_Enter_macro_name"), MacrosPanel.loc("CTL_New_macro_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.InputLine.OK_OPTION) {
                String macroName = descriptor.getInputText().trim();
                if (macroName.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MacrosPanel.loc("CTL_Empty_Macro_Name"), 0));
                } else {
                    Iterator it = this.model.getMacroNames().iterator();
                    boolean duplicate = false;
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        if (!macroName.equals(name)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MacrosPanel.loc("CTL_Duplicate_Macro_Name"), 0));
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        this.listen = false;
                        this.model.addMacro(macroName, "");
                        this.listen = true;
                        this.tMacros.getSelectionModel().setSelectionInterval(0, 0);
                        this.spMacros.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MacrosPanel.this.epMacroCode.requestFocus();
                }
            });
        } else if (e.getSource() == this.bRemove) {
            int index = this.tMacros.getSelectedRow();
            this.listen = false;
            this.model.removeMacro(index);
            this.listen = true;
            this.currentMacro = null;
            if (index < this.tMacros.getModel().getRowCount()) {
                this.tMacros.getSelectionModel().setSelectionInterval(index, index);
            } else if (this.tMacros.getModel().getRowCount() > 0) {
                this.tMacros.getSelectionModel().setSelectionInterval(this.tMacros.getModel().getRowCount() - 1, this.tMacros.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
                this.bSetShortcut.setEnabled(false);
            }
        } else if (e.getSource() == this.bSetShortcut) {
            int index = this.tMacros.getSelectedRow();
            ShortcutsFinder f = (ShortcutsFinder)this.lookup.lookup(ShortcutsFinder.class);
            String shortcut = f.showShortcutsDialog();
            this.saveCurrentMacro();
            if (shortcut != null) {
                this.model.setShortcut(index, shortcut);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MacrosPanel.this.epMacroCode.requestFocus();
                }
            });
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.tMacros.getSelectedRow();
        if (index < 0) {
            this.epMacroCode.setText("");
            this.bRemove.setEnabled(false);
            this.bSetShortcut.setEnabled(false);
            return;
        }
        this.saveCurrentMacro();
        this.bRemove.setEnabled(true);
        this.bSetShortcut.setEnabled(true);
        String name = this.getCurrentMacro();
        String text = this.model.getMacroText(name);
        this.epMacroCode.setText(text);
        this.currentMacro = name;
    }

    private String getCurrentMacro() {
        int index = this.tMacros.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return (String)this.tMacros.getModel().getValueAt(index, 0);
    }

    private void saveCurrentMacro() {
        if (this.currentMacro == null) {
            return;
        }
        if (this.epMacroCode.getText().equals(this.model.getMacroText(this.currentMacro))) {
            return;
        }
        this.model.setMacroText(this.currentMacro, this.epMacroCode.getText());
        this.firePropertyChange("changed", null, null);
    }
}

