/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.tasklist.todo.Settings;
import org.netbeans.modules.tasklist.todo.SourceCodeCommentParser;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TodoTaskScanner
extends FileTaskScanner {
    private static final String GROUP_NAME = "nb-tasklist-todo";
    private Pattern regexp = null;
    private FileTaskScanner.Callback callback;

    TodoTaskScanner(String displayName, String description) {
        super(displayName, description, null);
    }

    public static TodoTaskScanner create() {
        return new TodoTaskScanner(NbBundle.getBundle(TodoTaskScanner.class).getString("LBL_todotask"), NbBundle.getBundle(TodoTaskScanner.class).getString("HINT_todotask"));
    }

    public List<? extends Task> scan(FileObject resource) {
        if (!this.isSupported(resource)) {
            return null;
        }
        if (Settings.getDefault().isScanCommentsOnly()) {
            return this.scanComments(resource);
        }
        return this.scanAll(resource);
    }

    private List<? extends Task> scanAll(FileObject resource) {
        List<? extends Task> tasks = null;
        try {
            String text = this.getContent(resource);
            int index = 0;
            int lineno = 1;
            int len = text.length();
            Matcher matcher = this.getScanRegexp().matcher(text);
            while (index < len && matcher.find(index)) {
                int begin;
                int end = matcher.end();
                int c = 97;
                int nonwhite = begin;
                for (begin = matcher.start(); begin >= index; --begin) {
                    char c2 = text.charAt(begin);
                    c = c2;
                    if (c2 == '\n') break;
                    if (c == 32 || c == 9) continue;
                    nonwhite = begin;
                }
                begin = nonwhite;
                nonwhite = end;
                while (end < len && (c = (int)text.charAt(end)) != 10 && c != 13) {
                    if (c != 32 && c != 9) {
                        nonwhite = end;
                    }
                    ++end;
                }
                for (int idx = index; idx <= begin; ++idx) {
                    if (text.charAt(idx) != '\n') continue;
                    ++lineno;
                }
                index = end;
                String description = ((Object)text.subSequence(begin, nonwhite + 1)).toString();
                Task task = Task.create((FileObject)resource, (String)GROUP_NAME, (String)description, (int)lineno);
                if (null == tasks) {
                    tasks = new LinkedList<Task>();
                }
                tasks.add((Task)task);
            }
        }
        catch (IOException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, null, e);
        }
        return null == tasks ? this.getEmptyList() : tasks;
    }

    private List<? extends Task> scanComments(FileObject resource) {
        String ext = resource.getExt().toLowerCase();
        String lineComment = Settings.getDefault().getLineComment(ext);
        String blockCommentStart = Settings.getDefault().getBlockCommentStart(ext);
        String blockCommentEnd = Settings.getDefault().getBlockCommentEnd(ext);
        SourceCodeCommentParser sccp = new SourceCodeCommentParser(lineComment, blockCommentStart, blockCommentEnd);
        List<? extends Task> tasks = null;
        try {
            String text = this.getContent(resource);
            sccp.setText(text);
            SourceCodeCommentParser.CommentRegion reg = new SourceCodeCommentParser.CommentRegion();
            Matcher matcher = this.getScanRegexp().matcher(text);
            int len = text.length();
            int lineno = 1;
            int index = 0;
            int idx = 0;
            if (!sccp.nextRegion(reg)) {
                return this.getEmptyList();
            }
            while (index < len && matcher.find(index)) {
                boolean goahead;
                int begin = matcher.start();
                int end = matcher.end();
                boolean toosoon = false;
                do {
                    goahead = true;
                    if (begin < reg.start) {
                        toosoon = true;
                        continue;
                    }
                    if (begin <= reg.stop) continue;
                    goahead = false;
                    if (sccp.nextRegion(reg)) continue;
                    return null == tasks ? this.getEmptyList() : tasks;
                } while (!goahead);
                if (toosoon) {
                    index = end;
                    continue;
                }
                int c = 97;
                int nonwhite = begin;
                while (begin >= index) {
                    char c2 = text.charAt(begin);
                    c = c2;
                    if (c2 == '\n') break;
                    if (c != 32 && c != 9) {
                        nonwhite = begin;
                    }
                    --begin;
                }
                begin = nonwhite;
                nonwhite = end;
                while (end < len && (c = (int)text.charAt(end)) != 10 && c != 13) {
                    if (c != 32 && c != 9) {
                        nonwhite = end;
                    }
                    ++end;
                }
                while (idx <= begin) {
                    if (text.charAt(idx) == '\n') {
                        ++lineno;
                    }
                    ++idx;
                }
                index = end;
                String description = ((Object)text.subSequence(begin, nonwhite + 1)).toString();
                Task task = Task.create((FileObject)resource, (String)GROUP_NAME, (String)description, (int)lineno);
                if (null == tasks) {
                    tasks = new LinkedList<Task>();
                }
                tasks.add((Task)task);
            }
        }
        catch (IOException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, null, e);
        }
        return null == tasks ? this.getEmptyList() : tasks;
    }

    private boolean isSupported(FileObject file) {
        if (null == file || file.isFolder()) {
            return false;
        }
        return Settings.getDefault().isExtensionSupported(file.getExt());
    }

    Pattern getScanRegexp() {
        if (this.regexp == null) {
            StringBuffer sb = new StringBuffer(200);
            Collection<String> patterns = Settings.getDefault().getPatterns();
            boolean needSeparator = false;
            for (String s : patterns) {
                if (needSeparator) {
                    sb.append('|');
                }
                needSeparator = true;
                int n = s.length();
                if (Character.isJavaIdentifierPart(s.charAt(0))) {
                    sb.append("\\W");
                }
                for (int j = 0; j < n; ++j) {
                    char c = s.charAt(j);
                    if (c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '?' || c == '*' || c == '+' || c == '!' || c == '|' || c == '\\' || c == '^' || c == '$') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                if (!Character.isJavaIdentifierPart(s.charAt(n - 1))) continue;
                sb.append("\\b");
            }
            try {
                this.regexp = Pattern.compile(sb.toString());
            }
            catch (PatternSyntaxException e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, null, e);
                return null;
            }
        }
        return this.regexp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(FileObject fileObject) throws IOException {
        char[] buf = new char[65536];
        StringBuffer sb = new StringBuffer();
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        BufferedReader r = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), charset));
        try {
            int len;
            while ((len = r.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            ((Reader)r).close();
        }
        return sb.toString();
    }

    private List<? extends Task> getEmptyList() {
        List res = Collections.emptyList();
        return res;
    }

    public void attach(FileTaskScanner.Callback callback) {
        this.callback = callback;
    }

    public void notifyPrepare() {
        this.getScanRegexp();
    }

    public void notifyFinish() {
        this.regexp = null;
    }
}

