/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.mimelookup.impl.FolderChildren;
import org.openide.filesystems.FileObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public final class CompoundFolderChildren {
    public static final String PROP_CHILDREN = "FolderChildren.PROP_CHILDREN";
    private static final String HIDDEN_SUFFIX = "_hidden";
    private static final String HIDDEN_ATTR_NAME = "hidden";
    private static final Logger LOG = Logger.getLogger(CompoundFolderChildren.class.getName());
    private final String LOCK = new String("CompoundFolderChildren.LOCK");
    private FolderChildren[] layers = null;
    private List children = Collections.EMPTY_LIST;
    private PCL listener = new PCL();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CompoundFolderChildren(String[] paths) {
        this(paths, true);
    }

    public CompoundFolderChildren(String[] paths, boolean includeSubfolders) {
        this.layers = new FolderChildren[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.layers[i] = new FolderChildren(paths[i], includeSubfolders);
            this.layers[i].addPropertyChangeListener(this.listener);
        }
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        String string = this.LOCK;
        synchronized (string) {
            return this.children;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent event = null;
        String string = this.LOCK;
        synchronized (string) {
            List sorted;
            HashMap<String, FileObject> visible = new HashMap<String, FileObject>();
            HashMap<String, FileObject> hidden = new HashMap<String, FileObject>();
            for (int i = 0; i < this.layers.length; ++i) {
                List layerKids = this.layers[i].getChildren();
                Iterator j = layerKids.iterator();
                while (j.hasNext()) {
                    FileObject f = (FileObject)j.next();
                    String name = this.realName(f);
                    if (this.isHidden(f) && !hidden.containsKey(name)) {
                        hidden.put(name, f);
                    }
                    if (hidden.containsKey(name) || visible.containsKey(name)) continue;
                    visible.put(name, f);
                }
            }
            HashMap<FileObject, HashSet<FileObject>> edges = new HashMap<FileObject, HashSet<FileObject>>();
            for (int i = 0; i < this.layers.length; ++i) {
                Map layerAttrs = this.layers[i].getFolderAttributes();
                Iterator j = layerAttrs.keySet().iterator();
                while (j.hasNext()) {
                    String attrName = (String)j.next();
                    Object attrValue = layerAttrs.get(attrName);
                    int slashIdx = attrName.indexOf(47);
                    if (slashIdx == -1 || !(attrValue instanceof Boolean)) continue;
                    String name1 = attrName.substring(0, slashIdx);
                    String name2 = attrName.substring(slashIdx + 1);
                    if (!((Boolean)attrValue).booleanValue()) {
                        String s = name1;
                        name1 = name2;
                        name2 = s;
                    }
                    FileObject from = (FileObject)visible.get(name1);
                    FileObject to = (FileObject)visible.get(name2);
                    if (from == null || to == null) continue;
                    HashSet<FileObject> vertices = (HashSet<FileObject>)edges.get(from);
                    if (vertices == null) {
                        vertices = new HashSet<FileObject>();
                        edges.put(from, vertices);
                    }
                    vertices.add(to);
                }
            }
            try {
                sorted = Utilities.topologicalSort(visible.values(), edges);
            }
            catch (TopologicalSortException e) {
                LOG.log(Level.WARNING, "Can't sort folder children.", e);
                sorted = e.partialSort();
            }
            if (!((Object)this.children).equals(sorted)) {
                event = new PropertyChangeEvent(this, PROP_CHILDREN, this.children, sorted);
                this.children = sorted;
            }
        }
        if (event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    private boolean isHidden(FileObject fo) {
        if (fo.getNameExt().endsWith(HIDDEN_SUFFIX)) {
            return true;
        }
        Enumeration e = fo.getAttributes();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (!HIDDEN_ATTR_NAME.equals(name) || !((value = fo.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private String realName(FileObject fo) {
        String nameExt = fo.getNameExt();
        if (nameExt.endsWith(HIDDEN_SUFFIX)) {
            return nameExt.substring(0, nameExt.length() - HIDDEN_SUFFIX.length());
        }
        return nameExt;
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() != null && "FolderChildren.PROP_CHILD_CHANGED".equals(evt.getPropertyName())) {
                CompoundFolderChildren.this.pcs.firePropertyChange(new PropertyChangeEvent(CompoundFolderChildren.this, CompoundFolderChildren.PROP_CHILDREN, null, null));
            } else {
                CompoundFolderChildren.this.rebuild();
            }
        }
    }
}

