/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;

public final class FolderChildren {
    public static final String PROP_CHILDREN = "FolderChildren.PROP_CHILDREN";
    public static final String PROP_CHILD_CHANGED = "FolderChildren.PROP_CHILD_CHANGED";
    public static final String PROP_ATTRIBUTES = "FolderChildren.PROP_ATTRIBUTES";
    private static final Logger LOG = Logger.getLogger(FolderChildren.class.getName());
    private String[] pathElement;
    private boolean includeSubfolders;
    private final String LOCK = new String("FolderChildren.LOCK");
    private FileObject currentFolder = null;
    private boolean isTargetFolder = false;
    private FolderListener listener = new FolderListener(this);
    private List children = Collections.EMPTY_LIST;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public FolderChildren(String path) {
        this(path, true);
    }

    public FolderChildren(String path, boolean includeSubfolders) {
        this.pathElement = path.split("/");
        this.includeSubfolders = includeSubfolders;
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        String string = this.LOCK;
        synchronized (string) {
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFolderAttributes() {
        String string = this.LOCK;
        synchronized (string) {
            if (!this.isTargetFolder) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            Enumeration e = this.currentFolder.getAttributes();
            while (e.hasMoreElements()) {
                String attrName = (String)e.nextElement();
                Object attrValue = this.currentFolder.getAttribute(attrName);
                if (attrs.containsKey(attrName)) continue;
                attrs.put(attrName, attrValue);
            }
            return attrs;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent event = null;
        String string = this.LOCK;
        synchronized (string) {
            List<FileObject> newChildren;
            Object[] result = this.findTarget(this.pathElement);
            FileObject f = (FileObject)result[0];
            boolean isTarget = (Boolean)result[1];
            if (f != this.currentFolder) {
                if (this.currentFolder != null) {
                    this.currentFolder.removeFileChangeListener((FileChangeListener)this.listener);
                }
                this.currentFolder = f;
                this.isTargetFolder = isTarget;
                LOG.finest("Setting currentFolder = '" + this.currentFolder.getPath() + "'");
                LOG.finest("Setting isTargetFolder = '" + this.isTargetFolder + "'");
                this.currentFolder.addFileChangeListener((FileChangeListener)this.listener);
            }
            if (this.isTargetFolder) {
                FileObject[] files = this.currentFolder.getChildren();
                newChildren = new ArrayList(files.length);
                for (int i = 0; i < files.length; ++i) {
                    if (!this.includeSubfolders && files[i].isFolder()) continue;
                    newChildren.add(files[i]);
                }
                newChildren = Collections.unmodifiableList(newChildren);
            } else {
                newChildren = Collections.EMPTY_LIST;
            }
            if (!((Object)this.children).equals(newChildren)) {
                event = new PropertyChangeEvent(this, PROP_CHILDREN, this.children, newChildren);
                this.children = newChildren;
            }
        }
        if (event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileContentChanged(FileObject file) {
        PropertyChangeEvent event = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.isTargetFolder) {
                event = new PropertyChangeEvent(this, PROP_CHILD_CHANGED, file, file);
            }
        }
        if (event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attributeChanged(FileObject file, String attribName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.isTargetFolder && this.currentFolder == file) {
                event = new PropertyChangeEvent(this, PROP_ATTRIBUTES, null, null);
            }
        }
        if (event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    private Object[] findTarget(String[] path) {
        FileObject f;
        FileObject target = Repository.getDefault().getDefaultFileSystem().getRoot();
        boolean isTarget = 0 == path.length;
        for (int i = 0; i < path.length && (f = target.getFileObject(path[i])) != null && f.isFolder() && f.isValid() && !f.isVirtual(); ++i) {
            target = f;
            isTarget = i + 1 == path.length;
        }
        return new Object[]{target, isTarget};
    }

    private static class FolderListener
    extends FileChangeAdapter {
        private WeakReference ref = null;

        public FolderListener(FolderChildren folderChildren) {
            this.ref = new WeakReference<FolderChildren>(folderChildren);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.handleRebuildEvent((FileEvent)fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.handleRebuildEvent(fe);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.handleRebuildEvent(fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            FolderChildren folderChildren = (FolderChildren)this.ref.get();
            if (folderChildren != null) {
                folderChildren.attributeChanged(fe.getFile(), fe.getName(), fe.getOldValue(), fe.getNewValue());
            } else {
                ((FileObject)fe.getSource()).removeFileChangeListener((FileChangeListener)this);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            this.handleRebuildEvent(fe);
        }

        public void fileChanged(FileEvent fe) {
            FolderChildren folderChildren = (FolderChildren)this.ref.get();
            if (folderChildren != null) {
                folderChildren.fileContentChanged(fe.getFile());
            } else {
                ((FileObject)fe.getSource()).removeFileChangeListener((FileChangeListener)this);
            }
        }

        private void handleRebuildEvent(FileEvent fe) {
            FolderChildren folderChildren = (FolderChildren)this.ref.get();
            if (folderChildren != null) {
                folderChildren.rebuild();
            } else {
                ((FileObject)fe.getSource()).removeFileChangeListener((FileChangeListener)this);
            }
        }
    }
}

