/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.mimelookup.impl.CompoundFolderChildren;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class FolderPathLookup
extends AbstractLookup {
    private static final Logger LOG = Logger.getLogger(FolderPathLookup.class.getName());
    private InstanceContent content;
    private CompoundFolderChildren children;
    private PCL listener = new PCL();
    private final String LOCK = new String("InstanceProviderLookup.LOCK");
    private final InstanceConvertor CONVERTOR = new InstanceConvertor();
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker;

    public FolderPathLookup(String[] paths) {
        this(paths, new InstanceContent());
    }

    private FolderPathLookup(String[] paths, InstanceContent content) {
        super((AbstractLookup.Content)content);
        this.content = content;
        this.children = new CompoundFolderChildren(paths, false);
        this.children.addPropertyChangeListener(this.listener);
        this.rebuild();
    }

    private void rebuild() {
        List files = this.children.getChildren();
        ArrayList<String> instanceFiles = new ArrayList<String>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            FileObject file = (FileObject)i.next();
            if (!file.isValid()) continue;
            try {
                DataObject d = DataObject.find((FileObject)file);
                InstanceCookie instanceCookie = (InstanceCookie)d.getCookie(class$org$openide$cookies$InstanceCookie == null ? FolderPathLookup.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie == null) continue;
                instanceFiles.add(file.getPath());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't create DataObject", e);
            }
        }
        this.content.set(instanceFiles, (InstanceContent.Convertor)this.CONVERTOR);
    }

    private static final class DeadMarker {
        public static final DeadMarker THIS = new DeadMarker();

        private DeadMarker() {
        }
    }

    private static final class InstanceConvertor
    implements InstanceContent.Convertor {
        private HashMap types = new HashMap();

        private InstanceConvertor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class type(Object filePath) {
            HashMap hashMap = this.types;
            synchronized (hashMap) {
                Class type;
                WeakReference ref = (WeakReference)this.types.get(filePath);
                Class clazz = type = ref == null ? null : (Class)ref.get();
                if (type == null) {
                    try {
                        type = this.getInstanceCookie(filePath).instanceClass();
                        this.types.put(filePath, new WeakReference<Class>(type));
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Can't determine instance class from '" + filePath + "'", e);
                        return class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker == null ? (class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker = FolderPathLookup.class$("org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup$DeadMarker")) : class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker;
                    }
                }
                return type;
            }
        }

        public String id(Object filePath) {
            return (String)filePath;
        }

        public String displayName(Object filePath) {
            try {
                return this.getInstanceCookie(filePath).instanceName();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't determine instance name from '" + filePath + "'", e);
                return (class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker == null ? (class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker = FolderPathLookup.class$("org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup$DeadMarker")) : class$org$netbeans$modules$editor$mimelookup$impl$FolderPathLookup$DeadMarker).getName();
            }
        }

        public Object convert(Object filePath) {
            try {
                return this.getInstanceCookie(filePath).instanceCreate();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't create instance from '" + filePath + "'", e);
                return DeadMarker.THIS;
            }
        }

        private InstanceCookie getInstanceCookie(Object filePath) throws IOException {
            FileObject file = Repository.getDefault().getDefaultFileSystem().findResource((String)filePath);
            if (file == null) {
                throw new IOException("The file does not exist '" + filePath + "'");
            }
            DataObject d = DataObject.find((FileObject)file);
            InstanceCookie cookie = (InstanceCookie)d.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = FolderPathLookup.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (cookie != null) {
                return cookie;
            }
            throw new IOException("Can't find InstanceCookie for '" + filePath + "'");
        }
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FolderPathLookup.this.rebuild();
        }
    }
}

