/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.mimelookup.impl.ClassInfoStorage;
import org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup;
import org.netbeans.modules.editor.mimelookup.impl.InstanceProviderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public class SwitchLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SwitchLookup.class.getName());
    static final String ROOT_FOLDER = "Editors";
    private MimePath mimePath;
    private final String LOCK = new String("SwitchLookup.LOCK");
    private MappingListener listener;
    private HashMap classLookups = new HashMap();
    private HashMap pathsLookups = new HashMap();
    private HashMap classInfos = new HashMap();
    private HashMap pathsToClasses = new HashMap();

    public SwitchLookup(MimePath mimePath) {
        this.mimePath = mimePath;
        this.listener = new MappingListener();
        ClassInfoStorage.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)ClassInfoStorage.getInstance()));
    }

    public Lookup.Result lookup(Lookup.Template template) {
        return this.findLookup(template.getType()).lookup(template);
    }

    public Object lookup(Class clazz) {
        return this.findLookup(clazz).lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup findLookup(Class clazz) {
        String string = this.LOCK;
        synchronized (string) {
            String className = clazz.getName();
            Object lookup = (Lookup)this.classLookups.get(className);
            if (lookup == null) {
                ClassInfoStorage.Info classInfo = ClassInfoStorage.getInstance().getInfo(className);
                this.classInfos.put(className, classInfo);
                Lookup innerLookup = this.createLookup(classInfo);
                lookup = new UpdatableProxyLookup(new Lookup[]{innerLookup});
                this.classLookups.put(className, lookup);
            }
            return lookup;
        }
    }

    private Lookup createLookup(ClassInfoStorage.Info classInfo) {
        Lookup lookup;
        List paths = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, classInfo.getExtraPath());
        if (classInfo.getInstanceProviderClass() != null) {
            lookup = this.getLookupForProvider(classInfo.getClassName(), paths, classInfo.getInstanceProvider());
        } else {
            HashSet<String> pathsUsers = (HashSet<String>)this.pathsToClasses.get(paths);
            if (pathsUsers == null) {
                pathsUsers = new HashSet<String>();
                this.pathsToClasses.put(paths, pathsUsers);
            }
            pathsUsers.add(classInfo.getClassName());
            lookup = this.getLookupForPaths(paths);
        }
        return lookup;
    }

    private Lookup getLookupForPaths(List paths) {
        Object lookup = (Lookup)this.pathsLookups.get(paths);
        if (lookup == null) {
            lookup = new FolderPathLookup(paths.toArray(new String[paths.size()]));
            this.pathsLookups.put(paths, lookup);
        }
        return lookup;
    }

    private Lookup getLookupForProvider(String className, List paths, InstanceProvider instanceProvider) {
        return new InstanceProviderLookup(paths.toArray(new String[paths.size()]), instanceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildLookup(String className) {
        String string = this.LOCK;
        synchronized (string) {
            ClassInfoStorage.Info classInfo;
            UpdatableProxyLookup classLookup = (UpdatableProxyLookup)((Object)this.classLookups.get(className));
            if (classLookup == null) {
                return;
            }
            ClassInfoStorage.Info currentClassInfo = (ClassInfoStorage.Info)this.classInfos.get(className);
            if (currentClassInfo.equals(classInfo = ClassInfoStorage.getInstance().getInfo(className))) {
                return;
            }
            if (currentClassInfo.getInstanceProviderClass() == null) {
                List currentPaths = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, currentClassInfo.getExtraPath());
                Set currentPathsUsers = (Set)this.pathsToClasses.get(currentPaths);
                currentPathsUsers.remove(className);
                if (currentPathsUsers.isEmpty()) {
                    this.pathsToClasses.remove(currentPaths);
                    this.pathsLookups.remove(currentPaths);
                }
            }
            this.classInfos.put(className, classInfo);
            Lookup innerLookup = this.createLookup(classInfo);
            classLookup.setLookupsEx(new Lookup[]{innerLookup});
        }
    }

    static List computePaths(MimePath mimePath, String prefixPath, String suffixPath) {
        ArrayList<String[]> arrays = new ArrayList<String[]>(mimePath.size());
        String innerMimeType = null;
        if (mimePath.size() > 1) {
            innerMimeType = mimePath.getMimeType(mimePath.size() - 1);
        }
        for (int i = mimePath.size(); i >= 0; --i) {
            String mimeType;
            String genericMimeType;
            MimePath currentPath = mimePath.getPrefix(i);
            if (currentPath.size() != 1 || innerMimeType == null || !currentPath.getMimeType(0).equals(innerMimeType)) {
                arrays.add(SwitchLookup.split(currentPath));
            }
            if (currentPath.size() <= 0 || (genericMimeType = SwitchLookup.getGenericPartOfCompoundMimeType(mimeType = currentPath.getMimeType(currentPath.size() - 1))) == null) continue;
            List genericPaths = SwitchLookup.forkPaths(arrays, genericMimeType, i - 1);
            arrays.addAll(genericPaths);
        }
        if (innerMimeType != null) {
            arrays.add(1, new String[]{innerMimeType});
            String genericInnerMimeType = SwitchLookup.getGenericPartOfCompoundMimeType(innerMimeType);
            if (genericInnerMimeType != null) {
                arrays.add(2, new String[]{genericInnerMimeType});
            }
        }
        ArrayList<String> paths = new ArrayList<String>(arrays.size());
        Iterator i = arrays.iterator();
        while (i.hasNext()) {
            String[] path = (String[])i.next();
            StringBuffer sb = new StringBuffer(10 * path.length + 20);
            if (prefixPath != null && prefixPath.length() > 0) {
                sb.append(prefixPath);
            }
            for (int ii = 0; ii < path.length; ++ii) {
                if (path[ii].length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(path[ii]);
            }
            if (suffixPath != null && suffixPath.length() > 0) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(suffixPath);
            }
            paths.add(sb.toString());
        }
        return paths;
    }

    static String getGenericPartOfCompoundMimeType(String mimeType) {
        int plusIdx = mimeType.lastIndexOf(43);
        if (plusIdx != -1 && plusIdx < mimeType.length() - 1) {
            int slashIdx = mimeType.indexOf(47);
            String prefix = mimeType.substring(0, slashIdx + 1);
            String suffix = mimeType.substring(plusIdx + 1);
            if (suffix.equals("xml")) {
                prefix = "text/";
            }
            return prefix + suffix;
        }
        return null;
    }

    private static String[] split(MimePath mimePath) {
        String[] array = new String[mimePath.size()];
        for (int i = 0; i < mimePath.size(); ++i) {
            array[i] = mimePath.getMimeType(i);
        }
        return array;
    }

    private static List forkPaths(List paths, String genericMimeType, int elementIdx) {
        ArrayList<String[]> forkedPaths = new ArrayList<String[]>(paths.size());
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            String[] path = (String[])i.next();
            String[] forkedPath = new String[path.length];
            for (int ii = 0; ii < path.length; ++ii) {
                forkedPath[ii] = ii != elementIdx ? path[ii] : genericMimeType;
            }
            forkedPaths.add(forkedPath);
        }
        return forkedPaths;
    }

    private final class MappingListener
    implements PropertyChangeListener {
        private MappingListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Set classNames = (Set)evt.getNewValue();
            Iterator i = classNames.iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                SwitchLookup.this.rebuildLookup(className);
            }
        }
    }

    private static final class UpdatableProxyLookup
    extends ProxyLookup {
        public UpdatableProxyLookup() {
        }

        public UpdatableProxyLookup(Lookup[] lookups) {
            super(lookups);
        }

        public void setLookupsEx(Lookup[] lookups) {
            this.setLookups(lookups);
        }
    }
}

