/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.editorbridge;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.lexer.editorbridge.LexerLayer;
import org.openide.filesystems.FileObject;

public class LexerEditorKit
extends NbEditorKit {
    public static final String tokenListDebugAction = "token-list-debug";
    public static final String UNKNOWN_MIME_TYPE = "text/x-unknown";
    private String mimeType;

    public static LexerEditorKit create(FileObject fo) {
        String mimeType = UNKNOWN_MIME_TYPE;
        String path = (fo = fo.getParent()).getPath();
        if (path.startsWith("Editors/")) {
            mimeType = path.substring("Editors/".length());
        }
        return new LexerEditorKit(mimeType);
    }

    public LexerEditorKit(String mimeType) {
        this.mimeType = mimeType;
    }

    public LexerEditorKit() {
    }

    public String getContentType() {
        return this.mimeType;
    }

    public void install(JEditorPane pane) {
        super.install(pane);
        TextUI ui = pane.getUI();
        if (ui instanceof BaseTextUI) {
            ((BaseTextUI)ui).getEditorUI().addLayer((DrawLayer)new LexerLayer(pane), 1050);
        }
    }

    public Syntax createSyntax(Document doc) {
        return new PlainSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new ExtSyntaxSupport(doc);
    }

    protected Action[] createActions() {
        Action[] calcActions = new Action[]{new TokenListDebugAction()};
        return TextAction.augmentList(super.createActions(), calcActions);
    }

    protected String updateColoringName(String coloringName) {
        return coloringName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        KeyBindingSettings allKbs;
        KeyBindingSettings textBaseKbs;
        MultiKeymap km = new MultiKeymap("Keymap for " + this.mimeType);
        Map actionsMap = this.getActionMapHack();
        KeyBindingSettings kbs = (KeyBindingSettings)MimeLookup.getMimeLookup((String)this.mimeType).lookup(KeyBindingSettings.class);
        if (kbs != null) {
            List keybindings = kbs.getKeyBindings();
            JTextComponent.KeyBinding[] bindings = this.transform(keybindings);
            km.load(bindings, actionsMap);
        }
        if ((textBaseKbs = (KeyBindingSettings)MimeLookup.getMimeLookup((String)"text/base").lookup(KeyBindingSettings.class)) != null) {
            List keybindings = textBaseKbs.getKeyBindings();
            JTextComponent.KeyBinding[] bindings = this.transform(keybindings);
            km.load(bindings, actionsMap);
        }
        if ((allKbs = (KeyBindingSettings)MimeLookup.getMimeLookup((String)"").lookup(KeyBindingSettings.class)) != null) {
            List keybindings = allKbs.getKeyBindings();
            JTextComponent.KeyBinding[] bindings = this.transform(keybindings);
            km.load(bindings, actionsMap);
        }
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Settings.KitAndValue[] kv = Settings.getValueHierarchy(((Object)((Object)this)).getClass(), (String)"key-bindings");
            for (int i = kv.length - 1; i >= 0; --i) {
                List keyList = (List)kv[i].value;
                JTextComponent.KeyBinding[] keys = new JTextComponent.KeyBinding[keyList.size()];
                keyList.toArray(keys);
                km.load(keys, actionsMap);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            km.setDefaultAction((Action)actionsMap.get("default-typed"));
            return km;
        }
    }

    private JTextComponent.KeyBinding[] transform(List keybindings) {
        ArrayList<org.netbeans.editor.MultiKeyBinding> jtcKeyBindings = new ArrayList<org.netbeans.editor.MultiKeyBinding>(keybindings.size());
        for (MultiKeyBinding esMkb : keybindings) {
            org.netbeans.editor.MultiKeyBinding editorMkb;
            if (0 == esMkb.getKeyStrokeCount()) continue;
            if (1 == esMkb.getKeyStrokeCount()) {
                editorMkb = new org.netbeans.editor.MultiKeyBinding(esMkb.getKeyStroke(0), esMkb.getActionName());
            } else {
                KeyStroke[] keyStrokes = esMkb.getKeyStrokeList().toArray(new KeyStroke[esMkb.getKeyStrokeList().size()]);
                editorMkb = new org.netbeans.editor.MultiKeyBinding(keyStrokes, esMkb.getActionName());
            }
            jtcKeyBindings.add(editorMkb);
        }
        return jtcKeyBindings.toArray(new JTextComponent.KeyBinding[jtcKeyBindings.size()]);
    }

    private Map getActionMapHack() {
        try {
            Method m = BaseKit.class.getDeclaredMethod("getActionMap", new Class[0]);
            m.setAccessible(true);
            return (Map)m.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class TokenListDebugAction
    extends BaseAction {
        public TokenListDebugAction() {
            super(LexerEditorKit.tokenListDebugAction, 0);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            TokenHierarchy hi = TokenHierarchy.get((Document)target.getDocument());
            if (hi != null) {
                System.err.println("Token list:\n" + hi.tokenSequence());
            } else {
                System.err.println("Token hierarchy is null.");
            }
        }
    }
}

