/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.copy.CreateCopyAction;
import org.netbeans.modules.subversion.ui.copy.MergeAction;
import org.netbeans.modules.subversion.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.diff.ExportDiffAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.project.ImportAction;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesAction;
import org.netbeans.modules.subversion.ui.relocate.RelocateAction;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsAction;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.ui.update.UpdateWithDependenciesAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Annotator {
    private static MessageFormat uptodateFormat = Annotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = Annotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = Annotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = Annotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = Annotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = Annotator.getFormat("deletedLocallyFormat");
    private static MessageFormat newInRepositoryFormat = Annotator.getFormat("newInRepositoryFormat");
    private static MessageFormat modifiedInRepositoryFormat = Annotator.getFormat("modifiedInRepositoryFormat");
    private static MessageFormat removedInRepositoryFormat = Annotator.getFormat("removedInRepositoryFormat");
    private static MessageFormat conflictFormat = Annotator.getFormat("conflictFormat");
    private static MessageFormat mergeableFormat = Annotator.getFormat("mergeableFormat");
    private static MessageFormat excludedFormat = Annotator.getFormat("excludedFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    public static String ANNOTATION_REVISION = "revision";
    public static String ANNOTATION_STATUS = "status";
    public static String ANNOTATION_FOLDER = "folder";
    public static String ANNOTATION_MIME_TYPE = "mime_type";
    public static String[] LABELS = new String[]{ANNOTATION_REVISION, ANNOTATION_STATUS, ANNOTATION_FOLDER, ANNOTATION_MIME_TYPE};
    private final FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private boolean mimeTypeFlag;
    private static final int STATUS_BADGEABLE = 28;

    Annotator(Subversion svn) {
        this.cache = svn.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fields = Annotator.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.endsWith("Format")) continue;
            this.initDefaultColor(name.substring(0, name.length() - 6));
        }
        this.refresh();
    }

    public void refresh() {
        String string = SvnModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            this.mimeTypeFlag = string.indexOf("{mime_type}") > -1;
            string = string.replaceAll("\\{revision\\}", "\\{0\\}");
            string = string.replaceAll("\\{status\\}", "\\{1\\}");
            string = string.replaceAll("\\{folder\\}", "\\{2\\}");
            string = string.replaceAll("\\{mime_type\\}", "\\{3\\}");
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
    }

    private void initDefaultColor(String name) {
        String color = System.getProperty("svn.color." + name);
        if (color == null) {
            return;
        }
        this.setAnnotationColor(name, color);
    }

    private void setAnnotationColor(String name, String colorString) {
        try {
            Field field = Annotator.class.getDeclaredField(name + "Format");
            MessageFormat format = new MessageFormat("<font color=\"" + colorString + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    public String annotateNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        String textAnnotationFormat = SvnModuleConfig.getDefault().getPreferences().get("textAnnotations", null);
        if (textAnnotationFormat != null && file != null && (status & 0x195E) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(info, file);
            } else {
                String statusText;
                String sticky = SvnUtils.getCopy(file);
                textAnnotation = status == 8 && sticky == null ? "" : (status == 8 ? " [" + sticky + "]" : (sticky == null ? (!(statusText = info.getShortStatusText()).equals("") ? " [" + info.getShortStatusText() + "]" : "") : " [" + info.getShortStatusText() + "; " + sticky + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        if (0 != (status & 0x40)) {
            return conflictFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x80)) {
            return mergeableFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x800)) {
            return deletedLocallyFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x100)) {
            return removedLocallyFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 4)) {
            return newLocallyFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x1000)) {
            return addedLocallyFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x10)) {
            return modifiedLocallyFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x400)) {
            return removedInRepositoryFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x200)) {
            return newInRepositoryFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x20)) {
            return modifiedInRepositoryFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 8)) {
            return uptodateFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 2)) {
            return excludedFormat.format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 1)) {
            return name;
        }
        if (status == 0) {
            return name;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    private String formatAnnotation(FileInformation info, File file) {
        Object[] arguments;
        String annotation;
        String stickyString;
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        String revisionString = "";
        String binaryString = "";
        ISVNStatus snvStatus = info.getEntry(file);
        if (snvStatus != null) {
            revisionString = snvStatus.getRevision().toString();
            if (this.mimeTypeFlag) {
                binaryString = this.getMimeType(file);
            }
        }
        if ((stickyString = SvnUtils.getCopy(file)) == null) {
            stickyString = "";
        }
        if ((annotation = this.format.format(arguments = new Object[]{revisionString, statusString, stickyString, binaryString}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + annotation;
    }

    private String getMimeType(File file) {
        try {
            SvnClient client = Subversion.getInstance().getClient(false);
            ISVNProperty prop = client.propertyGet(file, "svn:mime-type");
            if (prop != null) {
                String mime = prop.getValue();
                return mime != null ? mime : "";
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            return "";
        }
        return "";
    }

    private String annotateFolderNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        String textAnnotationFormat = SvnModuleConfig.getDefault().getPreferences().get("textAnnotations", null);
        if (textAnnotationFormat != null && file != null && (status & 0xFFFFFFFE) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(info, file);
            } else {
                String statusText;
                ISVNStatus lstatus = info.getEntry(file);
                String sticky = lstatus != null && lstatus.getUrl() != null ? SvnUtils.getCopy(lstatus.getUrl()) : SvnUtils.getCopy(file);
                textAnnotation = status == 8 && sticky == null ? "" : (status == 8 ? " [" + sticky + "]" : (sticky == null ? (!(statusText = info.getShortStatusText()).equals("") ? " [" + info.getShortStatusText() + "]" : "") : " [" + info.getShortStatusText() + "; " + sticky + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        if (status == 0) {
            return name;
        }
        if (Annotator.match(status, 256)) {
            return name;
        }
        if (Annotator.match(status, 4)) {
            return uptodateFormat.format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 4096)) {
            return uptodateFormat.format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 8)) {
            return uptodateFormat.format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 2)) {
            return excludedFormat.format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 2048)) {
            return name;
        }
        if (Annotator.match(status, 512)) {
            return name;
        }
        if (Annotator.match(status, 32)) {
            return name;
        }
        if (Annotator.match(status, 1024)) {
            return name;
        }
        if (Annotator.match(status, 1)) {
            return name;
        }
        if (Annotator.match(status, 128)) {
            return name;
        }
        if (Annotator.match(status, 16)) {
            return name;
        }
        if (Annotator.match(status, 64)) {
            return name;
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    public String annotateNameHtml(String name, VCSContext context, int includeStatus) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            int status = info.getStatus();
            if ((status & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = file.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.shareCommonDataObject((File[])context.getRootFiles().toArray(new File[context.getRootFiles().size()]));
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return SvnUtils.getComparableStatus(a.getStatus()) < SvnUtils.getComparableStatus(b.getStatus());
    }

    String annotateName(String name, Set files) {
        return null;
    }

    public static Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination destination) {
        ResourceBundle loc = NbBundle.getBundle(Annotator.class);
        Node[] nodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        File[] files = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
        Lookup context = ctx.getElements();
        boolean noneVersioned = Annotator.isNothingVersioned(files);
        boolean onlyFolders = Annotator.onlyFolders(files);
        boolean onlyProjects = Annotator.onlyProjects(nodes);
        ArrayList<Object> actions = new ArrayList<Object>(20);
        if (destination == VCSAnnotator.ActionDestination.MainMenu) {
            actions.add(SystemAction.get(CheckoutAction.class));
            actions.add(SystemAction.get(ImportAction.class));
            actions.add(SystemAction.get(RelocateAction.class));
            actions.add(null);
            actions.add(SystemAction.get(UpdateWithDependenciesAction.class));
            actions.add(null);
            actions.add(SystemAction.get(StatusAction.class));
            actions.add(SystemAction.get(DiffAction.class));
            actions.add(SystemAction.get(UpdateAction.class));
            actions.add(SystemAction.get(CommitAction.class));
            actions.add(null);
            actions.add(SystemAction.get(ExportDiffAction.class));
            actions.add(null);
            actions.add(SystemAction.get(CreateCopyAction.class));
            actions.add(SystemAction.get(SwitchToAction.class));
            actions.add(SystemAction.get(MergeAction.class));
            actions.add(null);
            actions.add(SystemAction.get(BlameAction.class));
            actions.add(SystemAction.get(SearchHistoryAction.class));
            actions.add(null);
            actions.add(SystemAction.get(RevertModificationsAction.class));
            actions.add(SystemAction.get(ResolveConflictsAction.class));
            actions.add(SystemAction.get(IgnoreAction.class));
            actions.add(null);
            actions.add(SystemAction.get(SvnPropertiesAction.class));
        } else if (noneVersioned) {
            actions.add(SystemActionBridge.createAction((Action)((ImportAction)SystemAction.get(ImportAction.class)).createContextAwareInstance(context), (String)loc.getString("CTL_PopupMenuItem_Import"), (Lookup)context));
        } else {
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)loc.getString("CTL_PopupMenuItem_Status"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)loc.getString("CTL_PopupMenuItem_Diff"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(UpdateAction.class), (String)loc.getString("CTL_PopupMenuItem_Update"), (Lookup)context));
            if (onlyProjects) {
                actions.add(new SystemActionBridge((Action)SystemAction.get(UpdateWithDependenciesAction.class), loc.getString("CTL_PopupMenuItem_UpdateWithDeps")));
            }
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)loc.getString("CTL_PopupMenuItem_Commit"), (Lookup)context));
            actions.add(null);
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CreateCopyAction.class), (String)loc.getString("CTL_PopupMenuItem_Copy"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SwitchToAction.class), (String)loc.getString("CTL_PopupMenuItem_Switch"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(MergeAction.class), (String)loc.getString("CTL_PopupMenuItem_Merge"), (Lookup)context));
            actions.add(null);
            if (!onlyFolders) {
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(BlameAction.class), (String)(((BlameAction)SystemAction.get(BlameAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)context));
            }
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)loc.getString("CTL_PopupMenuItem_SearchHistory"), (Lookup)context));
            actions.add(null);
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(RevertModificationsAction.class), (String)loc.getString("CTL_PopupMenuItem_GetClean"), (Lookup)context));
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)loc.getString("CTL_PopupMenuItem_ResolveConflicts"), (Lookup)context));
            if (!onlyProjects) {
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)(((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(nodes) == 2 ? loc.getString("CTL_PopupMenuItem_Unignore") : loc.getString("CTL_PopupMenuItem_Ignore")), (Lookup)context));
            }
            actions.add(null);
            actions.add(SystemActionBridge.createAction((Action)SystemAction.get(SvnPropertiesAction.class), (String)loc.getString("CTL_PopupMenuItem_Properties"), (Lookup)context));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private static boolean isNothingVersioned(File[] files) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (File file : files) {
            if ((cache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProjects(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyFolders(File[] files) {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                return false;
            }
            if (files[i].exists() || cache.getStatus(files[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static MessageFormat getFormat(String key) {
        String format = NbBundle.getMessage(Annotator.class, (String)key);
        return new MessageFormat(format);
    }

    public Image annotateIcon(Image icon, VCSContext context) {
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.shareCommonDataObject((File[])context.getRootFiles().toArray(new File[context.getRootFiles().size()]));
        }
        if (!folderAnnotation) {
            return null;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        boolean isVersioned = false;
        for (File file : context.getRootFiles()) {
            if ((cache.getStatus(file).getStatus() & 0x1C) == 0) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return null;
        }
        SvnModuleConfig config = SvnModuleConfig.getDefault();
        boolean allExcluded = true;
        boolean modified = false;
        Map<File, FileInformation> map = cache.getAllModifiedFiles();
        HashMap<File, FileInformation> modifiedFiles = new HashMap<File, FileInformation>();
        for (File file : map.keySet()) {
            FileInformation info = map.get(file);
            if ((info.getStatus() & 0x19D4) == 0) continue;
            modifiedFiles.put(file, info);
        }
        for (File file : context.getRootFiles()) {
            int status;
            FileInformation info;
            if (VersioningSupport.isFlat((File)file)) {
                for (File mf : modifiedFiles.keySet()) {
                    if (!mf.getParentFile().equals(file) || (info = (FileInformation)modifiedFiles.get(mf)).isDirectory()) continue;
                    status = info.getStatus();
                    if (status == 64) {
                        Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                    }
                    modified = true;
                    allExcluded &= config.isExcludedFromCommit(mf.getAbsolutePath());
                }
                continue;
            }
            for (File mf : modifiedFiles.keySet()) {
                if (!Utils.isAncestorOrEqual((File)file, (File)mf) || ((status = (info = (FileInformation)modifiedFiles.get(mf)).getStatus()) == 4 || status == 4096) && file.equals(mf)) continue;
                if (status == 64) {
                    Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                }
                modified = true;
                allExcluded &= config.isExcludedFromCommit(mf.getAbsolutePath());
            }
        }
        if (modified && !allExcluded) {
            Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return null;
    }
}

