/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.DiskMapTurboProvider;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCache
implements ISVNNotifyListener {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final ISVNStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final Pattern auxConflictPattern = Pattern.compile("(.*?)\\.((r\\d+)|(mine)|(working)|(merge-right\\.r\\d+)|((merge-left.r\\d+)))$");
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "subversion.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private Subversion svn;
    private Set<FileSystem> filesystemsToRefresh;
    private RequestProcessor.Task refreshFilesystemsTask;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache() {
        this.svn = Subversion.getInstance();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    public File[] listFiles(File dir) {
        Set<File> files = this.getScannedFiles(dir).keySet();
        return files.toArray(new File[files.size()]);
    }

    public File[] listFiles(Context context, int includeStatus) {
        HashSet<File> set = new HashSet<File>();
        Map<File, FileInformation> allFiles = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : allFiles.keySet()) {
            FileInformation info = allFiles.get(file);
            if ((info.getStatus() & includeStatus) == 0) continue;
            File[] roots = context.getRootFiles();
            for (int j = 0; j < roots.length; ++j) {
                File root = roots[j];
                if (VersioningSupport.isFlat((File)root)) {
                    if (!file.equals(root) && !file.getParentFile().equals(root)) continue;
                    set.add(file);
                    continue block0;
                }
                if (!SvnUtils.isParentOrEqual(root, file)) continue;
                set.add(file);
                continue block0;
            }
        }
        if (context.getExclusions().size() > 0) {
            for (File excluded : context.getExclusions()) {
                Iterator j = set.iterator();
                while (j.hasNext()) {
                    File file = (File)j.next();
                    if (!SvnUtils.isParentOrEqual(excluded, file)) continue;
                    j.remove();
                }
            }
        }
        return set.toArray(new File[set.size()]);
    }

    public File[] listFiles(File[] roots, int includeStatus) {
        HashSet<File> set = new HashSet<File>();
        Map<File, FileInformation> allFiles = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : allFiles.keySet()) {
            FileInformation info = allFiles.get(file);
            if ((info.getStatus() & includeStatus) == 0) continue;
            for (int j = 0; j < roots.length; ++j) {
                File root = roots[j];
                if (VersioningSupport.isFlat((File)root)) {
                    if (!file.getParentFile().equals(root)) continue;
                    set.add(file);
                    continue block0;
                }
                if (!SvnUtils.isParentOrEqual(root, file)) continue;
                set.add(file);
                continue block0;
            }
        }
        return set.toArray(new File[set.size()]);
    }

    public FileInformation getStatus(File file) {
        if (this.svn.isAdministrative(file)) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File dir = file.getParentFile();
        if (dir == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> files = this.getScannedFiles(dir);
        if (files == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fi = files.get(file);
        if (fi != null) {
            return fi;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    FileInformation getCachedStatus(File file) {
        if ((file = file.getParentFile()) == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map files = (Map)this.turbo.readEntry((Object)file, "subversion.STATUS_MAP");
        return files != null ? (FileInformation)files.get(file) : null;
    }

    private FileInformation refresh(File file, ISVNStatus repositoryStatus, boolean forceChangeEvent) {
        ISVNStatus status;
        FileInformation current;
        Map<File, FileInformation> files;
        File dir;
        block16: {
            dir = file.getParentFile();
            if (dir == null) {
                return FILE_INFORMATION_NOTMANAGED;
            }
            files = this.getScannedFiles(dir);
            if (files == NOT_MANAGED_MAP && repositoryStatus == REPOSITORY_STATUS_UNKNOWN) {
                return FILE_INFORMATION_NOTMANAGED;
            }
            current = files.get(file);
            status = null;
            try {
                SvnClient client = Subversion.getInstance().getClient(false);
                status = client.getSingleStatus(file);
                if (status != null && SVNStatusKind.UNVERSIONED.equals((Object)status.getTextStatus())) {
                    status = null;
                }
            }
            catch (SVNClientException e) {
                if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage())) break block16;
                SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
            }
        }
        FileInformation fi = this.createFileInformation(file, status, repositoryStatus);
        if (FileStatusCache.equivalent(fi, current)) {
            if (forceChangeEvent) {
                this.fireFileStatusChanged(file, current, fi);
            }
            return fi;
        }
        if (current == null && !fi.isDirectory() && fi.getStatus() == 8) {
            if (forceChangeEvent) {
                this.fireFileStatusChanged(file, current, fi);
            }
            return fi;
        }
        file = FileUtil.normalizeFile((File)file);
        dir = FileUtil.normalizeFile((File)dir);
        HashMap<File, FileInformation> newFiles = new HashMap<File, FileInformation>(files);
        if (fi.getStatus() == 0) {
            newFiles.remove(file);
            this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", null);
        } else if (fi.getStatus() == 8 && file.isFile()) {
            newFiles.remove(file);
        } else {
            newFiles.put(file, fi);
        }
        assert (!newFiles.containsKey(dir));
        this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", newFiles.size() == 0 ? null : newFiles);
        if (file.isDirectory() && this.needRecursiveRefresh(fi, current)) {
            File[] content = this.listFiles(file);
            for (int i = 0; i < content.length; ++i) {
                this.refresh(content[i], REPOSITORY_STATUS_UNKNOWN);
            }
        }
        this.fireFileStatusChanged(file, current, fi);
        return fi;
    }

    public FileInformation refresh(File file, ISVNStatus repositoryStatus) {
        return this.refresh(file, repositoryStatus, false);
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        ISVNStatus e2;
        if (other == null || main.getStatus() != other.getStatus() || main.isDirectory() != other.isDirectory()) {
            return false;
        }
        ISVNStatus e1 = main.getEntry(null);
        return e1 == (e2 = other.getEntry(null)) || e1 == null || e2 == null || FileStatusCache.equal(e1, e2);
    }

    private static boolean equal(ISVNStatus e1, ISVNStatus e2) {
        long r1 = -1L;
        if (e1 != null) {
            SVNRevision.Number r = e1.getRevision();
            r1 = r != null ? e1.getRevision().getNumber() : r1;
        }
        long r2 = -2L;
        if (e2 != null) {
            SVNRevision.Number r = e1.getRevision();
            long l = r2 = r != null ? e2.getRevision().getNumber() : r2;
        }
        if (r1 != r2) {
            return false;
        }
        return e1.getUrl() == e2.getUrl() || e1.getUrl() != null && e1.getUrl().equals((Object)e2.getUrl());
    }

    private boolean needRecursiveRefresh(FileInformation fi, FileInformation current) {
        if (fi.getStatus() == 2 || current != null && current.getStatus() == 2) {
            return true;
        }
        return fi.getStatus() == 1 || current != null && current.getStatus() == 1;
    }

    public void refreshCached(File file, ISVNStatus repositoryStatus) {
        this.refresh(file, repositoryStatus);
    }

    public void refreshCached(Context ctx) {
        File[] files = this.listFiles(ctx, -1);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            this.refreshCached(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    Map<File, FileInformation> getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    void directoryContentChanged(File dir) {
        Map originalFiles = (Map)this.turbo.readEntry((Object)dir, "subversion.STATUS_MAP");
        if (originalFiles != null) {
            for (File file : originalFiles.keySet()) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    void cleanUp() {
        Map<File, FileInformation> files = this.cacheProvider.getAllModifiedValues();
        for (File file : files.keySet()) {
            FileInformation info = files.get(file);
            if ((info.getStatus() & 0x19D4) != 0) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                continue;
            }
            if (info.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    private Map<File, FileInformation> getScannedFiles(File dir) {
        if (this.svn.isAdministrative(dir)) {
            return NOT_MANAGED_MAP;
        }
        File parent = dir.getParentFile();
        if (parent != null && this.svn.isAdministrative(parent)) {
            return NOT_MANAGED_MAP;
        }
        Map<File, FileInformation> files = (Map<File, FileInformation>)this.turbo.readEntry((Object)dir, "subversion.STATUS_MAP");
        if (files != null) {
            return files;
        }
        if (this.isNotManagedByDefault(dir)) {
            return NOT_MANAGED_MAP;
        }
        dir = FileUtil.normalizeFile((File)dir);
        files = this.scanFolder(dir);
        assert (!files.containsKey(dir));
        this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", files);
        for (File file : files.keySet()) {
            FileInformation info = files.get(file);
            if ((info.getStatus() & 0x19D4) == 0) continue;
            this.fireFileStatusChanged(file, null, info);
        }
        return files;
    }

    private boolean isNotManagedByDefault(File dir) {
        return !dir.exists();
    }

    private Map<File, FileInformation> scanFolder(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        HashMap<File, FileInformation> folderFiles = new HashMap<File, FileInformation>(files.length);
        ISVNStatus[] entries = null;
        try {
            SvnClient client = Subversion.getInstance().getClient(true);
            if (Subversion.getInstance().isManaged(dir)) {
                entries = client.getStatus(dir, false, false);
            }
        }
        catch (SVNClientException e) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
        }
        if (entries == null) {
            for (int i = 0; i < files.length; ++i) {
                FileInformation fi;
                File file = files[i];
                if (this.svn.isAdministrative(file) || !(fi = this.createFileInformation(file, null, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(file, fi);
            }
        } else {
            HashSet<File> localFiles = new HashSet<File>(Arrays.asList(files));
            for (int i = 0; i < entries.length; ++i) {
                FileInformation fi;
                ISVNStatus entry = entries[i];
                File file = new File(entry.getPath());
                if (file.equals(dir)) continue;
                localFiles.remove(file);
                if (this.svn.isAdministrative(file) || !(fi = this.createFileInformation(file, entry, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(file, fi);
            }
            for (File localFile : localFiles) {
                FileInformation fi = this.createFileInformation(localFile, null, REPOSITORY_STATUS_UNKNOWN);
                if (!fi.isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(localFile, fi);
            }
        }
        return folderFiles;
    }

    private FileInformation createFileInformation(File file, ISVNStatus status, ISVNStatus repositoryStatus) {
        if (status == null || status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            if (!this.svn.isManaged(file)) {
                return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            return this.createMissingEntryFileInformation(file, repositoryStatus);
        }
        return this.createVersionedFileInformation(file, status, repositoryStatus);
    }

    private FileInformation createVersionedFileInformation(File file, ISVNStatus status, ISVNStatus repositoryStatus) {
        SVNStatusKind kind = status.getTextStatus();
        SVNStatusKind pkind = status.getPropStatus();
        int remoteStatus = 0;
        if (repositoryStatus != REPOSITORY_STATUS_UNKNOWN) {
            if (repositoryStatus.getRepositoryTextStatus() == SVNStatusKind.MODIFIED || repositoryStatus.getRepositoryPropStatus() == SVNStatusKind.MODIFIED) {
                remoteStatus = 32;
            } else if (repositoryStatus.getRepositoryTextStatus() == SVNStatusKind.DELETED) {
                remoteStatus = 1024;
            } else if (repositoryStatus.getRepositoryTextStatus() != SVNStatusKind.ADDED && (repositoryStatus.getRepositoryTextStatus() != null || repositoryStatus.getRepositoryPropStatus() != null)) {
                System.err.println("SVN.FSC: unhandled repository status: " + file.getAbsolutePath());
                System.err.println("\ttext: " + repositoryStatus.getRepositoryTextStatus());
                System.err.println("\tprop: " + repositoryStatus.getRepositoryPropStatus());
            }
        }
        if (status.getLockOwner() != null) {
            remoteStatus = 0x2000 | remoteStatus;
        }
        if (!SVNStatusKind.NONE.equals((Object)pkind) && !SVNStatusKind.NORMAL.equals((Object)pkind)) {
            if (SVNStatusKind.MODIFIED.equals((Object)pkind)) {
                if (SVNStatusKind.NORMAL.equals((Object)kind)) {
                    return new FileInformation(0x10 | remoteStatus, status);
                }
            } else {
                if (SVNStatusKind.CONFLICTED.equals((Object)pkind)) {
                    return new FileInformation(0x40 | remoteStatus, status);
                }
                throw new IllegalArgumentException("Unknown prop status: " + status.getPropStatus());
            }
        }
        if (SVNStatusKind.NONE.equals((Object)kind)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (SVNStatusKind.NORMAL.equals((Object)kind)) {
            return new FileInformation(8 | remoteStatus, status);
        }
        if (SVNStatusKind.MODIFIED.equals((Object)kind)) {
            return new FileInformation(0x10 | remoteStatus, status);
        }
        if (SVNStatusKind.ADDED.equals((Object)kind)) {
            return new FileInformation(0x1000 | remoteStatus, status);
        }
        if (SVNStatusKind.DELETED.equals((Object)kind)) {
            return new FileInformation(0x100 | remoteStatus, status);
        }
        if (SVNStatusKind.UNVERSIONED.equals((Object)kind)) {
            return new FileInformation(4 | remoteStatus, status);
        }
        if (SVNStatusKind.MISSING.equals((Object)kind)) {
            return new FileInformation(0x800 | remoteStatus, status);
        }
        if (SVNStatusKind.REPLACED.equals((Object)kind)) {
            return new FileInformation(4 | remoteStatus, status);
        }
        if (SVNStatusKind.MERGED.equals((Object)kind)) {
            return new FileInformation(0x80 | remoteStatus, status);
        }
        if (SVNStatusKind.CONFLICTED.equals((Object)kind)) {
            return new FileInformation(0x40 | remoteStatus, status);
        }
        if (SVNStatusKind.OBSTRUCTED.equals((Object)kind)) {
            return new FileInformation(0x40 | remoteStatus, status);
        }
        if (SVNStatusKind.IGNORED.equals((Object)kind)) {
            return new FileInformation(2 | remoteStatus, status);
        }
        if (SVNStatusKind.INCOMPLETE.equals((Object)kind)) {
            return new FileInformation(0x40 | remoteStatus, status);
        }
        if (SVNStatusKind.EXTERNAL.equals((Object)kind)) {
            return new FileInformation(8 | remoteStatus, status);
        }
        throw new IllegalArgumentException("Unknown text status: " + status.getTextStatus());
    }

    static String statusText(ISVNStatus status) {
        return "file: " + status.getTextStatus().toString() + " copied: " + status.isCopied() + " prop: " + status.getPropStatus().toString();
    }

    private FileInformation createMissingEntryFileInformation(File file, ISVNStatus repositoryStatus) {
        String masterName;
        File master;
        File dir;
        boolean isDirectory = file.isDirectory();
        int parentStatus = this.getStatus(file.getParentFile()).getStatus();
        if (parentStatus == 2) {
            return isDirectory ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (parentStatus == 1) {
            if (isDirectory) {
                return SvnUtils.isPartOfSubversionMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        String name = file.getName();
        Matcher m = auxConflictPattern.matcher(name);
        if (m.matches() && (dir = file.getParentFile()) != null && (master = new File(dir, masterName = m.group(1))).isFile()) {
            return FILE_INFORMATION_EXCLUDED;
        }
        if (file.exists()) {
            if (Subversion.getInstance().isIgnored(file)) {
                return new FileInformation(2, file.isDirectory());
            }
            return new FileInformation(4, file.isDirectory());
        }
        if (repositoryStatus != REPOSITORY_STATUS_UNKNOWN && repositoryStatus.getRepositoryTextStatus() == SVNStatusKind.ADDED) {
            boolean folder = repositoryStatus.getNodeKind() == SVNNodeKind.DIR;
            return new FileInformation(512, folder);
        }
        return FILE_INFORMATION_UNKNOWN;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    private void fireFileStatusChanged(File file, FileInformation oldInfo, FileInformation newInfo) {
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, oldInfo, newInfo});
    }

    public void setCommand(int command) {
    }

    public void logCommandLine(String commandLine) {
    }

    public void logMessage(String message) {
    }

    public void logError(String message) {
    }

    public void logRevision(long revision, String path) {
    }

    public void logCompleted(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotify(File path, SVNNodeKind kind) {
        if (path == null) {
            return;
        }
        path = FileUtil.normalizeFile((File)path);
        this.refresh(path, REPOSITORY_STATUS_UNKNOWN, true);
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)path)) == null) continue;
            try {
                Set<FileSystem> filesystems;
                Set<FileSystem> set = filesystems = this.getFilesystemsToRefresh();
                synchronized (set) {
                    filesystems.add(fo.getFileSystem());
                }
            }
            catch (FileStateInvalidException e) {}
            break;
        } while ((path = path.getParentFile()) != null);
    }

    public void refreshDirtyFileSystems() {
        if (this.refreshFilesystemsTask == null) {
            RequestProcessor rp = new RequestProcessor();
            this.refreshFilesystemsTask = rp.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Set filesystems = FileStatusCache.this.getFilesystemsToRefresh();
                    FileSystem[] filesystemsToRefresh = new FileSystem[filesystems.size()];
                    Set set = filesystems;
                    synchronized (set) {
                        filesystemsToRefresh = filesystems.toArray(new FileSystem[filesystems.size()]);
                        filesystems.clear();
                    }
                    for (int i = 0; i < filesystemsToRefresh.length; ++i) {
                        filesystemsToRefresh[i].refresh(true);
                    }
                }
            });
        }
        this.refreshFilesystemsTask.schedule(200);
    }

    private Set<FileSystem> getFilesystemsToRefresh() {
        if (this.filesystemsToRefresh == null) {
            this.filesystemsToRefresh = new HashSet<FileSystem>();
        }
        return this.filesystemsToRefresh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<File, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

