/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.tigris.subversion.svnclientadapter.SVNClientException;

class FilesystemHandler
extends VCSInterceptor {
    private final Subversion svn;
    private final FileStatusCache cache;
    private final Set<File> invalidMetadata = new HashSet<File>(5);

    public FilesystemHandler(Subversion svn) {
        this.svn = svn;
        this.cache = svn.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return !file.isFile() && this.hasMetadata(file);
    }

    public void doDelete(File file) throws IOException {
        boolean isMetadata = SvnUtils.isPartOfSubversionMetadata(file);
        if (!isMetadata) {
            this.remove(file);
        }
    }

    public void afterDelete(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileDeletedImpl(file);
            }
        });
    }

    public boolean beforeMove(File from, File to) {
        FileInformation info;
        File destDir = to.getParentFile();
        if (from != null && destDir != null && ((info = this.cache.getStatus(from)).getStatus() & 0x1DF8) != 0) {
            return Subversion.getInstance().isManaged(to);
        }
        return false;
    }

    public void doMove(final File from, final File to) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Logger.getLogger("org.netbeans.modules.subversion").log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] innerT = new Throwable[1];
            Runnable outOfAwt = new Runnable(){

                public void run() {
                    try {
                        FilesystemHandler.this.svnMoveImplementation(from, to);
                    }
                    catch (Throwable t) {
                        innerT[0] = t;
                    }
                }
            };
            Subversion.getInstance().getRequestProcessor().post(outOfAwt).waitFinished();
            if (innerT[0] != null) {
                if (innerT[0] instanceof IOException) {
                    throw (IOException)innerT[0];
                }
                if (innerT[0] instanceof RuntimeException) {
                    throw (RuntimeException)innerT[0];
                }
                if (innerT[0] instanceof Error) {
                    throw (Error)innerT[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + innerT[0]);
            }
        } else {
            this.svnMoveImplementation(from, to);
        }
    }

    public void afterMove(final File from, final File to) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.cache.refresh(to, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                File parent = to.getParentFile();
                if (parent != null) {
                    if (from.equals(to)) {
                        ErrorManager.getDefault().log(16, "Wrong (identity) rename event for " + from.getAbsolutePath());
                    }
                    FilesystemHandler.this.cache.refresh(from, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    public boolean beforeCreate(File file, boolean isDirectory) {
        int status;
        if (this.svn.isAdministrative(file.getName())) {
            if (file.isDirectory()) {
                File f = new File(file, "invalid-metadata");
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().log(65536, "Unable to create marker: " + f.getAbsolutePath());
                }
                this.invalidMetadata.add(file);
            }
            return true;
        }
        if (!file.exists() && (status = this.cache.getStatus(file).getStatus()) == 256) {
            try {
                SvnClient client = Subversion.getInstance().getClient(true);
                client.revert(file, false);
                file.delete();
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
    }

    public void afterCreate(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if (file == null) {
                    return;
                }
                int status = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                if ((status & 0xFFFFFFFE) == 0) {
                    return;
                }
                if (file.isDirectory()) {
                    FilesystemHandler.this.cache.directoryContentChanged(file);
                }
            }
        });
    }

    public void afterChange(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refreshCached(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<File> set = this.invalidMetadata;
        synchronized (set) {
            for (File file : this.invalidMetadata) {
                Utils.deleteRecursively((File)file);
            }
            this.invalidMetadata.clear();
        }
    }

    private void fileDeletedImpl(File file) {
        if (file == null) {
            return;
        }
        int status = this.cache.getStatus(file).getStatus();
        if (status != 2 && status != 4) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false);
                client.remove(new File[]{file}, true);
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
        }
        this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private boolean hasMetadata(File file) {
        return new File(file, ".svn/entries").canRead() || new File(file, "_svn/entries").canRead();
    }

    private boolean remove(File file) {
        try {
            SvnClient client = Subversion.getInstance().getClient(false);
            client.remove(new File[]{file}, true);
            return true;
        }
        catch (SVNClientException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void svnMoveImplementation(File srcFile, File dstFile) throws IOException {
        try {
            boolean force = true;
            SvnClient client = Subversion.getInstance().getClient(false);
            File tmpMetadata = null;
            try {
                this.removeInvalidMetadata();
                File parent = dstFile.isDirectory() ? dstFile : dstFile.getParentFile();
                if (parent != null) {
                    int status = this.cache.getStatus(parent).getStatus();
                    assert (Subversion.getInstance().isManaged(parent));
                    if ((0x1DF8 & status) == 0) {
                        this.addDirectories(parent);
                    }
                }
                int retryCounter = 6;
                while (true) {
                    try {
                        client.move(srcFile, dstFile, force);
                    }
                    catch (SVNClientException e) {
                        if (e.getMessage().endsWith("' locked") && retryCounter > 0) {
                            try {
                                Thread.sleep(107L);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            --retryCounter;
                            continue;
                        }
                        if (srcFile.renameTo(dstFile)) {
                            ErrorManager.getDefault().annotate((Throwable)e, "Relaxing Subversion rename error....");
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                            break;
                        }
                        IOException ex = new IOException("Subversion failed to rename " + srcFile.getAbsolutePath() + " to: " + dstFile.getAbsolutePath());
                        ex.initCause(e);
                        throw ex;
                    }
                    break;
                }
            }
            finally {
                if (tmpMetadata != null) {
                    FileUtils.deleteRecursively(tmpMetadata);
                }
            }
        }
        catch (SVNClientException e) {
            IOException ex = new IOException("Subversion failed to rename " + srcFile.getAbsolutePath() + " to: " + dstFile.getAbsolutePath());
            ex.initCause(e);
            throw ex;
        }
    }

    private void addDirectories(File dir) throws SVNClientException {
        File parent = dir.getParentFile();
        if (parent != null) {
            int status = this.cache.getStatus(parent).getStatus();
            if ((0x1DF8 & status) == 0) {
                this.addDirectories(parent);
            }
        } else {
            throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
        }
        SvnClient client = Subversion.getInstance().getClient(false);
        client.addDirectory(dir, false);
        this.cache.refresh(dir, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }
}

